/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.glide.transformations.gpu;

import androidx.annotation.NonNull;
import java.security.MessageDigest;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageFilter;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageToonFilter;
import jp.wasabeef.glide.transformations.gpu.GPUFilterTransformation;

public class ToonFilterTransformation
extends GPUFilterTransformation {
    private static final int VERSION = 1;
    private static final String ID = "jp.wasabeef.glide.transformations.gpu.ToonFilterTransformation.1";
    private final float threshold;
    private final float quantizationLevels;

    public ToonFilterTransformation() {
        this(0.2f, 10.0f);
    }

    public ToonFilterTransformation(float threshold, float quantizationLevels) {
        super((GPUImageFilter)new GPUImageToonFilter());
        this.threshold = threshold;
        this.quantizationLevels = quantizationLevels;
        GPUImageToonFilter filter = (GPUImageToonFilter)this.getFilter();
        filter.setThreshold(this.threshold);
        filter.setQuantizationLevels(this.quantizationLevels);
    }

    @Override
    public String toString() {
        return "ToonFilterTransformation(threshold=" + this.threshold + ",quantizationLevels=" + this.quantizationLevels + ")";
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof ToonFilterTransformation && ((ToonFilterTransformation)o).threshold == this.threshold && ((ToonFilterTransformation)o).quantizationLevels == this.quantizationLevels;
    }

    @Override
    public int hashCode() {
        return ID.hashCode() + (int)(this.threshold * 1000.0f) + (int)(this.quantizationLevels * 10.0f);
    }

    @Override
    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
        messageDigest.update((ID + this.threshold + this.quantizationLevels).getBytes(CHARSET));
    }
}

