/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.glide.transformations;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.RectF;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;

public class CropTransformation
implements Transformation<Bitmap> {
    private BitmapPool mBitmapPool;
    private int mWidth;
    private int mHeight;
    private CropType mCropType = CropType.CENTER;

    public CropTransformation(BitmapPool pool) {
        this.mBitmapPool = pool;
    }

    public CropTransformation(BitmapPool pool, int width, int height) {
        this.mBitmapPool = pool;
        this.mWidth = width;
        this.mHeight = height;
    }

    public CropTransformation(BitmapPool pool, int width, int height, CropType cropType) {
        this.mBitmapPool = pool;
        this.mWidth = width;
        this.mHeight = height;
        this.mCropType = cropType;
    }

    public Resource<Bitmap> transform(Resource<Bitmap> resource, int outWidth, int outHeight) {
        Bitmap.Config config;
        Bitmap bitmap;
        Bitmap source = (Bitmap)resource.get();
        if (this.mWidth == 0) {
            this.mWidth = source.getWidth();
        }
        if (this.mHeight == 0) {
            this.mHeight = source.getHeight();
        }
        if ((bitmap = this.mBitmapPool.get(this.mWidth, this.mHeight, config = source.getConfig() != null ? source.getConfig() : Bitmap.Config.ARGB_8888)) == null) {
            bitmap = Bitmap.createBitmap((int)this.mWidth, (int)this.mHeight, (Bitmap.Config)config);
        }
        float scaleX = (float)this.mWidth / (float)source.getWidth();
        float scaleY = (float)this.mHeight / (float)source.getHeight();
        float scale = Math.max(scaleX, scaleY);
        float scaledWidth = scale * (float)source.getWidth();
        float scaledHeight = scale * (float)source.getHeight();
        float left = ((float)this.mWidth - scaledWidth) / 2.0f;
        float top = this.getTop(scaledHeight);
        RectF targetRect = new RectF(left, top, left + scaledWidth, top + scaledHeight);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawBitmap(source, null, targetRect, null);
        return BitmapResource.obtain((Bitmap)bitmap, (BitmapPool)this.mBitmapPool);
    }

    public String getId() {
        return "CropTransformation(width=" + this.mWidth + ", height=" + this.mHeight + ", cropType=" + (Object)((Object)this.mCropType) + ")";
    }

    private float getTop(float scaledHeight) {
        switch (this.mCropType) {
            case TOP: {
                return 0.0f;
            }
            case CENTER: {
                return ((float)this.mHeight - scaledHeight) / 2.0f;
            }
            case BOTTOM: {
                return (float)this.mHeight - scaledHeight;
            }
        }
        return 0.0f;
    }

    public static enum CropType {
        TOP,
        CENTER,
        BOTTOM;

    }
}

