/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.picasso.transformations.gpu;

import android.content.Context;
import android.graphics.Bitmap;
import com.squareup.picasso.Transformation;
import jp.co.cyberagent.android.gpuimage.GPUImage;
import jp.co.cyberagent.android.gpuimage.GPUImageFilter;
import jp.co.cyberagent.android.gpuimage.GPUImageKuwaharaFilter;

public class KuwaharaFilterTransformation
implements Transformation {
    private Context mContext;
    private GPUImageKuwaharaFilter mFilter = new GPUImageKuwaharaFilter();
    private int mRadius;

    public KuwaharaFilterTransformation(Context context) {
        this.mContext = context;
    }

    public KuwaharaFilterTransformation(Context context, int radius) {
        this.mContext = context;
        this.mRadius = radius;
        this.mFilter.setRadius(this.mRadius);
    }

    public Bitmap transform(Bitmap source) {
        GPUImage gpuImage = new GPUImage(this.mContext);
        gpuImage.setImage(source);
        gpuImage.setFilter((GPUImageFilter)this.mFilter);
        Bitmap bitmap = gpuImage.getBitmapWithFilterApplied();
        source.recycle();
        return bitmap;
    }

    public String key() {
        return "KuwaharaFilterTransformation(radius=" + this.mRadius + ")";
    }
}

