/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cyberagent.android.gpuimage;

import android.graphics.PointF;
import android.opengl.GLES20;
import jp.co.cyberagent.android.gpuimage.GPUImageFilter;

public class GPUImageBulgeDistortionFilter
extends GPUImageFilter {
    public static final String BULGE_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\n\nuniform sampler2D inputImageTexture;\n\nuniform highp float aspectRatio;\nuniform highp vec2 center;\nuniform highp float radius;\nuniform highp float scale;\n\nvoid main()\n{\nhighp vec2 textureCoordinateToUse = vec2(textureCoordinate.x, (textureCoordinate.y * aspectRatio + 0.5 - 0.5 * aspectRatio));\nhighp float dist = distance(center, textureCoordinateToUse);\ntextureCoordinateToUse = textureCoordinate;\n\nif (dist < radius)\n{\ntextureCoordinateToUse -= center;\nhighp float percent = 1.0 - ((radius - dist) / radius) * scale;\npercent = percent * percent;\n\ntextureCoordinateToUse = textureCoordinateToUse * percent;\ntextureCoordinateToUse += center;\n}\n\ngl_FragColor = texture2D(inputImageTexture, textureCoordinateToUse );    \n}\n";
    private float mScale;
    private int mScaleLocation;
    private float mRadius;
    private int mRadiusLocation;
    private PointF mCenter;
    private int mCenterLocation;
    private float mAspectRatio;
    private int mAspectRatioLocation;

    public GPUImageBulgeDistortionFilter() {
        this(0.25f, 0.5f, new PointF(0.5f, 0.5f));
    }

    public GPUImageBulgeDistortionFilter(float radius, float scale, PointF center) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", BULGE_FRAGMENT_SHADER);
        this.mRadius = radius;
        this.mScale = scale;
        this.mCenter = center;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.mScaleLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"scale");
        this.mRadiusLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"radius");
        this.mCenterLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"center");
        this.mAspectRatioLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"aspectRatio");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        this.setRadius(this.mRadius);
        this.setScale(this.mScale);
        this.setCenter(this.mCenter);
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        this.mAspectRatio = (float)height / (float)width;
        this.setAspectRatio(this.mAspectRatio);
        super.onOutputSizeChanged(width, height);
    }

    private void setAspectRatio(float aspectRatio) {
        this.mAspectRatio = aspectRatio;
        this.setFloat(this.mAspectRatioLocation, aspectRatio);
    }

    public void setRadius(float radius) {
        this.mRadius = radius;
        this.setFloat(this.mRadiusLocation, radius);
    }

    public void setScale(float scale) {
        this.mScale = scale;
        this.setFloat(this.mScaleLocation, scale);
    }

    public void setCenter(PointF center) {
        this.mCenter = center;
        this.setPoint(this.mCenterLocation, center);
    }
}

