/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import junit.framework.TestCase;
import org.jgroups.blocks.RpcDispatcherAnycastTestServerObject;

public class RpcDispatcherAnycastMultipleCallsTest
extends TestCase {
    private RpcDispatcherAnycastTestServerObject[] targets = null;

    protected void tearDown() throws Exception {
        if (this.targets != null) {
            for (int i = 0; i < this.targets.length; ++i) {
                if (this.targets[i] != null) {
                    this.targets[i].shutdown();
                }
                this.targets[i] = null;
            }
            this.targets = null;
        }
        super.tearDown();
    }

    public void test2InstancesAnycastIncludeSelf() throws Exception {
        this.performTest(true, 2, false);
    }

    public void test3InstancesAnycastIncludeSelf() throws Exception {
        this.performTest(true, 3, false);
    }

    public void test2InstancesMcastIncludeSelf() throws Exception {
        this.performTest(false, 2, false);
    }

    public void test3InstancesMcastIncludeSelf() throws Exception {
        this.performTest(false, 3, false);
    }

    public void test2InstancesAnycastExcludeSelf() throws Exception {
        this.performTest(true, 2, true);
    }

    public void test3InstancesAnycastExcludeSelf() throws Exception {
        this.performTest(true, 3, true);
    }

    public void test2InstancesMcastExcludeSelf() throws Exception {
        this.performTest(false, 2, true);
    }

    public void test3InstancesMcastExcludeSelf() throws Exception {
        this.performTest(false, 3, true);
    }

    private void performTest(boolean useAnycast, int n, boolean excludeSelf) throws Exception {
        int i;
        this.targets = new RpcDispatcherAnycastTestServerObject[n];
        for (i = 0; i < n; ++i) {
            this.targets[i] = new RpcDispatcherAnycastTestServerObject();
        }
        for (i = 0; i < n; ++i) {
            RpcDispatcherAnycastMultipleCallsTest.assertEquals((int)0, (int)this.targets[i].i);
        }
        int value = 0;
        int[] expectedValues = null;
        if (excludeSelf) {
            expectedValues = new int[n];
            for (int i2 = 0; i2 < n; ++i2) {
                expectedValues[i2] = 0;
            }
        }
        for (int instances = 0; instances < n; ++instances) {
            int i3;
            this.targets[instances].callRemote(useAnycast, excludeSelf);
            if (excludeSelf) {
                for (i3 = 0; i3 < n; ++i3) {
                    if (i3 == instances) continue;
                    int n2 = i3;
                    expectedValues[n2] = expectedValues[n2] + 1;
                }
                for (i3 = 0; i3 < n; ++i3) {
                    RpcDispatcherAnycastMultipleCallsTest.assertEquals((String)("Failure when invoking call on instance " + instances + ".  Did not reach instance " + i3 + "."), (int)expectedValues[i3], (int)this.targets[i3].i);
                }
                continue;
            }
            ++value;
            for (i3 = 0; i3 < n; ++i3) {
                RpcDispatcherAnycastMultipleCallsTest.assertEquals((String)("Failure when invoking call on instance " + instances + ".  Did not reach instance " + i3 + "."), (int)value, (int)this.targets[i3].i);
            }
        }
    }
}

