/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.Transport;
import org.jgroups.View;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RspCollector;
import org.jgroups.util.Command;
import org.jgroups.util.RspList;

public class GroupRequest
implements RspCollector,
Command {
    public static final int GET_FIRST = 1;
    public static final int GET_ALL = 2;
    public static final int GET_MAJORITY = 3;
    public static final int GET_ABS_MAJORITY = 4;
    public static final int GET_N = 5;
    public static final int GET_NONE = 6;
    private static final short NOT_RECEIVED = 0;
    private static final short RECEIVED = 1;
    private static final short SUSPECTED = 2;
    private Address[] membership = null;
    private Object[] responses = null;
    private short[] received = null;
    private final Vector suspects = new Vector();
    private final Vector members = new Vector();
    private final int max_suspects = 40;
    protected Message request_msg = null;
    protected RequestCorrelator corr = null;
    protected Transport transport = null;
    protected int rsp_mode = 2;
    protected boolean done = false;
    protected final Object rsp_mutex = new Object();
    protected long timeout = 0L;
    protected int expected_mbrs = 0;
    protected static final Log log = LogFactory.getLog((Class)GroupRequest.class);
    private static long last_req_id = 1L;
    protected long req_id = -1L;

    public GroupRequest(Message m, RequestCorrelator corr, Vector members, int rsp_mode) {
        this.request_msg = m;
        this.corr = corr;
        this.rsp_mode = rsp_mode;
        this.reset(members);
    }

    public GroupRequest(Message m, RequestCorrelator corr, Vector members, int rsp_mode, long timeout, int expected_mbrs) {
        this(m, corr, members, rsp_mode);
        if (timeout > 0L) {
            this.timeout = timeout;
        }
        this.expected_mbrs = expected_mbrs;
    }

    public GroupRequest(Message m, Transport transport, Vector members, int rsp_mode) {
        this.request_msg = m;
        this.transport = transport;
        this.rsp_mode = rsp_mode;
        this.reset(members);
    }

    public GroupRequest(Message m, Transport transport, Vector members, int rsp_mode, long timeout, int expected_mbrs) {
        this(m, transport, members, rsp_mode);
        if (timeout > 0L) {
            this.timeout = timeout;
        }
        this.expected_mbrs = expected_mbrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        if (this.corr == null && this.transport == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"both corr and transport are null, cannot send group request");
            }
            return false;
        }
        Object object = this.rsp_mutex;
        synchronized (object) {
            this.done = false;
            boolean retval = this.doExecute(this.timeout);
            if (!retval && log.isTraceEnabled()) {
                log.trace((Object)("call did not execute correctly, request is " + this.toString()));
            }
            this.done = true;
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(Message m, int mode, long timeout) {
        Object object = this.rsp_mutex;
        synchronized (object) {
            this.done = false;
            this.request_msg = m;
            this.rsp_mode = mode;
            this.timeout = timeout;
            this.rsp_mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(Message m, Vector members, int rsp_mode, long timeout, int expected_rsps) {
        Object object = this.rsp_mutex;
        synchronized (object) {
            this.reset(m, rsp_mode, timeout);
            this.reset(members);
            this.expected_mbrs = expected_rsps;
            this.rsp_mutex.notifyAll();
        }
    }

    public void reset(Vector mbrs) {
        if (mbrs != null) {
            int size = mbrs.size();
            this.membership = new Address[size];
            this.responses = new Object[size];
            this.received = new short[size];
            for (int i = 0; i < size; ++i) {
                this.membership[i] = (Address)mbrs.elementAt(i);
                this.responses[i] = null;
                this.received[i] = 0;
            }
            this.members.clear();
            this.members.addAll(mbrs);
        } else if (this.membership != null) {
            for (int i = 0; i < this.membership.length; ++i) {
                this.responses[i] = null;
                this.received[i] = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveResponse(Message m) {
        Object val;
        Address sender;
        block12: {
            sender = m.getSrc();
            val = null;
            if (this.done) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"command is done; cannot add response !");
                }
                return;
            }
            if (this.suspects != null && this.suspects.size() > 0 && this.suspects.contains(sender)) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("received response from suspected member " + sender + "; discarding"));
                }
                return;
            }
            if (m.getLength() > 0) {
                try {
                    val = m.getObject();
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block12;
                    log.error((Object)("exception=" + e));
                }
            }
        }
        Object object = this.rsp_mutex;
        synchronized (object) {
            for (int i = 0; i < this.membership.length; ++i) {
                Address mbr = this.membership[i];
                if (!mbr.equals(sender) || this.received[i] != 0) continue;
                this.responses[i] = val;
                this.received[i] = 1;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("received response for request " + this.req_id + ", sender=" + sender + ", val=" + val));
                }
                this.rsp_mutex.notifyAll();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspect(Address suspected_member) {
        Object object = this.rsp_mutex;
        synchronized (object) {
            for (int i = 0; i < this.membership.length; ++i) {
                Address mbr = this.membership[i];
                if (!mbr.equals(suspected_member)) continue;
                this.addSuspect(suspected_member);
                this.responses[i] = null;
                this.received[i] = 2;
                this.rsp_mutex.notifyAll();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void viewChange(View new_view) {
        Vector mbrs;
        Vector vector = mbrs = new_view != null ? new_view.getMembers() : null;
        if (this.membership == null || this.membership.length == 0 || mbrs == null) {
            return;
        }
        Object object = this.rsp_mutex;
        synchronized (object) {
            this.members.clear();
            this.members.addAll(mbrs);
            for (int i = 0; i < this.membership.length; ++i) {
                Address mbr = this.membership[i];
                if (mbrs.contains(mbr)) continue;
                this.addSuspect(mbr);
                this.responses[i] = null;
                this.received[i] = 2;
            }
            this.rsp_mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RspList getResults() {
        RspList retval = new RspList();
        Object object = this.rsp_mutex;
        synchronized (object) {
            block8: for (int i = 0; i < this.membership.length; ++i) {
                Address sender = this.membership[i];
                switch (this.received[i]) {
                    case 2: {
                        retval.addSuspect(sender);
                        continue block8;
                    }
                    case 1: {
                        retval.addRsp(sender, this.responses[i]);
                        continue block8;
                    }
                    case 0: {
                        retval.addNotReceived(sender);
                    }
                }
            }
            return retval;
        }
    }

    public String toString() {
        int i;
        StringBuffer ret = new StringBuffer();
        ret.append("[GroupRequest:\n");
        ret.append("req_id=").append(this.req_id).append('\n');
        ret.append("members: ");
        for (i = 0; i < this.membership.length; ++i) {
            ret.append(this.membership[i] + " ");
        }
        ret.append("\nresponses: ");
        for (i = 0; i < this.responses.length; ++i) {
            ret.append(this.responses[i] + " ");
        }
        ret.append("\nreceived: ");
        for (i = 0; i < this.received.length; ++i) {
            ret.append(this.receivedToString(this.received[i]) + " ");
        }
        if (this.suspects.size() > 0) {
            ret.append("\nsuspects: " + this.suspects);
        }
        ret.append("\nrequest_msg: " + this.request_msg);
        ret.append("\nrsp_mode: " + this.rsp_mode);
        ret.append("\ndone: " + this.done);
        ret.append("\ntimeout: " + this.timeout);
        ret.append("\nexpected_mbrs: " + this.expected_mbrs);
        ret.append("\n]");
        return ret.toString();
    }

    public int getNumSuspects() {
        return this.suspects.size();
    }

    public Vector getSuspects() {
        return this.suspects;
    }

    public boolean isDone() {
        return this.done;
    }

    protected int determineMajority(int i) {
        return i < 2 ? i : i / 2 + 1;
    }

    private static synchronized long getRequestId() {
        long result = System.currentTimeMillis();
        if (result <= last_req_id) {
            result = last_req_id + 1L;
        }
        last_req_id = result;
        return result;
    }

    protected boolean doExecute(long timeout) {
        long start_time = 0L;
        this.req_id = GroupRequest.getRequestId();
        this.reset(null);
        if (this.suspects != null) {
            block6: for (int i = 0; i < this.suspects.size(); ++i) {
                Address suspect = (Address)this.suspects.elementAt(i);
                for (int j = 0; j < this.membership.length; ++j) {
                    Address mbr = this.membership[j];
                    if (!mbr.equals(suspect)) continue;
                    this.received[j] = 2;
                    continue block6;
                }
            }
        }
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("sending request (id=" + this.req_id + ')'));
            }
            if (this.corr != null) {
                Vector tmp = this.members != null ? this.members : null;
                this.corr.sendRequest(this.req_id, tmp, this.request_msg, this.rsp_mode == 6 ? null : this);
            } else {
                this.transport.send(this.request_msg);
            }
        }
        catch (Throwable e) {
            log.error((Object)("exception=" + e));
            if (this.corr != null) {
                this.corr.done(this.req_id);
            }
            return false;
        }
        if (timeout <= 0L) {
            while (true) {
                this.adjustMembership();
                if (this.getResponses()) {
                    if (this.corr != null) {
                        this.corr.done(this.req_id);
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("received all responses: " + this.toString()));
                    }
                    return true;
                }
                try {
                    this.rsp_mutex.wait();
                }
                catch (Exception e) {}
            }
        }
        start_time = System.currentTimeMillis();
        while (timeout > 0L) {
            if (this.getResponses()) {
                if (this.corr != null) {
                    this.corr.done(this.req_id);
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("received all responses: " + this.toString()));
                }
                return true;
            }
            if ((timeout -= System.currentTimeMillis() - start_time) <= 0L) continue;
            try {
                this.rsp_mutex.wait(timeout);
            }
            catch (Exception e) {}
        }
        if (this.corr != null) {
            this.corr.done(this.req_id);
        }
        return false;
    }

    protected boolean getResponses() {
        int num_not_received = this.getNum(0);
        int num_received = this.getNum(1);
        int num_suspected = this.getNum(2);
        int num_total = this.membership.length;
        int majority = this.determineMajority(num_total);
        switch (this.rsp_mode) {
            case 1: {
                if (num_received > 0) {
                    return true;
                }
                if (num_suspected < num_total) break;
                return true;
            }
            case 2: {
                return num_not_received <= 0;
            }
            case 3: {
                if (num_received + num_suspected < majority) break;
                return true;
            }
            case 4: {
                if (num_received < majority) break;
                return true;
            }
            case 5: {
                if (this.expected_mbrs >= num_total) {
                    this.rsp_mode = 2;
                    return this.getResponses();
                }
                if (num_received >= this.expected_mbrs) {
                    return true;
                }
                if (num_received + num_not_received < this.expected_mbrs) {
                    return num_received + num_suspected >= this.expected_mbrs;
                }
                return false;
            }
            case 6: {
                return true;
            }
            default: {
                if (!log.isErrorEnabled()) break;
                log.error((Object)("rsp_mode " + this.rsp_mode + " unknown !"));
            }
        }
        return false;
    }

    int getNum(int type) {
        int retval = 0;
        for (int i = 0; i < this.received.length; ++i) {
            if (this.received[i] != type) continue;
            ++retval;
        }
        return retval;
    }

    private String receivedToString(int r) {
        switch (r) {
            case 1: {
                return "RECEIVED";
            }
            case 0: {
                return "NOR_RECEIVED";
            }
            case 2: {
                return "SUSPECTED";
            }
        }
        return "n/a";
    }

    void adjustMembership() {
        if (this.membership == null || this.membership.length == 0) {
            return;
        }
        for (int i = 0; i < this.membership.length; ++i) {
            Address mbr = this.membership[i];
            if ((this.members == null || this.members.contains(mbr)) && !this.suspects.contains(mbr)) continue;
            this.addSuspect(mbr);
            this.responses[i] = null;
            this.received[i] = 2;
        }
    }

    void addSuspect(Address suspected_mbr) {
        if (!this.suspects.contains(suspected_mbr)) {
            this.suspects.addElement(suspected_mbr);
            while (this.suspects.size() >= 40 && this.suspects.size() > 0) {
                this.suspects.remove(0);
            }
        }
    }
}

