/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Message;
import org.jgroups.util.Range;
import org.jgroups.util.Util;

public class MessageTest
extends TestCase {
    Message m1;
    Message m2;
    static /* synthetic */ Class class$org$jgroups$tests$MessageTest;

    public MessageTest(String name) {
        super(name);
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public void testBufferSize() throws Exception {
        this.m1 = new Message(null, null, (Serializable)((Object)"bela"));
        MessageTest.assertNotNull((Object)this.m1.getRawBuffer());
        MessageTest.assertNotNull((Object)this.m1.getBuffer());
        MessageTest.assertEquals((int)this.m1.getBuffer().length, (int)this.m1.getLength());
        byte[] new_buf = new byte[]{109, 105, 99, 104, 101, 108, 108, 101};
        this.m1.setBuffer(new_buf);
        MessageTest.assertNotNull((Object)this.m1.getRawBuffer());
        MessageTest.assertNotNull((Object)this.m1.getBuffer());
        MessageTest.assertEquals((int)new_buf.length, (int)this.m1.getLength());
        MessageTest.assertEquals((int)this.m1.getBuffer().length, (int)this.m1.getLength());
    }

    public void testBufferOffset() throws Exception {
        byte[] buf = new byte[]{98, 101, 108, 97, 98, 97, 110};
        this.m1 = new Message(null, null, buf, 0, 4);
        this.m2 = new Message(null, null, buf, 4, 3);
        byte[] b1 = new byte[this.m1.getLength()];
        System.arraycopy(this.m1.getRawBuffer(), this.m1.getOffset(), b1, 0, this.m1.getLength());
        byte[] b2 = new byte[this.m2.getLength()];
        System.arraycopy(this.m2.getRawBuffer(), this.m2.getOffset(), b2, 0, this.m2.getLength());
        MessageTest.assertEquals((int)4, (int)b1.length);
        MessageTest.assertEquals((int)3, (int)b2.length);
    }

    public void testInvalidOffset() {
        byte[] buf = new byte[]{98, 101, 108, 97, 98, 97, 110};
        try {
            this.m1 = new Message(null, null, buf, -1, 4);
            MessageTest.fail((String)"we should not get here (offset is -1)");
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            MessageTest.assertTrue((String)"correct: offset is invalid (caught correctly)", (boolean)true);
        }
    }

    public void testInvalidLength() {
        byte[] buf = new byte[]{98, 101, 108, 97, 98, 97, 110};
        try {
            this.m1 = new Message(null, null, buf, 3, 6);
            MessageTest.fail((String)"we should not get here (length is 9)");
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            MessageTest.assertTrue((String)"correct: length is invalid (caught correctly)", (boolean)true);
        }
    }

    public void testGetRawBuffer() {
        byte[] buf = new byte[]{98, 101, 108, 97, 98, 97, 110};
        this.m1 = new Message(null, null, buf, 0, 4);
        this.m2 = new Message(null, null, buf, 4, 3);
        MessageTest.assertEquals((int)buf.length, (int)this.m1.getRawBuffer().length);
        MessageTest.assertEquals((int)4, (int)this.m1.getBuffer().length);
        MessageTest.assertEquals((int)4, (int)this.m1.getLength());
        MessageTest.assertEquals((int)buf.length, (int)this.m2.getRawBuffer().length);
        MessageTest.assertEquals((int)3, (int)this.m2.getBuffer().length);
        MessageTest.assertEquals((int)3, (int)this.m2.getLength());
    }

    public void testSerialization() throws Exception {
        byte[] buf = new byte[]{98, 101, 108, 97, 98, 97, 110};
        this.m1 = new Message(null, null, buf, 0, 4);
        this.m2 = new Message(null, null, buf, 4, 3);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(output);
        out.writeObject(this.m1);
        output.close();
        byte[] tmp = output.toByteArray();
        ByteArrayInputStream input = new ByteArrayInputStream(tmp);
        ObjectInputStream in = new ObjectInputStream(input);
        Message m3 = (Message)in.readObject();
        MessageTest.assertEquals((int)4, (int)m3.getLength());
        MessageTest.assertEquals((int)4, (int)m3.getRawBuffer().length);
        MessageTest.assertEquals((int)4, (int)m3.getBuffer().length);
        MessageTest.assertEquals((int)0, (int)m3.getOffset());
        output = new ByteArrayOutputStream();
        out = new ObjectOutputStream(output);
        out.writeObject(this.m2);
        output.close();
        tmp = output.toByteArray();
        input = new ByteArrayInputStream(tmp);
        in = new ObjectInputStream(input);
        Message m4 = (Message)in.readObject();
        MessageTest.assertEquals((int)3, (int)m4.getLength());
        MessageTest.assertEquals((int)3, (int)m4.getBuffer().length);
        MessageTest.assertEquals((int)3, (int)m4.getRawBuffer().length);
        MessageTest.assertEquals((int)0, (int)m4.getOffset());
    }

    public void testSetObject() {
        String s1 = "Bela Ban";
        this.m1 = new Message(null, null, (Serializable)((Object)s1));
        MessageTest.assertEquals((int)0, (int)this.m1.getOffset());
        MessageTest.assertEquals((int)this.m1.getBuffer().length, (int)this.m1.getLength());
        String s2 = (String)this.m1.getObject();
        MessageTest.assertEquals((String)s2, (String)s1);
    }

    public void testReset() {
        this.m1 = new Message(null, null, (Serializable)((Object)"Bela Ban"));
        this.m1.reset();
        MessageTest.assertEquals((int)0, (int)this.m1.getOffset());
        MessageTest.assertEquals((int)0, (int)this.m1.getLength());
        MessageTest.assertNull((Object)this.m1.getBuffer());
        MessageTest.assertNull((Object)this.m1.getRawBuffer());
    }

    public void testCopy() {
        this.m1 = new Message(null, null, (Serializable)((Object)"Bela Ban"));
        this.m2 = this.m1.copy();
        MessageTest.assertEquals((int)this.m1.getOffset(), (int)this.m2.getOffset());
        MessageTest.assertEquals((int)this.m1.getLength(), (int)this.m2.getLength());
    }

    public void testCopyWithOffset() {
        byte[] buf = new byte[]{98, 101, 108, 97, 98, 97, 110};
        this.m1 = new Message(null, null, buf, 0, 4);
        this.m2 = new Message(null, null, buf, 4, 3);
        Message m3 = this.m1.copy();
        Message m4 = this.m2.copy();
        MessageTest.assertEquals((int)0, (int)m3.getOffset());
        MessageTest.assertEquals((int)4, (int)m3.getLength());
        MessageTest.assertEquals((int)4, (int)m3.getBuffer().length);
        MessageTest.assertEquals((int)4, (int)m4.getOffset());
        MessageTest.assertEquals((int)3, (int)m4.getLength());
        MessageTest.assertEquals((int)3, (int)m4.getBuffer().length);
    }

    public void testComputeFragOffsets() {
        byte[] buf = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        List retval = Util.computeFragOffsets(buf, 4);
        System.out.println("list is " + retval);
        MessageTest.assertEquals((int)3, (int)retval.size());
        Range r = (Range)retval.get(0);
        MessageTest.assertEquals((long)0L, (long)r.low);
        MessageTest.assertEquals((long)4L, (long)r.high);
        r = (Range)retval.get(1);
        MessageTest.assertEquals((long)4L, (long)r.low);
        MessageTest.assertEquals((long)4L, (long)r.high);
        r = (Range)retval.get(2);
        MessageTest.assertEquals((long)8L, (long)r.low);
        MessageTest.assertEquals((long)2L, (long)r.high);
    }

    public void testComputeFragOffsetsWithOffsets() {
        List retval = Util.computeFragOffsets(3, 10, 4);
        System.out.println("list is " + retval);
        MessageTest.assertEquals((int)3, (int)retval.size());
        Range r = (Range)retval.get(0);
        MessageTest.assertEquals((long)3L, (long)r.low);
        MessageTest.assertEquals((long)4L, (long)r.high);
        r = (Range)retval.get(1);
        MessageTest.assertEquals((long)7L, (long)r.low);
        MessageTest.assertEquals((long)4L, (long)r.high);
        r = (Range)retval.get(2);
        MessageTest.assertEquals((long)11L, (long)r.low);
        MessageTest.assertEquals((long)2L, (long)r.high);
    }

    public void testComputeFragOffsets2() {
        byte[] buf = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        List retval = Util.computeFragOffsets(buf, 10);
        System.out.println("list is " + retval);
        MessageTest.assertEquals((int)1, (int)retval.size());
        Range r = (Range)retval.get(0);
        MessageTest.assertEquals((long)0L, (long)r.low);
        MessageTest.assertEquals((long)10L, (long)r.high);
    }

    public void testComputeFragOffsets3() {
        byte[] buf = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        List retval = Util.computeFragOffsets(buf, 100);
        System.out.println("list is " + retval);
        MessageTest.assertEquals((int)1, (int)retval.size());
        Range r = (Range)retval.get(0);
        MessageTest.assertEquals((long)0L, (long)r.low);
        MessageTest.assertEquals((long)10L, (long)r.high);
    }

    public void testComputeFragOffsets4() {
        byte[] buf = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        List retval = Util.computeFragOffsets(buf, 5);
        System.out.println("list is " + retval);
        MessageTest.assertEquals((int)2, (int)retval.size());
        Range r = (Range)retval.get(0);
        MessageTest.assertEquals((long)0L, (long)r.low);
        MessageTest.assertEquals((long)5L, (long)r.high);
        r = (Range)retval.get(1);
        MessageTest.assertEquals((long)5L, (long)r.low);
        MessageTest.assertEquals((long)5L, (long)r.high);
    }

    public static Test suite() {
        TestSuite s = new TestSuite(class$org$jgroups$tests$MessageTest == null ? (class$org$jgroups$tests$MessageTest = MessageTest.class$("org.jgroups.tests.MessageTest")) : class$org$jgroups$tests$MessageTest);
        return s;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)MessageTest.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

