/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.stack.MessageProtocol;
import org.jgroups.util.ReusableThread;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class FLOW_CONTROL
extends MessageProtocol
implements Runnable {
    private int _numMSGsSentThisPeriod = 0;
    private static final String FLOW_CONTROL = "FLOW_CONTROL";
    private HashMap _rcvdMSGCounter = new HashMap();
    private int _windowSize = 1000;
    private int _fwdMarginSize = 200;
    private int _estimatedRTT = 100000;
    private boolean waitingForResponse = false;
    private ReusableThread _reusableThread = new ReusableThread("FLOW_CONTROL");
    private double RTT_WEIGHT = 0.125;
    private int _msgsSentAfterFCreq = 0;
    private double TIME_OUT_FACTOR = 0.25;
    private double TIME_OUT_INCR_MULT = 1.25;
    private double WINDOW_SIZE_REDUCTION = 0.75;
    private double WINDOW_SIZE_EXPANSION = 1.25;
    private boolean isBlockState = false;
    private int _windowsize_cap = 1000000;

    public String getName() {
        return FLOW_CONTROL;
    }

    public boolean handleDownEvent(Event evt) {
        if (evt.getType() == 1) {
            ++this._numMSGsSentThisPeriod;
            if (this._numMSGsSentThisPeriod > this._windowSize - this._fwdMarginSize && !this.waitingForResponse) {
                this.waitingForResponse = true;
                this._reusableThread.waitUntilDone();
                this._reusableThread.assignTask(this);
            }
            if (this.waitingForResponse) {
                ++this._msgsSentAfterFCreq;
                if (this._msgsSentAfterFCreq >= this._fwdMarginSize && !this.isBlockState) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)"ACTION BLOCK");
                    }
                    System.err.println("0;" + System.currentTimeMillis() + ';' + this._windowSize);
                    this.passUp(new Event(54));
                    this.isBlockState = true;
                }
            }
        }
        return true;
    }

    public boolean handleUpEvent(Event evt) {
        if (evt.getType() == 1) {
            Message msg = (Message)evt.getArg();
            Address src = msg.getSrc();
            FCInfo fcForSrc = (FCInfo)this._rcvdMSGCounter.get(src);
            if (fcForSrc == null) {
                fcForSrc = new FCInfo();
                this._rcvdMSGCounter.put(src, fcForSrc);
            }
            fcForSrc.increment(1);
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("message (" + fcForSrc.getRcvdMSGCount() + ") received from " + src));
            }
        }
        return true;
    }

    public Object handle(Message req) {
        Address src = req.getSrc();
        Long resp = new Long(((FCInfo)this._rcvdMSGCounter.get(src)).getRcvdMSGCount());
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Reqest came from " + src + " Prepared response " + resp));
        }
        return resp;
    }

    public void run() {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("--- hit the _fwdMargin. Remaining size " + this._fwdMarginSize));
        }
        this.reqFCInfo();
    }

    public boolean setProperties(Properties props) {
        String str = null;
        String winsizekey = "window_size";
        String fwdmrgnkey = "fwd_mrgn";
        String rttweightkey = "rttweight";
        String sizereductionkey = "reduction";
        String sizeexpansionkey = "expansion";
        String windowsizeCapKey = "window_size_cap";
        super.setProperties(props);
        str = props.getProperty(windowsizeCapKey);
        if (str != null) {
            this._windowsize_cap = Integer.parseInt(str);
            props.remove(windowsizeCapKey);
        }
        if ((str = props.getProperty(winsizekey)) != null) {
            this._windowSize = Integer.parseInt(str);
            if (this._windowSize > this._windowsize_cap) {
                this._windowSize = this._windowsize_cap;
            }
            props.remove(winsizekey);
        }
        if ((str = props.getProperty(fwdmrgnkey)) != null) {
            this._fwdMarginSize = Integer.parseInt(str);
            props.remove(fwdmrgnkey);
        }
        if ((str = props.getProperty(rttweightkey)) != null) {
            this.RTT_WEIGHT = Double.parseDouble(str);
            props.remove(rttweightkey);
        }
        if ((str = props.getProperty(sizereductionkey)) != null) {
            this.WINDOW_SIZE_REDUCTION = Double.parseDouble(str);
            props.remove(sizereductionkey);
        }
        if ((str = props.getProperty(sizeexpansionkey)) != null) {
            this.WINDOW_SIZE_EXPANSION = Double.parseDouble(str);
            props.remove(sizeexpansionkey);
        }
        if (props.size() > 0) {
            System.err.println("FLOW_CONTROL.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    private RspList reqFCInfo() {
        RspList rspList = null;
        long reqSentTime = 0L;
        long rspRcvdTime = 0L;
        try {
            reqSentTime = System.currentTimeMillis();
            rspList = this.castMessage(null, new Message(null, null, Util.objectToByteBuffer(FLOW_CONTROL)), 2, 0L);
            rspRcvdTime = System.currentTimeMillis();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        long currentRTT = rspRcvdTime - reqSentTime;
        if (currentRTT > (long)this._estimatedRTT) {
            this._windowSize = (int)((double)this._windowSize * this.WINDOW_SIZE_REDUCTION);
            this._fwdMarginSize = (int)((double)this._fwdMarginSize * this.WINDOW_SIZE_REDUCTION);
        } else {
            this._windowSize = (int)((double)this._windowSize * this.WINDOW_SIZE_EXPANSION);
            if (this._windowSize > this._windowsize_cap) {
                this._windowSize = this._windowsize_cap;
            }
            this._fwdMarginSize = (int)((double)this._fwdMarginSize * this.WINDOW_SIZE_EXPANSION);
        }
        this._estimatedRTT = (int)(this.RTT_WEIGHT * (double)currentRTT + (1.0 - this.RTT_WEIGHT) * (double)this._estimatedRTT);
        this._numMSGsSentThisPeriod = 0;
        this.waitingForResponse = false;
        this._msgsSentAfterFCreq = 0;
        if (this.isBlockState) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"ACTION UNBLOCK");
            }
            this.passUp(new Event(55));
            System.err.println("1;" + System.currentTimeMillis() + ';' + this._windowSize);
            this.isBlockState = false;
        }
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)("estimatedTimeout = " + this._estimatedRTT));
        }
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)("window size = " + this._windowSize + " forward margin size = " + this._fwdMarginSize));
        }
        return rspList;
    }

    private class FCInfo
    implements Serializable {
        int _curValue;

        public void increment(int i) {
            this._curValue += i;
        }

        public int getRcvdMSGCount() {
            return this._curValue;
        }

        public String toString() {
            return Integer.toString(this._curValue);
        }
    }
}

