/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.blocks.MethodCall;
import org.jgroups.protocols.GMS;
import org.jgroups.protocols.GmsImpl;

public class CoordGmsImpl
extends GmsImpl {
    boolean leaving = false;
    boolean received_last_view = false;
    Object leave_mutex = new Object();
    static /* synthetic */ Class class$org$jgroups$ViewId;
    static /* synthetic */ Class class$java$util$Vector;

    public CoordGmsImpl(GMS g) {
        this.gms = g;
    }

    public void init() {
        this.leaving = false;
        this.received_last_view = false;
    }

    public void join(Address mbr) {
        this.wrongMethod("join");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leave(Address mbr) {
        if (mbr.equals(this.gms.local_addr)) {
            this.leaving = true;
        }
        this.handleLeave(mbr, false);
        Object object = this.leave_mutex;
        synchronized (object) {
            if (this.leaving && this.received_last_view) {
                return;
            }
            try {
                this.leave_mutex.wait(this.gms.leave_timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void suspect(Address mbr) {
        this.handleSuspect(mbr);
    }

    public void merge(Vector other_coords) {
        MethodCall call;
        Address other_coord;
        View new_view = null;
        Address address = other_coord = other_coords != null ? (Address)other_coords.elementAt(0) : null;
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("other_coord = " + other_coord));
        }
        try {
            call = new MethodCall("handleMerge", new Object[]{this.gms.view_id, this.gms.members.getMembers()}, new String[]{(class$org$jgroups$ViewId == null ? (class$org$jgroups$ViewId = CoordGmsImpl.class$("org.jgroups.ViewId")) : class$org$jgroups$ViewId).getName(), (class$java$util$Vector == null ? (class$java$util$Vector = CoordGmsImpl.class$("java.util.Vector")) : class$java$util$Vector).getName()});
            new_view = (View)this.gms.callRemoteMethod(other_coord, call, 2, 0L);
        }
        catch (Exception ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"timed out or was suspected");
            }
            return;
        }
        if (new_view == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"received a Merge Denied");
            }
            this.gms.passDown(new Event(45));
            return;
        }
        this.gms.flush(this.gms.members.getMembers(), null);
        call = new MethodCall("handleViewChange", new Object[]{new_view.getVid(), new_view.getMembers()}, new String[]{(class$org$jgroups$ViewId == null ? (class$org$jgroups$ViewId = CoordGmsImpl.class$("org.jgroups.ViewId")) : class$org$jgroups$ViewId).getName(), (class$java$util$Vector == null ? (class$java$util$Vector = CoordGmsImpl.class$("java.util.Vector")) : class$java$util$Vector).getName()});
        this.gms.callRemoteMethods(this.gms.members.getMembers(), call, 2, 0L);
        this.gms.becomeParticipant();
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"merge done");
        }
    }

    public synchronized boolean handleJoin(Address mbr) {
        Vector<Address> new_mbrs = new Vector<Address>(1);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("received JOIN request from " + mbr));
        }
        if (this.gms.local_addr.equals(mbr)) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"cannot join myself !");
            }
            return false;
        }
        if (this.gms.members.contains(mbr)) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("member " + mbr + " already present !"));
            }
            return true;
        }
        new_mbrs.addElement(mbr);
        this.gms.castViewChange(new_mbrs, null, null);
        return true;
    }

    public synchronized void handleLeave(Address mbr, boolean suspected) {
        Vector<Address> v = new Vector<Address>(1);
        if (!this.gms.members.contains(mbr)) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("mbr " + mbr + " is not a member !"));
            }
            return;
        }
        v.addElement(mbr);
        if (suspected) {
            this.gms.castViewChange(null, null, v);
        } else {
            this.gms.castViewChange(null, v, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleViewChange(ViewId new_view, Vector mbrs) {
        if (this.leaving) {
            if (mbrs.contains(this.gms.local_addr)) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)"received view in which I'm still a member, cannot quit yet");
                }
                this.gms.installView(new_view, mbrs);
            } else {
                Object object = this.leave_mutex;
                synchronized (object) {
                    this.received_last_view = true;
                    this.leave_mutex.notify();
                }
            }
            return;
        }
        this.gms.installView(new_view, mbrs);
    }

    public synchronized View handleMerge(ViewId other_vid, Vector other_mbrs) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("other_vid=" + other_vid + " , other_mbrs=" + other_mbrs));
        }
        Iterator i = other_mbrs.iterator();
        while (i.hasNext()) {
            if (!this.gms.members.contains((Address)i.next())) continue;
            this.gms.passDown(new Event(45));
            return null;
        }
        ViewId vid = new ViewId(this.gms.local_addr, Math.max(other_vid.getId() + 1L, this.gms.ltime + 1L));
        HashSet members = new HashSet(this.gms.members.getMembers());
        members.addAll(other_mbrs);
        Vector new_mbrs = new Vector(members);
        Collections.sort(new_mbrs);
        View new_view = new View(vid, new_mbrs);
        this.gms.flush(this.gms.members.getMembers(), null);
        MethodCall call = new MethodCall("handleViewChange", new Object[]{vid, new_mbrs}, new String[]{(class$org$jgroups$ViewId == null ? (class$org$jgroups$ViewId = CoordGmsImpl.class$("org.jgroups.ViewId")) : class$org$jgroups$ViewId).getName(), (class$java$util$Vector == null ? (class$java$util$Vector = CoordGmsImpl.class$("java.util.Vector")) : class$java$util$Vector).getName()});
        this.gms.callRemoteMethods(this.gms.members.getMembers(), call, 2, 0L);
        return new_view;
    }

    public void handleSuspect(Address mbr) {
        if (mbr.equals(this.gms.local_addr)) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"I am the coord and am suspected: am not quitting !");
            }
            return;
        }
        this.handleLeave(mbr, true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

