/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.blocks.ConnectionTable;
import org.jgroups.blocks.NBMessageForm1_4;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Util;
import org.jgroups.util.Util1_4;

public class ConnectionTable1_4
extends ConnectionTable
implements Runnable {
    private ServerSocketChannel srv_sock_ch = null;
    private Selector selector = null;
    private ArrayList pendingSocksList = null;

    public ConnectionTable1_4(int srv_port) throws Exception {
        super(srv_port);
    }

    public ConnectionTable1_4(int srv_port, long reaper_interval, long conn_expire_time) throws Exception {
        super(srv_port, reaper_interval, conn_expire_time);
    }

    public ConnectionTable1_4(ConnectionTable.Receiver r, InetAddress bind_addr, int srv_port) throws Exception {
        super(r, bind_addr, srv_port);
    }

    public ConnectionTable1_4(ConnectionTable.Receiver r, InetAddress bind_addr, int srv_port, long reaper_interval, long conn_expire_time) throws Exception {
        super(r, bind_addr, srv_port, reaper_interval, conn_expire_time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionTable.Connection getConnection(Address dest) throws Exception {
        Connection conn = null;
        Hashtable hashtable = this.conns;
        synchronized (hashtable) {
            conn = (Connection)this.conns.get(dest);
            if (conn == null) {
                InetSocketAddress destAddress = new InetSocketAddress(((IpAddress)dest).getIpAddress(), ((IpAddress)dest).getPort());
                SocketChannel sock_ch = SocketChannel.open(destAddress);
                conn = new Connection(sock_ch, dest);
                conn.sendLocalAddress(this.local_addr);
                this.addConnection(dest, conn);
                this.pendingSocksList.add(conn);
                this.selector.wakeup();
                this.notifyConnectionOpened(dest);
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("created socket to " + dest));
                }
            }
            return conn;
        }
    }

    public void stop() {
        if (this.srv_sock_ch != null) {
            try {
                ServerSocketChannel temp = this.srv_sock_ch;
                this.srv_sock_ch = null;
                temp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Connection conn = null;
        while (this.srv_sock_ch != null) {
            try {
                Object readyKeys;
                if (this.selector.select() > 0) {
                    readyKeys = this.selector.selectedKeys();
                    Iterator i = readyKeys.iterator();
                    while (i.hasNext()) {
                        ByteBuffer buff;
                        SelectionKey key = (SelectionKey)i.next();
                        i.remove();
                        if ((key.readyOps() & 0x10) == 16) {
                            ServerSocketChannel readyChannel = (ServerSocketChannel)key.channel();
                            SocketChannel client_sock_ch = readyChannel.accept();
                            Socket client_sock = client_sock_ch.socket();
                            if (this.log.isInfoEnabled()) {
                                this.log.info((Object)("accepted connection, client_sock=" + client_sock));
                            }
                            conn = new Connection(client_sock_ch, null);
                            Address peer_addr = conn.readPeerAddress(client_sock);
                            conn.setPeerAddress(peer_addr);
                            Hashtable hashtable = this.conns;
                            synchronized (hashtable) {
                                if (this.conns.contains(peer_addr)) {
                                    if (this.log.isWarnEnabled()) {
                                        this.log.warn((Object)(peer_addr + " is already there, will terminate connection"));
                                    }
                                    conn.destroy();
                                    return;
                                }
                                this.addConnection(peer_addr, conn);
                            }
                            conn.init();
                            this.notifyConnectionOpened(peer_addr);
                            continue;
                        }
                        if ((key.readyOps() & 1) != 1 || (buff = (conn = (Connection)key.attachment()).getNIOMsgReader().readCompleteMsgBuffer()) == null) continue;
                        this.receive((Message)Util.objectFromByteBuffer(buff.array()));
                        conn.getNIOMsgReader().reset();
                    }
                    continue;
                }
                readyKeys = this.conns;
                synchronized (readyKeys) {
                    Connection pendingConnection;
                    while (this.pendingSocksList.size() > 0 && null != (pendingConnection = (Connection)this.pendingSocksList.remove(0))) {
                        pendingConnection.init();
                    }
                }
            }
            catch (SocketException sock_ex) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("exception is " + sock_ex));
                }
                if (conn != null) {
                    conn.destroy();
                }
                if (this.srv_sock != null) continue;
                break;
            }
            catch (Throwable ex) {
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn((Object)("exception is " + ex));
            }
        }
    }

    protected ServerSocket createServerSocket(int start_port) throws Exception {
        this.selector = Selector.open();
        this.srv_sock_ch = ServerSocketChannel.open();
        this.srv_sock_ch.configureBlocking(false);
        while (true) {
            try {
                if (this.bind_addr == null) {
                    this.srv_sock_ch.socket().bind(new InetSocketAddress(start_port));
                    break;
                }
                this.srv_sock_ch.socket().bind(new InetSocketAddress(this.bind_addr, start_port), 20);
            }
            catch (BindException bind_ex) {
                ++start_port;
                continue;
            }
            catch (IOException io_ex) {
                if (!this.log.isErrorEnabled()) break;
                this.log.error((Object)("exception is " + io_ex));
            }
            break;
        }
        this.srv_port = start_port;
        this.pendingSocksList = new ArrayList();
        this.srv_sock_ch.register(this.selector, 16);
        return this.srv_sock_ch.socket();
    }

    class Connection
    extends ConnectionTable.Connection {
        private SocketChannel sock_ch = null;
        private static final int HEADER_SIZE = 4;
        private static final int DEFAULT_BUFF_SIZE = 256;
        ByteBuffer headerBuffer = ByteBuffer.allocate(4);
        NBMessageForm1_4 nioMsgReader = null;

        Connection(SocketChannel s, Address peer_addr) {
            super(s.socket(), peer_addr);
            this.sock_ch = s;
        }

        void init() {
            this.in = null;
            this.out = null;
            try {
                this.sock_ch.configureBlocking(false);
                this.nioMsgReader = new NBMessageForm1_4(256, this.sock_ch);
                this.sock_ch.register(ConnectionTable1_4.this.selector, 1, this);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (ConnectionTable1_4.this.log.isInfoEnabled()) {
                ConnectionTable1_4.this.log.info((Object)("connection was created to " + this.peer_addr));
            }
        }

        void destroy() {
            this.closeSocket();
            this.nioMsgReader = null;
        }

        void doSend(Message msg) throws Exception {
            IpAddress dst_addr = (IpAddress)msg.getDest();
            byte[] buffie = null;
            if (dst_addr == null || dst_addr.getIpAddress() == null) {
                if (ConnectionTable1_4.this.log.isErrorEnabled()) {
                    ConnectionTable1_4.this.log.error((Object)"the destination address is null; aborting send");
                }
                return;
            }
            try {
                if (msg.getSrc() == null) {
                    msg.setSrc(ConnectionTable1_4.this.local_addr);
                }
                if ((buffie = Util.objectToByteBuffer(msg)).length <= 0) {
                    if (ConnectionTable1_4.this.log.isErrorEnabled()) {
                        ConnectionTable1_4.this.log.error((Object)"buffer.length is 0. Will not send message");
                    }
                    return;
                }
                this.headerBuffer.clear();
                this.headerBuffer.putInt(buffie.length);
                this.headerBuffer.flip();
                Util1_4.writeFully(this.headerBuffer, this.sock_ch);
                ByteBuffer sendBuffer = ByteBuffer.wrap(buffie);
                Util1_4.writeFully(sendBuffer, this.sock_ch);
            }
            catch (Exception ex) {
                if (ConnectionTable1_4.this.log.isErrorEnabled()) {
                    ConnectionTable1_4.this.log.error((Object)("to " + dst_addr + ", exception is " + ex + ", stack trace:\n" + Util.printStackTrace(ex)));
                }
                ConnectionTable1_4.this.remove(dst_addr);
                throw ex;
            }
        }

        void closeSocket() {
            if (this.sock != null) {
                try {
                    this.sock_ch.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.sock = null;
            }
        }

        NBMessageForm1_4 getNIOMsgReader() {
            return this.nioMsgReader;
        }
    }
}

