/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Header;
import org.jgroups.util.ContextObjectInputStream;
import org.jgroups.util.Marshaller;

public class Message
implements Externalizable {
    protected Address dest_addr = null;
    protected Address src_addr = null;
    private byte[] buf = null;
    protected transient int offset = 0;
    protected transient int length = 0;
    protected HashMap headers = null;
    protected static Log log = LogFactory.getLog((Class)(class$org$jgroups$Message == null ? (class$org$jgroups$Message = Message.class$("org.jgroups.Message")) : class$org$jgroups$Message));
    static final long ADDRESS_OVERHEAD = 200L;
    static final long serialVersionUID = -1137364035832847034L;
    static /* synthetic */ Class class$org$jgroups$Message;

    public Message(Address dest, Address src, byte[] buf) {
        this.dest_addr = dest;
        this.src_addr = src;
        this.setBuffer(buf);
    }

    public Message(Address dest, Address src, byte[] buf, int offset, int length) {
        this.dest_addr = dest;
        this.src_addr = src;
        this.setBuffer(buf, offset, length);
    }

    public Message(Address dest, Address src, Serializable obj) {
        this.dest_addr = dest;
        this.src_addr = src;
        this.setObject(obj);
    }

    public Message() {
    }

    public Address getDest() {
        return this.dest_addr;
    }

    public void setDest(Address new_dest) {
        this.dest_addr = new_dest;
    }

    public Address getSrc() {
        return this.src_addr;
    }

    public void setSrc(Address new_src) {
        this.src_addr = new_src;
    }

    public byte[] getRawBuffer() {
        return this.buf;
    }

    public byte[] getBuffer() {
        if (this.buf == null) {
            return null;
        }
        if (this.offset == 0 && this.length == this.buf.length) {
            return this.buf;
        }
        byte[] retval = new byte[this.length];
        System.arraycopy(this.buf, this.offset, retval, 0, this.length);
        return retval;
    }

    public void setBuffer(byte[] b) {
        this.buf = b;
        if (this.buf != null) {
            this.offset = 0;
            this.length = this.buf.length;
        } else {
            this.length = 0;
            this.offset = 0;
        }
    }

    public void setBuffer(byte[] b, int offset, int length) {
        this.buf = b;
        if (this.buf != null) {
            if (offset < 0 || offset > this.buf.length) {
                throw new ArrayIndexOutOfBoundsException(offset);
            }
            if (offset + length > this.buf.length) {
                throw new ArrayIndexOutOfBoundsException(offset + length);
            }
            this.offset = offset;
            this.length = length;
        } else {
            length = 0;
            offset = 0;
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public Map getHeaders() {
        return this.headers;
    }

    public void setObject(Serializable obj) {
        if (obj == null) {
            return;
        }
        try {
            ByteArrayOutputStream out_stream = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(out_stream);
            out.writeObject(obj);
            this.setBuffer(out_stream.toByteArray());
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    public Object getObject() {
        if (this.buf == null) {
            return null;
        }
        try {
            ByteArrayInputStream in_stream = new ByteArrayInputStream(this.buf, this.offset, this.length);
            ContextObjectInputStream in = new ContextObjectInputStream(in_stream);
            return in.readObject();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    public void reset() {
        this.src_addr = null;
        this.dest_addr = null;
        this.setBuffer(null);
        if (this.headers != null) {
            this.headers.clear();
        }
    }

    public void putHeader(String key, Header hdr) {
        if (log.isTraceEnabled() && this.headers().containsKey(key)) {
            log.trace((Object)("header for \"" + key + "\" is already present: old header=" + this.headers().get(key) + ", new header=" + hdr));
        }
        this.headers().put(key, hdr);
    }

    public Header removeHeader(String key) {
        return this.headers != null ? (Header)this.headers.remove(key) : null;
    }

    public void removeHeaders() {
        if (this.headers != null) {
            this.headers.clear();
        }
    }

    public Header getHeader(String key) {
        return this.headers != null ? (Header)this.headers.get(key) : null;
    }

    public Message copy() {
        return this.copy(true);
    }

    public Message copy(boolean copy_buffer) {
        Message retval = new Message();
        retval.dest_addr = this.dest_addr;
        retval.src_addr = this.src_addr;
        if (copy_buffer && this.buf != null) {
            retval.setBuffer(this.buf, this.offset, this.length);
        }
        if (this.headers != null) {
            retval.headers = (HashMap)this.headers.clone();
        }
        return retval;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.copy();
    }

    public Message makeReply() {
        return new Message(this.src_addr, null, null);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("[dst: ");
        if (this.dest_addr == null) {
            ret.append("<null>");
        } else {
            ret.append(this.dest_addr);
        }
        ret.append(", src: ");
        if (this.src_addr == null) {
            ret.append("<null>");
        } else {
            ret.append(this.src_addr);
        }
        if (this.headers != null && this.headers.size() > 0) {
            ret.append(" (" + this.headers.size() + " headers)");
        }
        ret.append(", size = ");
        if (this.buf != null && this.length > 0) {
            ret.append(this.length);
        } else {
            ret.append('0');
        }
        ret.append(" bytes");
        ret.append(']');
        return ret.toString();
    }

    public String toStringAsObject() {
        if (this.buf == null) {
            return null;
        }
        try {
            Object obj = this.getObject();
            return obj != null ? obj.toString() : "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public long size() {
        long retval = this.length;
        long hdr_size = 0L;
        if (this.dest_addr != null) {
            retval += 200L;
        }
        if (this.src_addr != null) {
            retval += 200L;
        }
        if (this.headers != null) {
            Iterator it = this.headers.values().iterator();
            while (it.hasNext()) {
                Header hdr = (Header)it.next();
                if (hdr == null) continue;
                hdr_size = hdr.size();
                if (hdr_size <= 0L) {
                    hdr_size = 255L;
                    continue;
                }
                retval += hdr_size;
            }
        }
        return retval;
    }

    public String printObjectHeaders() {
        StringBuffer sb = new StringBuffer();
        if (this.headers != null) {
            Iterator it = this.headers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                sb.append(entry.getKey()).append(": ").append(entry.getValue()).append('\n');
            }
        }
        return sb.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.dest_addr != null) {
            out.writeBoolean(true);
            Marshaller.write(this.dest_addr, out);
        } else {
            out.writeBoolean(false);
        }
        if (this.src_addr != null) {
            out.writeBoolean(true);
            Marshaller.write(this.src_addr, out);
        } else {
            out.writeBoolean(false);
        }
        if (this.buf == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.length);
            out.write(this.buf, this.offset, this.length);
        }
        if (this.headers == null) {
            out.writeInt(0);
        } else {
            int len = this.headers.size();
            out.writeInt(len);
            Iterator it = this.headers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                out.writeUTF((String)entry.getKey());
                Externalizable hdr = (Externalizable)entry.getValue();
                Marshaller.write(hdr, out);
            }
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int len;
        int i;
        boolean srcAddressExist;
        boolean destAddressExist = in.readBoolean();
        if (destAddressExist) {
            this.dest_addr = (Address)Marshaller.read(in);
        }
        if (srcAddressExist = in.readBoolean()) {
            this.src_addr = (Address)Marshaller.read(in);
        }
        if ((i = in.readInt()) != 0) {
            this.buf = new byte[i];
            in.readFully(this.buf);
            this.offset = 0;
            this.length = this.buf.length;
        }
        if ((len = in.readInt()) > 0) {
            this.headers = new HashMap(11);
        }
        while (len-- > 0) {
            String key = in.readUTF();
            Externalizable value = Marshaller.read(in);
            this.headers.put(key, value);
        }
    }

    HashMap headers() {
        return this.headers != null ? this.headers : (this.headers = new HashMap(11));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

