/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.pool;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.enhydra.jdbc.core.CoreDataSource;
import org.enhydra.jdbc.core.JdbcThreadFactory;
import org.enhydra.jdbc.pool.GenerationObject;
import org.enhydra.jdbc.pool.GenericPool;
import org.enhydra.jdbc.pool.PoolHelper;
import org.enhydra.jdbc.util.Logger;

public class StandardPoolDataSource
extends CoreDataSource
implements DataSource,
PoolHelper,
ConnectionEventListener {
    public ConnectionPoolDataSource cpds;
    public GenericPool pool;
    public String dataSourceName;
    public String jdbcTestStmt;
    public boolean onOff;
    public Context ictx;
    public Log glog = LogFactory.getLog((String)"org.enhydra.jdbc.xapool");

    public StandardPoolDataSource() {
        this.log = new Logger(this.glog);
        super.setLogWriter(this.log);
        this.pool = new GenericPool(this);
        this.pool.setLogger(this.log);
        this.onOff = false;
        this.dataSourceName = null;
    }

    public StandardPoolDataSource(int initSize) {
        this.log = new Logger(this.glog);
        super.setLogWriter(this.log);
        this.pool = new GenericPool(this, initSize);
        this.pool.setLogger(this.log);
        this.onOff = false;
        this.dataSourceName = null;
    }

    public StandardPoolDataSource(ConnectionPoolDataSource cc) {
        this.cpds = cc;
        this.log = new Logger(this.glog);
        super.setLogWriter(this.log);
        this.pool = new GenericPool(this);
        this.pool.setLogger(this.log);
        try {
            this.cpds.setLogWriter(this.log);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.onOff = false;
        this.dataSourceName = null;
    }

    public StandardPoolDataSource(ConnectionPoolDataSource cc, int initSize) {
        this.cpds = cc;
        this.log = new Logger(this.glog);
        super.setLogWriter(this.log);
        this.pool = new GenericPool(this, initSize);
        this.pool.setLogger(this.log);
        this.onOff = false;
        this.dataSourceName = null;
    }

    public void setDataSourceName(String dataSourceName) {
        this.log.debug("StandardPoolDataSource:setDataSourceName");
        this.dataSourceName = dataSourceName;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.getUser(), this.getPassword());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(String _user, String _password) throws SQLException {
        this.log.debug("StandardPoolDataSource:getConnection");
        Connection ret = null;
        PooledConnection con = null;
        StandardPoolDataSource standardPoolDataSource = this;
        synchronized (standardPoolDataSource) {
            if (!this.onOff) {
                this.log.debug("StandardPoolDataSource:getConnection must configure the pool...");
                this.pool.start();
                this.onOff = true;
                this.log.debug("StandardPoolDataSource:getConnection pool config : \n" + this.pool.toString());
            }
        }
        try {
            try {
                this.log.debug("StandardPoolDataSource:getConnection Try to give a connection (checkOut)");
                con = (PooledConnection)this.pool.checkOut(_user, _password);
                this.log.debug("StandardPoolDataSource:getConnection checkOut returna new connection");
            }
            catch (Exception e) {
                this.log.debug("StandardPoolDataSource:getConnection SQLException in StandardPoolDataSource:getConnection" + e);
                throw new SQLException("SQLException in StandardPoolDataSource:getConnection no connection available " + e);
            }
            ret = con.getConnection();
        }
        catch (Exception e) {
            this.log.debug("StandardPoolDataSource:getConnection exception" + e);
            SQLException sqle = new SQLException("SQLException in StandardPoolDataSource:getConnection exception: " + e);
            if (e instanceof SQLException) {
                sqle.setNextException((SQLException)e);
            }
            if (con != null) {
                this.pool.checkIn(con);
            }
            throw sqle;
        }
        this.log.debug("StandardPoolDataSource:getConnection return a connection");
        return ret;
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        Object obj = event.getSource();
        PooledConnection pc = (PooledConnection)obj;
        this.pool.nextGeneration(pc);
        this.pool.removeLockedObject(pc);
        this.expire(pc);
        this.log.debug("StandardXAPoolDataSource:connectionErrorOccurred remove the object from the pool");
    }

    public void connectionClosed(ConnectionEvent event) {
        this.log.debug("StandardPoolDataSource:connectionClosed close the connection");
        Object obj = event.getSource();
        this.pool.checkIn(obj);
    }

    public void expire(Object o) {
        this.log.debug("StandardPoolDataSource:expire expire a connection, remove from the pool");
        if (o == null) {
            return;
        }
        try {
            PooledConnection pooledCon = (PooledConnection)o;
            pooledCon.close();
            pooledCon.removeConnectionEventListener(this);
            this.log.debug("StandardPoolDataSource:expire close the connection");
        }
        catch (SQLException e) {
            this.log.error("StandardPoolDataSource:expire Error java.sql.SQLException in StandardPoolDataSource:expire");
        }
    }

    public boolean checkThisObject(Object o) {
        this.log.debug("StandardPoolDataSource:checkThisObject verify the current object");
        try {
            PooledConnection con = (PooledConnection)o;
            Connection ret = con.getConnection();
            if (ret.isClosed()) {
                return false;
            }
            try {
                ret.close();
            }
            catch (Exception e) {
                this.log.error("StandardPoolDataSource:checkThisObject can't closed the connection: " + e);
            }
            return true;
        }
        catch (SQLException e) {
            this.log.error("StandardPoolDataSource:checkThisObject Error java.sql.SQLException in StandardPoolDataSource:checkThisObject");
            return false;
        }
    }

    public boolean testThisObject(Object o) {
        Connection ret = null;
        this.log.debug("StandardPoolDataSource:testThisObject verify the current object");
        try {
            PooledConnection con = (PooledConnection)o;
            ret = con.getConnection();
            Statement s = ret.createStatement();
            s.execute(this.jdbcTestStmt);
            s.close();
            try {
                ret.close();
            }
            catch (Exception e) {
                this.log.error("StandardPoolDataSource:checkThisObject can't closed the connection: " + e);
            }
            return true;
        }
        catch (SQLException e) {
            this.log.error("StandardPoolDataSource:checkThisObject Error java.sql.SQLException in StandardPoolDataSource:testThisObject");
            return false;
        }
    }

    public GenerationObject create() throws SQLException {
        return this.create(this.getUser(), this.getPassword());
    }

    public GenerationObject create(String _user, String _password) throws SQLException {
        this.log.debug("StandardPoolDataSource:create create a connection for the pool");
        PooledConnection pooledCon = this.cpds.getPooledConnection(_user, _password);
        pooledCon.addConnectionEventListener(this);
        this.log.debug("StandardPoolDataSource:create create a object for the pool");
        GenerationObject genObject = new GenerationObject(pooledCon, this.pool.getGeneration(), _user, _password);
        return genObject;
    }

    public void stopPool() {
        this.pool.stop();
        this.onOff = false;
        this.log.debug("StandardPoolDataSource:stopPool stop now the pool");
    }

    public void shutdown(boolean force) {
        this.stopPool();
    }

    public void setLogWriter(PrintWriter logWriter) {
        this.pool.setLogger(this.log);
        super.setLogger(this.log);
    }

    public void setDebug(boolean debug) {
        super.setDebug(debug);
        this.pool.setDebug(debug);
    }

    public void setMinSize(int minSize) throws Exception {
        this.pool.setMinSize(minSize);
    }

    public void setMaxSize(int maxSize) throws Exception {
        this.pool.setMaxSize(maxSize);
    }

    public void setLifeTime(long lifeTime) {
        this.pool.setLifeTime(lifeTime);
    }

    public void setSleepTime(long sleepTime) {
        this.pool.setSleepTime(sleepTime);
    }

    public void setGC(boolean gc) {
        this.pool.setGC(gc);
    }

    public void setCheckLevelObject(int checkLevelObject) {
        this.pool.setCheckLevelObject(checkLevelObject);
    }

    public void setJdbcTestStmt(String jdbcTestStmt) {
        this.jdbcTestStmt = jdbcTestStmt;
    }

    public void setGeneration(int generation) {
        this.pool.setGeneration(generation);
    }

    public void setDeadLockMaxWait(long deadLock) {
        this.pool.setDeadLockMaxWait(deadLock);
    }

    public void setDeadLockRetryWait(long loopWait) {
        this.pool.setDeadLockRetryWait(loopWait);
    }

    public PrintWriter getLogWriter() {
        return this.log;
    }

    public int getMinSize() {
        return this.pool.getMinSize();
    }

    public int getMaxSize() {
        return this.pool.getMaxSize();
    }

    public long getLifeTime() {
        return this.pool.getLifeTime();
    }

    public long getSleepTime() {
        return this.pool.getSleepTime();
    }

    public int getGeneration() {
        return this.pool.generation;
    }

    public boolean isGC() {
        return this.pool.isGC();
    }

    public int getLockedObjectCount() {
        return this.pool.getLockedObjectCount();
    }

    public int getUnlockedObjectCount() {
        return this.pool.getUnlockedObjectCount();
    }

    public int getCheckLevelObject() {
        return this.pool.getCheckLevelObject();
    }

    public String getJdbcTestStmt() {
        return this.jdbcTestStmt;
    }

    public long getDeadLockMaxWait() {
        return this.pool.getDeadLockMaxWait();
    }

    public long getDeadLockRetryWait() {
        return this.pool.getDeadLockRetryWait();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("StandardPoolDataSource:\n");
        sb.append("     data source name=<" + this.dataSourceName + ">\n");
        sb.append("     jdbc test stmt=<" + this.jdbcTestStmt + ">\n");
        sb.append("     user=<" + this.user + ">\n");
        if (this.cpds != null) {
            sb.append(this.cpds.toString());
        }
        sb.append(this.pool.toString());
        return sb.toString();
    }

    public Reference getReference() throws NamingException {
        this.log.debug("StandardPoolDataSource:getReference return a reference of the object");
        Reference ref = super.getReference();
        ref.add(new StringRefAddr("checkLevelObject", Integer.toString(this.getCheckLevelObject())));
        ref.add(new StringRefAddr("lifeTime", Long.toString(this.getLifeTime())));
        ref.add(new StringRefAddr("jdbcTestStmt", this.getJdbcTestStmt()));
        ref.add(new StringRefAddr("maxSize", Integer.toString(this.getMaxSize())));
        ref.add(new StringRefAddr("minSize", Integer.toString(this.getMinSize())));
        ref.add(new StringRefAddr("dataSourceName", this.getDataSourceName()));
        return ref;
    }

    public Object getObjectInstance(Object refObj, Name name, Context nameCtx, Hashtable env) throws Exception {
        super.getObjectInstance(refObj, name, nameCtx, env);
        Reference ref = (Reference)refObj;
        this.setLifeTime(Long.parseLong((String)ref.get("lifeTime").getContent()));
        this.setJdbcTestStmt((String)ref.get("jdbcTestStmt").getContent());
        this.setMaxSize(Integer.parseInt((String)ref.get("maxSize").getContent()));
        this.setMinSize(Integer.parseInt((String)ref.get("minSize").getContent()));
        this.setDataSourceName((String)ref.get("dataSourceName").getContent());
        InitialContext ictx = new InitialContext(env);
        this.cpds = (ConnectionPoolDataSource)ictx.lookup(this.dataSourceName);
        return this;
    }

    public void setThreadFactory(JdbcThreadFactory tf) {
        super.setThreadFactory(tf);
        this.pool.setThreadFactory(tf);
    }
}

