/*
 * Decompiled with CFR 0.152.
 */
package javax.websocket.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.websocket.Decoder;
import javax.websocket.Encoder;
import javax.websocket.Extension;
import javax.websocket.server.DefaultServerEndpointConfiguration;
import javax.websocket.server.ServerEndpointConfiguration;
import javax.websocket.server.ServerEndpointConfigurator;

public final class ServerEndpointConfigurationBuilder {
    private String path;
    private Class endpointClass;
    private List<String> subprotocols = new ArrayList<String>();
    private List<Extension> extensions = new ArrayList<Extension>();
    private List<Encoder> encoders = new ArrayList<Encoder>();
    private List<Decoder> decoders = new ArrayList<Decoder>();
    private ServerEndpointConfigurator serverEndpointConfigurator;

    public static ServerEndpointConfigurationBuilder create(Class endpointClass, String path) {
        return new ServerEndpointConfigurationBuilder(endpointClass, path);
    }

    private ServerEndpointConfigurationBuilder() {
    }

    public ServerEndpointConfiguration build() {
        return new DefaultServerEndpointConfiguration(this.endpointClass, this.path, Collections.unmodifiableList(this.subprotocols), Collections.unmodifiableList(this.extensions), Collections.unmodifiableList(this.encoders), Collections.unmodifiableList(this.decoders), this.serverEndpointConfigurator);
    }

    private ServerEndpointConfigurationBuilder(Class endpointClass, String path) {
        if (endpointClass == null) {
            throw new IllegalArgumentException("endpointClass cannot be null");
        }
        this.endpointClass = endpointClass;
        if (path == null || !path.startsWith("/")) {
            throw new IllegalStateException("Path cannot be null and must begin with /");
        }
        this.path = path;
    }

    public ServerEndpointConfigurationBuilder encoders(List<Encoder> encoders) {
        this.encoders = encoders == null ? new ArrayList() : encoders;
        return this;
    }

    public ServerEndpointConfigurationBuilder decoders(List<Decoder> decoders) {
        this.decoders = decoders == null ? new ArrayList() : decoders;
        return this;
    }

    public ServerEndpointConfigurationBuilder subprotocols(List<String> subprotocols) {
        this.subprotocols = subprotocols == null ? new ArrayList() : subprotocols;
        return this;
    }

    public ServerEndpointConfigurationBuilder extensions(List<Extension> extensions) {
        this.extensions = extensions == null ? new ArrayList() : extensions;
        return this;
    }

    public ServerEndpointConfigurationBuilder serverEndpointConfigurator(ServerEndpointConfigurator serverEndpointConfigurator) {
        this.serverEndpointConfigurator = serverEndpointConfigurator;
        return this;
    }
}

