/*
 * Decompiled with CFR 0.152.
 */
package javax.json;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonNumberImpl;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonStringImpl;
import javax.json.JsonValue;
import javax.json.JsonWriter;

public class JsonArrayBuilder {
    private final List<JsonValue> valueList = new ArrayList<JsonValue>();

    public JsonArrayBuilder add(JsonValue value) {
        this.valueList.add(value);
        return this;
    }

    public JsonArrayBuilder add(String value) {
        this.valueList.add(new JsonStringImpl(value));
        return this;
    }

    public JsonArrayBuilder add(BigDecimal value) {
        this.valueList.add(new JsonNumberImpl(value));
        return this;
    }

    public JsonArrayBuilder add(BigInteger value) {
        this.valueList.add(new JsonNumberImpl(value));
        return this;
    }

    public JsonArrayBuilder add(int value) {
        this.valueList.add(new JsonNumberImpl(value));
        return this;
    }

    public JsonArrayBuilder add(long value) {
        this.valueList.add(new JsonNumberImpl(value));
        return this;
    }

    public JsonArrayBuilder add(double value) {
        this.valueList.add(new JsonNumberImpl(value));
        return this;
    }

    public JsonArrayBuilder add(boolean value) {
        this.valueList.add(value ? JsonValue.TRUE : JsonValue.FALSE);
        return this;
    }

    public JsonArrayBuilder addNull() {
        this.valueList.add(JsonValue.NULL);
        return this;
    }

    public JsonArrayBuilder add(JsonObjectBuilder builder) {
        this.valueList.add(builder.build());
        return this;
    }

    public JsonArrayBuilder add(JsonArrayBuilder builder) {
        this.valueList.add(builder.build());
        return this;
    }

    public JsonArray build() {
        ArrayList<JsonValue> snapshot = new ArrayList<JsonValue>(this.valueList);
        return new JsonArrayImpl(Collections.unmodifiableList(snapshot));
    }

    private static final class JsonArrayImpl
    extends AbstractList<JsonValue>
    implements JsonArray {
        private final List<JsonValue> valueList;

        JsonArrayImpl(List<JsonValue> valueList) {
            this.valueList = valueList;
        }

        @Override
        public int size() {
            return this.valueList.size();
        }

        @Override
        public <T extends JsonValue> T getValue(int index, Class<T> clazz) {
            return (T)((JsonValue)clazz.cast(this.valueList.get(index)));
        }

        @Override
        public String getStringValue(int index) {
            return this.getValue(index, JsonString.class).getValue();
        }

        @Override
        public int getIntValue(int index) {
            return this.getValue(index, JsonNumber.class).getIntValue();
        }

        @Override
        public JsonValue.ValueType getValueType() {
            return JsonValue.ValueType.ARRAY;
        }

        @Override
        public JsonValue get(int index) {
            return this.valueList.get(index);
        }

        @Override
        public String toString() {
            StringWriter sw = new StringWriter();
            JsonWriter jw = new JsonWriter(sw);
            jw.write(this);
            jw.close();
            return sw.toString();
        }
    }
}

