/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo.spi;

import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.LegacyJava;

public class I18NHelper {
    private static Hashtable<String, ResourceBundle> bundles = new Hashtable();
    private static Hashtable<String, I18NHelper> helpers = new Hashtable();
    private static Locale locale = Locale.getDefault();
    private ResourceBundle bundle = null;
    private Throwable failure = null;
    private static final String bundleSuffix = ".Bundle";

    private I18NHelper() {
    }

    private I18NHelper(String bundleName, ClassLoader loader) {
        try {
            this.bundle = I18NHelper.loadBundle(bundleName, loader);
        }
        catch (Throwable e) {
            this.failure = e;
        }
    }

    public static I18NHelper getInstance(String bundleName) {
        return I18NHelper.getInstance(bundleName, I18NHelper.class.getClassLoader());
    }

    public static I18NHelper getInstance(final Class cls) {
        ClassLoader classLoader = I18NHelper.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return cls.getClassLoader();
            }
        });
        String bundle = I18NHelper.getPackageName(cls.getName()) + bundleSuffix;
        return I18NHelper.getInstance(bundle, classLoader);
    }

    public static I18NHelper getInstance(String bundleName, ClassLoader loader) {
        I18NHelper helper = helpers.get(bundleName);
        if (helper != null) {
            return helper;
        }
        helper = new I18NHelper(bundleName, loader);
        helpers.put(bundleName, helper);
        return helpers.get(bundleName);
    }

    public String msg(String messageKey) {
        this.assertBundle(messageKey);
        return I18NHelper.getMessage(this.bundle, messageKey);
    }

    public String msg(String messageKey, Object arg1) {
        this.assertBundle(messageKey);
        return I18NHelper.getMessage(this.bundle, messageKey, arg1);
    }

    public String msg(String messageKey, Object arg1, Object arg2) {
        this.assertBundle(messageKey);
        return I18NHelper.getMessage(this.bundle, messageKey, arg1, arg2);
    }

    public String msg(String messageKey, Object arg1, Object arg2, Object arg3) {
        this.assertBundle(messageKey);
        return I18NHelper.getMessage(this.bundle, messageKey, arg1, arg2, arg3);
    }

    public String msg(String messageKey, Object[] args) {
        this.assertBundle(messageKey);
        return I18NHelper.getMessage(this.bundle, messageKey, args);
    }

    public String msg(String messageKey, int arg) {
        this.assertBundle(messageKey);
        return I18NHelper.getMessage(this.bundle, messageKey, arg);
    }

    public String msg(String messageKey, boolean arg) {
        this.assertBundle(messageKey);
        return I18NHelper.getMessage(this.bundle, messageKey, arg);
    }

    public ResourceBundle getResourceBundle() {
        this.assertBundle();
        return this.bundle;
    }

    private static final ResourceBundle loadBundle(String bundleName, ClassLoader loader) {
        ResourceBundle messages = bundles.get(bundleName);
        if (messages == null) {
            messages = loader != null ? ResourceBundle.getBundle(bundleName, locale, loader) : ResourceBundle.getBundle(bundleName, locale, I18NHelper.getSystemClassLoaderPrivileged());
            bundles.put(bundleName, messages);
        }
        return messages;
    }

    private void assertBundle() {
        if (this.failure != null) {
            throw new JDOFatalInternalException("No resources could be found for bundle:\"" + this.bundle + "\" ", this.failure);
        }
    }

    private void assertBundle(String key) {
        if (this.failure != null) {
            throw new JDOFatalInternalException("No resources could be found to annotate error message key:\"" + key + "\"", this.failure);
        }
    }

    private static final String getMessage(ResourceBundle messages, String messageKey) {
        return messages.getString(messageKey);
    }

    private static final String getMessage(ResourceBundle messages, String messageKey, Object[] msgArgs) {
        for (int i = 0; i < msgArgs.length; ++i) {
            if (msgArgs[i] != null) continue;
            msgArgs[i] = "";
        }
        MessageFormat formatter = new MessageFormat(messages.getString(messageKey));
        return formatter.format(msgArgs);
    }

    private static final String getMessage(ResourceBundle messages, String messageKey, Object arg) {
        Object[] args = new Object[]{arg};
        return I18NHelper.getMessage(messages, messageKey, args);
    }

    private static final String getMessage(ResourceBundle messages, String messageKey, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg1, arg2};
        return I18NHelper.getMessage(messages, messageKey, args);
    }

    private static final String getMessage(ResourceBundle messages, String messageKey, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg1, arg2, arg3};
        return I18NHelper.getMessage(messages, messageKey, args);
    }

    private static final String getMessage(ResourceBundle messages, String messageKey, int arg) {
        Object[] args = new Object[]{arg};
        return I18NHelper.getMessage(messages, messageKey, args);
    }

    private static final String getMessage(ResourceBundle messages, String messageKey, boolean arg) {
        Object[] args = new Object[]{String.valueOf(arg)};
        return I18NHelper.getMessage(messages, messageKey, args);
    }

    private static final String getPackageName(String className) {
        int index = className.lastIndexOf(46);
        return index != -1 ? className.substring(0, index) : "";
    }

    private static ClassLoader getSystemClassLoaderPrivileged() {
        return I18NHelper.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }

    private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
        try {
            return (T)LegacyJava.doPrivilegedAction.invoke(null, privilegedAction);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new JDOFatalInternalException(e.getMessage());
        }
    }
}

