/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.spi.JDOPermission;

public class LegacyJava {
    private static final boolean isSecurityDeprecated = LegacyJava.initIsSecurityDeprecated();
    private static final Method getSecurityManager = isSecurityDeprecated ? null : LegacyJava.findMethod("java.lang.System", "getSecurityManager", new Class[0]);
    private static final SecurityManager securityManager = getSecurityManager == null ? null : new SecurityManager();
    public static final Method doPrivilegedAction = LegacyJava.findMethod("java.security.AccessController", "doPrivileged", LegacyJava.class.getName(), PrivilegedAction.class);
    public static final Method doPrivilegedExceptionAction = LegacyJava.findMethod("java.security.AccessController", "doPrivileged", LegacyJava.class.getName(), PrivilegedExceptionAction.class);

    public static SecurityManager getSecurityManager() {
        Object sm;
        if (getSecurityManager == null) {
            return null;
        }
        try {
            sm = getSecurityManager.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            throw new JDOFatalInternalException(e.getMessage());
        }
        if (sm == null) {
            return null;
        }
        securityManager.updateSecurityManager(sm);
        return securityManager;
    }

    public static boolean isSecurityManagerDeprecated() {
        return isSecurityDeprecated;
    }

    private static boolean initIsSecurityDeprecated() {
        try {
            Method getSecurityManager = System.class.getMethod("getSecurityManager", new Class[0]);
            return getSecurityManager.isAnnotationPresent(Deprecated.class);
        }
        catch (NoSuchMethodException e) {
            return true;
        }
    }

    private static Method findMethod(String cName, String mName, Class<?> ... args) {
        if (isSecurityDeprecated) {
            return null;
        }
        try {
            Class<?> accessController = Class.forName(cName);
            return accessController.getMethod(mName, args);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new JDOFatalInternalException(e.getMessage());
        }
    }

    private static Method findMethod(String cName, String mName, String cNameAlt, Class<?> ... args) {
        if (isSecurityDeprecated) {
            cName = cNameAlt;
        }
        try {
            Class<?> accessController = Class.forName(cName);
            return accessController.getMethod(mName, args);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new JDOFatalInternalException(e.getMessage());
        }
    }

    public static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
        return privilegedAction.run();
    }

    public static <T> T doPrivileged(PrivilegedExceptionAction<T> privilegedAction) throws PrivilegedActionException {
        try {
            return privilegedAction.run();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
    }

    public static class SecurityManager {
        Object sm = null;
        Method checkPermissionMethod = null;

        public void checkPermission(JDOPermission permission) {
            try {
                this.checkPermissionMethod.invoke(null, permission);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
                throw new JDOFatalInternalException(e.getMessage());
            }
        }

        public void updateSecurityManager(Object sm) {
            if (this.sm != sm) {
                this.sm = sm;
                this.checkPermissionMethod = sm != null ? LegacyJava.findMethod("java.lang.SecurityManager", "checkPermission", new Class[]{Permission.class}) : null;
            }
        }
    }
}

