/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.io.FastStringWriter;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.spi.SerializationProvider;
import com.sun.faces.spi.SerializationProviderFactory;
import com.sun.faces.util.DebugUtil;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.LRUMap;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.ReflectionUtils;
import com.sun.faces.util.RequestStateManager;
import com.sun.faces.util.TypedCollections;
import com.sun.faces.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.faces.FacesException;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.render.ResponseStateManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateManagerImpl
extends StateManager {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static final String STATEMANAGED_SERIAL_ID_KEY = StateManagerImpl.class.getName() + ".SerialId";
    private static final String LOGICAL_VIEW_MAP = "com.sun.faces.logicalViewMap";
    private SerializationProvider serialProvider;
    private WebConfiguration webConfig;
    private int noOfViews;
    private int noOfViewsInLogicalView;
    private boolean compressViewState;
    private Map<String, Class<?>> classMap = new ConcurrentHashMap(32);
    private SecureRandom random;
    private boolean generateUniqueStateIds;

    public StateManagerImpl() {
        FacesContext fContext = FacesContext.getCurrentInstance();
        this.serialProvider = SerializationProviderFactory.createInstance(fContext.getExternalContext());
        this.webConfig = WebConfiguration.getInstance(fContext.getExternalContext());
        if (!this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.DevelopmentMode)) {
            this.classMap = new ConcurrentHashMap(32);
        }
        this.generateUniqueStateIds = this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.GenerateUniqueServerStateIds);
        if (this.generateUniqueStateIds) {
            this.random = new SecureRandom();
            this.random.nextBytes(new byte[1]);
        } else {
            this.random = null;
        }
        this.compressViewState = this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.CompressViewState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
        UIViewRoot viewRoot = null;
        if (this.isSavingStateInClient(context)) {
            viewRoot = this.restoreTree(context, viewId, renderKitId);
            if (viewRoot != null) {
                this.restoreState(context, viewRoot, renderKitId);
            }
        } else {
            Object[] stateArray;
            ResponseStateManager rsm = RenderKitUtils.getResponseStateManager(context, renderKitId);
            Object id = this.hasGetStateMethod(rsm) ? ((stateArray = (Object[])rsm.getState(context, viewId)) != null ? stateArray[0] : null) : rsm.getTreeStructureToRestore(context, viewId);
            if (null != id) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Begin restoring view in session for viewId " + viewId);
                }
                String idString = (String)id;
                int sep = idString.indexOf(58);
                assert (-1 != sep);
                assert (sep < idString.length());
                String idInLogicalMap = idString.substring(0, sep);
                String idInActualMap = idString.substring(sep + 1);
                ExternalContext externalCtx = context.getExternalContext();
                Object sessionObj = externalCtx.getSession(false);
                if (sessionObj == null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Can't Restore Server View State, session expired for viewId: " + viewId);
                    }
                    return null;
                }
                Object[] stateArray2 = null;
                Object object = sessionObj;
                synchronized (object) {
                    Map actualMap;
                    Map logicalMap = (Map)externalCtx.getSessionMap().get(LOGICAL_VIEW_MAP);
                    if (logicalMap != null && (actualMap = (Map)logicalMap.get(idInLogicalMap)) != null) {
                        RequestStateManager.set(context, LOGICAL_VIEW_MAP, idInLogicalMap);
                        if (rsm.isPostback(context)) {
                            RequestStateManager.set(context, "com.sun.faces.actualViewMap", idInActualMap);
                        }
                        stateArray2 = (Object[])actualMap.get(idInActualMap);
                    }
                }
                if (stateArray2 == null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Session Available, but View State does not exist for viewId: " + viewId);
                    }
                    return null;
                }
                viewRoot = this.restoreTree((Object[])((Object[])stateArray2[0]).clone());
                viewRoot.processRestoreState(context, this.handleRestoreState(stateArray2[1]));
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("End restoring view in session for viewId " + viewId);
                }
            }
        }
        return viewRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateManager.SerializedView saveSerializedView(FacesContext context) {
        StateManager.SerializedView result = null;
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot.isTransient()) {
            return result;
        }
        this.checkIdUniqueness(context, (UIComponent)viewRoot, new HashSet<String>(viewRoot.getChildCount() << 1));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Begin creating serialized view for " + viewRoot.getViewId());
        }
        ArrayList<TreeNode> treeList = new ArrayList<TreeNode>(32);
        Object state = viewRoot.processSaveState(context);
        StateManagerImpl.captureChild(treeList, 0, (UIComponent)viewRoot);
        Object[] tree = treeList.toArray();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("End creating serialized view " + viewRoot.getViewId());
        }
        if (!this.isSavingStateInClient(context)) {
            int logicalMapSize = this.getNumberOfViewsParameter();
            int actualMapSize = this.getNumberOfViewsInLogicalViewParameter();
            ExternalContext externalContext = context.getExternalContext();
            Object sessionObj = externalContext.getSession(true);
            Map sessionMap = externalContext.getSessionMap();
            Object object = sessionObj;
            synchronized (object) {
                String idInLogicalMap;
                Map<String, Map> logicalMap = TypedCollections.dynamicallyCastMap((Map)sessionMap.get(LOGICAL_VIEW_MAP), String.class, Map.class);
                if (logicalMap == null) {
                    logicalMap = new LRUMap<String, Map>(logicalMapSize);
                    sessionMap.put(LOGICAL_VIEW_MAP, logicalMap);
                }
                if ((idInLogicalMap = (String)RequestStateManager.get(context, LOGICAL_VIEW_MAP)) == null) {
                    String string = idInLogicalMap = this.generateUniqueStateIds ? this.createRandomId() : this.createIncrementalRequestId(context);
                }
                assert (null != idInLogicalMap);
                String idInActualMap = this.generateUniqueStateIds ? this.createRandomId() : this.createIncrementalRequestId(context);
                Map<String, Object[]> actualMap = TypedCollections.dynamicallyCastMap(logicalMap.get(idInLogicalMap), String.class, Object[].class);
                if (actualMap == null) {
                    actualMap = new LRUMap<String, Object[]>(actualMapSize);
                    logicalMap.put(idInLogicalMap, actualMap);
                }
                String id = idInLogicalMap + ':' + idInActualMap;
                result = new StateManager.SerializedView((StateManager)this, (Object)id, null);
                Object[] stateArray = actualMap.get(idInActualMap);
                if (stateArray != null) {
                    stateArray[0] = tree;
                    stateArray[1] = this.handleSaveState(state);
                } else {
                    actualMap.put(idInActualMap, new Object[]{tree, this.handleSaveState(state)});
                }
                sessionMap.put(LOGICAL_VIEW_MAP, logicalMap);
            }
        } else {
            result = new StateManager.SerializedView((StateManager)this, (Object)tree, state);
        }
        return result;
    }

    public void writeState(FacesContext context, StateManager.SerializedView state) throws IOException {
        String renderKitId = context.getViewRoot().getRenderKitId();
        ResponseStateManager rsm = RenderKitUtils.getResponseStateManager(context, renderKitId);
        if (this.hasGetStateMethod(rsm)) {
            Object[] stateArray = new Object[]{state.getStructure(), state.getState()};
            rsm.writeState(context, (Object)stateArray);
        } else {
            rsm.writeState(context, state);
        }
    }

    protected void checkIdUniqueness(FacesContext context, UIComponent component, Set<String> componentIds) throws IllegalStateException {
        Iterator kids = component.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            String id = kid.getClientId(context);
            if (componentIds.add(id)) {
                this.checkIdUniqueness(context, kid, componentIds);
                continue;
            }
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "jsf.duplicate_component_id_error", id);
            }
            FastStringWriter writer = new FastStringWriter(128);
            DebugUtil.simplePrintTree((UIComponent)context.getViewRoot(), id, writer);
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.DUPLICATE_COMPONENT_ID_ERROR", id) + '\n' + writer.toString();
            throw new IllegalStateException(message);
        }
    }

    protected int getNumberOfViewsInLogicalViewParameter() {
        if (this.noOfViewsInLogicalView != 0) {
            return this.noOfViewsInLogicalView;
        }
        String noOfViewsStr = this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.NumberOfLogicalViews);
        String defaultValue = WebConfiguration.WebContextInitParameter.NumberOfLogicalViews.getDefaultValue();
        try {
            this.noOfViewsInLogicalView = Integer.valueOf(noOfViewsStr);
        }
        catch (NumberFormatException nfe) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Error parsing the servetInitParameter " + WebConfiguration.WebContextInitParameter.NumberOfLogicalViews.getQualifiedName() + ". Using default " + this.noOfViewsInLogicalView);
            }
            try {
                this.noOfViewsInLogicalView = Integer.valueOf(defaultValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.noOfViewsInLogicalView;
    }

    protected int getNumberOfViewsParameter() {
        if (this.noOfViews != 0) {
            return this.noOfViews;
        }
        String noOfViewsStr = this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.NumberOfViews);
        String defaultValue = WebConfiguration.WebContextInitParameter.NumberOfViews.getDefaultValue();
        try {
            this.noOfViews = Integer.valueOf(noOfViewsStr);
        }
        catch (NumberFormatException nfe) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Error parsing the servetInitParameter " + WebConfiguration.WebContextInitParameter.NumberOfViews.getQualifiedName() + ". Using default " + this.noOfViews);
            }
            try {
                this.noOfViews = Integer.valueOf(defaultValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.noOfViews;
    }

    private Object handleSaveState(Object state) {
        if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.SerializeServerState)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            ObjectOutputStream oas = null;
            try {
                oas = this.serialProvider.createObjectOutputStream(this.compressViewState ? new GZIPOutputStream((OutputStream)baos, 1024) : baos);
                oas.writeObject(state);
                oas.flush();
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
            finally {
                if (oas != null) {
                    try {
                        oas.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return baos.toByteArray();
        }
        return state;
    }

    private Object handleRestoreState(Object state) {
        if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.SerializeServerState)) {
            ByteArrayInputStream bais = new ByteArrayInputStream((byte[])state);
            ObjectInputStream ois = null;
            try {
                ois = this.serialProvider.createObjectInputStream(this.compressViewState ? new GZIPInputStream((InputStream)bais, 1024) : bais);
                Object object = ois.readObject();
                return object;
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return state;
    }

    private String createIncrementalRequestId(FacesContext ctx) {
        Map sm = ctx.getExternalContext().getSessionMap();
        AtomicInteger idgen = (AtomicInteger)sm.get(STATEMANAGED_SERIAL_ID_KEY);
        if (idgen == null) {
            idgen = new AtomicInteger(1);
        }
        sm.put(STATEMANAGED_SERIAL_ID_KEY, idgen);
        return "j_id" + idgen.getAndIncrement();
    }

    private String createRandomId() {
        return Long.valueOf(this.random.nextLong()).toString();
    }

    private static void captureChild(List<TreeNode> tree, int parent, UIComponent c) {
        if (!c.isTransient()) {
            TreeNode n = new TreeNode(parent, c);
            int pos = tree.size();
            tree.add(n);
            StateManagerImpl.captureRest(tree, pos, c);
        }
    }

    private static void captureFacet(List<TreeNode> tree, int parent, String name, UIComponent c) {
        if (!c.isTransient()) {
            FacetNode n = new FacetNode(parent, name, c);
            int pos = tree.size();
            tree.add(n);
            StateManagerImpl.captureRest(tree, pos, c);
        }
    }

    private static void captureRest(List<TreeNode> tree, int pos, UIComponent c) {
        int sz = c.getChildCount();
        if (sz > 0) {
            List child = c.getChildren();
            for (int i = 0; i < sz; ++i) {
                StateManagerImpl.captureChild(tree, pos, (UIComponent)child.get(i));
            }
        }
        if ((sz = c.getFacetCount()) > 0) {
            for (Map.Entry entry : c.getFacets().entrySet()) {
                StateManagerImpl.captureFacet(tree, pos, (String)entry.getKey(), (UIComponent)entry.getValue());
            }
        }
    }

    private boolean hasGetStateMethod(ResponseStateManager instance) {
        return ReflectionUtils.lookupMethod(instance.getClass(), "getState", FacesContext.class, String.class) != null;
    }

    private UIComponent newInstance(TreeNode n) throws FacesException {
        try {
            Class t;
            Class clazz = t = this.classMap != null ? this.classMap.get(n.componentType) : null;
            if (t == null) {
                t = Util.loadClass(n.componentType, n);
                if (t != null && this.classMap != null) {
                    this.classMap.put(n.componentType, t);
                } else {
                    throw new NullPointerException();
                }
            }
            UIComponent c = (UIComponent)t.newInstance();
            c.setId(n.id);
            return c;
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    private UIViewRoot restoreTree(FacesContext context, String viewId, String renderKitId) {
        Object[] treeStructure;
        ResponseStateManager rsm = RenderKitUtils.getResponseStateManager(context, renderKitId);
        if (this.hasGetStateMethod(rsm)) {
            Object[] stateArray = (Object[])rsm.getState(context, viewId);
            if (stateArray == null) {
                return null;
            }
            treeStructure = (Object[])stateArray[0];
        } else {
            treeStructure = (Object[])rsm.getTreeStructureToRestore(context, viewId);
        }
        if (treeStructure == null) {
            return null;
        }
        UIViewRoot root = this.restoreTree(treeStructure);
        root.setViewId(viewId);
        return root;
    }

    private String createUniqueRequestId(FacesContext ctx) {
        Map sm = ctx.getExternalContext().getSessionMap();
        AtomicInteger idgen = (AtomicInteger)sm.get(STATEMANAGED_SERIAL_ID_KEY);
        if (idgen == null) {
            idgen = new AtomicInteger(1);
        }
        sm.put(STATEMANAGED_SERIAL_ID_KEY, idgen);
        return "j_id" + idgen.getAndIncrement();
    }

    private void restoreState(FacesContext context, UIViewRoot root, String renderKitId) {
        Object state;
        ResponseStateManager rsm = RenderKitUtils.getResponseStateManager(context, renderKitId);
        if (ReflectionUtils.lookupMethod(rsm.getClass(), "getState", FacesContext.class, String.class) != null) {
            Object[] stateArray = (Object[])rsm.getState(context, root.getViewId());
            state = stateArray[1];
        } else {
            state = rsm.getComponentStateToRestore(context);
        }
        root.processRestoreState(context, state);
    }

    private UIViewRoot restoreTree(Object[] tree) throws FacesException {
        for (int i = 0; i < tree.length; ++i) {
            UIComponent c;
            if (tree[i] instanceof FacetNode) {
                FacetNode fn = (FacetNode)tree[i];
                c = this.newInstance(fn);
                tree[i] = c;
                if (i == fn.parent) continue;
                ((UIComponent)tree[fn.parent]).getFacets().put(fn.facetName, c);
                continue;
            }
            TreeNode tn = (TreeNode)tree[i];
            c = this.newInstance(tn);
            tree[i] = c;
            if (i == tn.parent) continue;
            ((UIComponent)tree[tn.parent]).getChildren().add(c);
        }
        return (UIViewRoot)tree[0];
    }

    private static final class FacetNode
    extends TreeNode {
        public String facetName;
        private static final long serialVersionUID = -3777170310958005106L;

        public FacetNode() {
        }

        public FacetNode(int parent, String name, UIComponent c) {
            super(parent, c);
            this.facetName = name;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.facetName = in.readUTF();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeUTF(this.facetName);
        }
    }

    private static class TreeNode
    implements Externalizable {
        private static final String NULL_ID = "";
        public String componentType;
        public String id;
        public int parent;
        private static final long serialVersionUID = -835775352718473281L;

        public TreeNode() {
        }

        public TreeNode(int parent, UIComponent c) {
            this.parent = parent;
            this.id = c.getId();
            this.componentType = c.getClass().getName();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.parent);
            out.writeUTF(this.componentType);
            if (this.id != null) {
                out.writeUTF(this.id);
            } else {
                out.writeUTF(NULL_ID);
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.parent = in.readInt();
            this.componentType = in.readUTF();
            this.id = in.readUTF();
            if (this.id.length() == 0) {
                this.id = null;
            }
        }
    }
}

