/*
 * $Id: RegexValidatorTag.java,v 1.1.2.2 2008/12/15 19:30:22 rlubke Exp $
 */

/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */


package com.sun.faces.ext.taglib;

import com.sun.faces.ext.validator.RegexValidator;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.webapp.ValidatorELTag;
import javax.el.ValueExpression;


/**
 * Tag for the Regular Expression Validator.  Can accept a regex pattern as a
 * property - this will be used to validate against.
 * @author driscoll
 */
public class RegexValidatorTag extends ValidatorELTag {

    private static final long serialVersionUID = -8003419724035817795L;

    private ValueExpression regex;
    

    /**
     * Set the Regular Expression to use for validation.
     * @param pattern A regular expression - needs to be escaped, @see java.util.regex .
     */
    public void setPattern(ValueExpression pattern) {
        this.regex = pattern;
    }

    @Override
    protected Validator createValidator() {

        FacesContext ctx = FacesContext.getCurrentInstance();
        Application app = ctx.getApplication();
        RegexValidator validator =
                (RegexValidator) app.createValidator("com.sun.faces.ext.validator.RegexValidator");
        validator.setPattern((String) regex.getValue(ctx.getELContext()));
        return validator;
        
    }
}
