/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.LRUMap;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.TreeStructure;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.render.ResponseStateManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateManagerImpl
extends StateManager {
    private static final Logger LOGGER = Util.getLogger("javax.enterprise.resource.webcontainer.jsf.application");
    private HashMap<String, Boolean> responseStateManagerInfo = null;
    private char requestIdSerial = '\u0000';
    private int noOfViews = 0;
    private int noOfViewsInLogicalView = 0;

    public void buildTreeStructureToSave(FacesContext context, UIComponent component, TreeStructure treeStructure, Set<String> componentIds) {
        String id;
        if (null == componentIds) {
            componentIds = new HashSet<String>();
        }
        for (UIComponent kid : component.getChildren()) {
            id = kid.getClientId(context);
            if (id != null && !componentIds.add(id)) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "jsf.duplicate_component_id_error", id);
                }
                throw new IllegalStateException(MessageUtils.getExceptionMessageString("com.sun.faces.DUPLICATE_COMPONENT_ID_ERROR", id));
            }
            if (kid.isTransient()) continue;
            TreeStructure treeStructureChild = new TreeStructure(kid);
            treeStructure.addChild(treeStructureChild);
            this.buildTreeStructureToSave(context, kid, treeStructureChild, componentIds);
        }
        for (String facetName : component.getFacets().keySet()) {
            UIComponent facetComponent = (UIComponent)component.getFacets().get(facetName);
            id = facetComponent.getClientId(context);
            if (id != null && !componentIds.add(id)) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "jsf.duplicate_component_id_error", id);
                }
                throw new IllegalStateException(MessageUtils.getExceptionMessageString("com.sun.faces.DUPLICATE_COMPONENT_ID_ERROR", id));
            }
            if (facetComponent.isTransient()) continue;
            TreeStructure treeStructureFacet = new TreeStructure(facetComponent);
            treeStructure.addFacet(facetName, treeStructureFacet);
            this.buildTreeStructureToSave(context, facetComponent, treeStructureFacet, componentIds);
        }
    }

    public void restoreComponentTreeStructure(TreeStructure treeStructure, UIComponent component) {
        Iterator kids = treeStructure.getChildren();
        while (kids.hasNext()) {
            TreeStructure kid = (TreeStructure)kids.next();
            UIComponent child = kid.createComponent();
            component.getChildren().add(child);
            this.restoreComponentTreeStructure(kid, child);
        }
        Iterator facets = treeStructure.getFacetNames();
        while (facets.hasNext()) {
            String facetName = (String)facets.next();
            TreeStructure facetTreeStructure = treeStructure.getTreeStructureForFacet(facetName);
            UIComponent facetComponent = facetTreeStructure.createComponent();
            component.getFacets().put(facetName, facetComponent);
            this.restoreComponentTreeStructure(facetTreeStructure, facetComponent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
        if (null == renderKitId) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]);
            message = message + " renderKitId " + renderKitId;
            throw new IllegalArgumentException(message);
        }
        UIViewRoot viewRoot = null;
        if (this.isSavingStateInClient(context)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Begin restoring view from response " + viewId);
            }
            if ((viewRoot = this.restoreTreeStructure(context, viewId, renderKitId)) != null) {
                this.restoreComponentState(context, viewRoot, renderKitId);
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Possibly a new request. Tree structure could not  be restored for " + viewId);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("End restoring view from response " + viewId);
            }
        } else {
            Object id = null;
            ResponseStateManager rsm = RenderKitUtils.getResponseStateManager(context, renderKitId);
            if (this.hasDeclaredMethod(this.responseStateManagerInfo, renderKitId, rsm, "getState")) {
                Object[] stateArray = (Object[])rsm.getState(context, viewId);
                id = stateArray[0];
            } else {
                id = rsm.getTreeStructureToRestore(context, viewId);
            }
            if (null != id) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Begin restoring view in session for viewId " + viewId);
                }
                String idString = (String)id;
                String idInLogicalMap = null;
                String idInActualMap = null;
                int sep = idString.indexOf(58);
                assert (-1 != sep);
                assert (sep < idString.length());
                idInLogicalMap = idString.substring(0, sep);
                idInActualMap = idString.substring(sep + 1);
                ExternalContext externalCtx = context.getExternalContext();
                Object sessionObj = externalCtx.getSession(false);
                if (sessionObj == null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Can't Restore Server View State, session expired for viewId: " + viewId);
                    }
                    return null;
                }
                TreeStructure structRoot = null;
                Object[] stateArray = null;
                Object object = sessionObj;
                synchronized (object) {
                    Map actualMap;
                    Map logicalMap = (Map)externalCtx.getSessionMap().get("com.sun.faces.logicalViewMap");
                    if (logicalMap != null && (actualMap = (Map)logicalMap.get(idInLogicalMap)) != null) {
                        context.getExternalContext().getRequestMap().put("com.sun.faces.logicalViewMap", idInLogicalMap);
                        stateArray = (Object[])actualMap.get(idInActualMap);
                    }
                }
                if (stateArray == null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Session Available, but View State does not exist for viewId: " + viewId);
                    }
                    return null;
                }
                structRoot = (TreeStructure)stateArray[0];
                viewRoot = (UIViewRoot)structRoot.createComponent();
                this.restoreComponentTreeStructure(structRoot, (UIComponent)viewRoot);
                viewRoot.processRestoreState(context, stateArray[1]);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("End restoring view in session for viewId " + viewId);
                }
            }
        }
        return viewRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateManager.SerializedView saveSerializedView(FacesContext context) throws IllegalStateException {
        StateManager.SerializedView result = null;
        Object treeStructure = null;
        Object componentState = null;
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot.isTransient()) {
            return result;
        }
        this.checkIdUniqueness(context, (UIComponent)viewRoot, new HashSet<String>());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Begin creating serialized view for " + viewRoot.getViewId());
        }
        treeStructure = this.getTreeStructureToSave(context);
        componentState = this.getComponentStateToSave(context);
        result = new StateManager.SerializedView((StateManager)this, treeStructure, componentState);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("End creating serialized view " + viewRoot.getViewId());
        }
        if (!this.isSavingStateInClient(context)) {
            int logicalMapSize = this.getNumberOfViewsParameter(context);
            int actualMapSize = this.getNumberOfViewsInLogicalViewParameter(context);
            Object[] stateArray = new Object[]{treeStructure, componentState};
            ExternalContext externalContext = context.getExternalContext();
            Object sessionObj = externalContext.getSession(true);
            Map<String, Object> sessionMap = Util.getSessionMap(context);
            Object object = sessionObj;
            synchronized (object) {
                String idInLogicalMap;
                LRUMap logicalMap = (LRUMap)sessionMap.get("com.sun.faces.logicalViewMap");
                if (null == logicalMap) {
                    logicalMap = new LRUMap(logicalMapSize);
                    sessionMap.put("com.sun.faces.logicalViewMap", logicalMap);
                }
                if (null == (idInLogicalMap = (String)externalContext.getRequestMap().get("com.sun.faces.logicalViewMap"))) {
                    idInLogicalMap = this.createUniqueRequestId();
                }
                assert (null != idInLogicalMap);
                String idInActualMap = this.createUniqueRequestId();
                LRUMap<String, Object[]> actualMap = (LRUMap<String, Object[]>)logicalMap.get(idInLogicalMap);
                if (null == actualMap) {
                    actualMap = new LRUMap<String, Object[]>(actualMapSize);
                    logicalMap.put(idInLogicalMap, actualMap);
                }
                String id = idInLogicalMap + ':' + idInActualMap;
                result = new StateManager.SerializedView((StateManager)this, (Object)id, null);
                actualMap.put(idInActualMap, stateArray);
            }
        }
        return result;
    }

    public Object saveView(FacesContext context) {
        return super.saveView(context);
    }

    public void writeState(FacesContext context, StateManager.SerializedView state) throws IOException {
        ResponseStateManager rsm;
        String renderKitId = context.getViewRoot().getRenderKitId();
        if (this.hasDeclaredMethod(this.responseStateManagerInfo, renderKitId, rsm = RenderKitUtils.getResponseStateManager(context, renderKitId), "getState")) {
            Object[] stateArray = new Object[]{state.getStructure(), state.getState()};
            rsm.writeState(context, (Object)stateArray);
        } else {
            rsm.writeState(context, state);
        }
    }

    public void writeState(FacesContext context, Object state) throws IOException {
        super.writeState(context, state);
    }

    protected void checkIdUniqueness(FacesContext context, UIComponent component, Set<String> componentIds) throws IllegalStateException {
        Iterator kids = component.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            String id = kid.getClientId(context);
            if (componentIds.add(id)) {
                this.checkIdUniqueness(context, kid, componentIds);
                continue;
            }
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "jsf.duplicate_component_id_error", id);
            }
            throw new IllegalStateException(MessageUtils.getExceptionMessageString("com.sun.faces.DUPLICATE_COMPONENT_ID_ERROR", id));
        }
    }

    protected Object getComponentStateToSave(FacesContext context) {
        return context.getViewRoot().processSaveState(context);
    }

    protected int getNumberOfViewsInLogicalViewParameter(FacesContext context) {
        if (this.noOfViewsInLogicalView != 0) {
            return this.noOfViewsInLogicalView;
        }
        WebConfiguration webConfig = WebConfiguration.getInstance(context.getExternalContext());
        String noOfViewsStr = webConfig.getContextInitParameter(WebConfiguration.WebContextInitParameter.NumberOfLogicalViews);
        String defaultValue = WebConfiguration.WebContextInitParameter.NumberOfLogicalViews.getDefaultValue();
        try {
            this.noOfViewsInLogicalView = Integer.valueOf(noOfViewsStr);
        }
        catch (NumberFormatException nfe) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Error parsing the servetInitParameter " + WebConfiguration.WebContextInitParameter.NumberOfLogicalViews.getQualifiedName() + ". Using default " + this.noOfViewsInLogicalView);
            }
            try {
                this.noOfViewsInLogicalView = Integer.valueOf(defaultValue);
            }
            catch (NumberFormatException ne) {
                // empty catch block
            }
        }
        return this.noOfViewsInLogicalView;
    }

    protected int getNumberOfViewsParameter(FacesContext context) {
        if (this.noOfViews != 0) {
            return this.noOfViews;
        }
        WebConfiguration webConfig = WebConfiguration.getInstance(context.getExternalContext());
        String noOfViewsStr = webConfig.getContextInitParameter(WebConfiguration.WebContextInitParameter.NumberOfViews);
        String defaultValue = WebConfiguration.WebContextInitParameter.NumberOfViews.getDefaultValue();
        try {
            this.noOfViews = Integer.valueOf(noOfViewsStr);
        }
        catch (NumberFormatException nfe) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Error parsing the servetInitParameter " + WebConfiguration.WebContextInitParameter.NumberOfViews.getQualifiedName() + ". Using default " + this.noOfViews);
            }
            try {
                this.noOfViews = Integer.valueOf(defaultValue);
            }
            catch (NumberFormatException ne) {
                // empty catch block
            }
        }
        return this.noOfViews;
    }

    protected Object getTreeStructureToSave(FacesContext context) {
        TreeStructure structRoot = null;
        UIViewRoot viewRoot = context.getViewRoot();
        if (!viewRoot.isTransient()) {
            structRoot = new TreeStructure((UIComponent)viewRoot);
            this.buildTreeStructureToSave(context, (UIComponent)viewRoot, structRoot, null);
        }
        return structRoot;
    }

    protected void restoreComponentState(FacesContext context, UIViewRoot root, String renderKitId) {
        if (null == renderKitId) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]);
            message = message + " renderKitId " + renderKitId;
            throw new IllegalArgumentException(message);
        }
        Object state = null;
        ResponseStateManager rsm = RenderKitUtils.getResponseStateManager(context, renderKitId);
        if (this.hasDeclaredMethod(this.responseStateManagerInfo, renderKitId, rsm, "getState")) {
            Object[] stateArray = (Object[])rsm.getState(context, root.getViewId());
            state = stateArray[1];
        } else {
            state = rsm.getComponentStateToRestore(context);
        }
        root.processRestoreState(context, state);
    }

    protected UIViewRoot restoreSerializedView(FacesContext context, StateManager.SerializedView sv, String viewId) {
        if (sv == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Possibly a new request. Tree structure could not  be restored for " + viewId);
            }
            return null;
        }
        TreeStructure structRoot = (TreeStructure)sv.getStructure();
        if (structRoot == null) {
            return null;
        }
        UIComponent viewRoot = structRoot.createComponent();
        if (viewRoot != null) {
            this.restoreComponentTreeStructure(structRoot, viewRoot);
            Object state = sv.getState();
            viewRoot.processRestoreState(context, state);
        }
        return (UIViewRoot)viewRoot;
    }

    protected UIViewRoot restoreTreeStructure(FacesContext context, String viewId, String renderKitId) {
        if (null == renderKitId) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]);
            message = message + " renderKitId " + renderKitId;
            throw new IllegalArgumentException(message);
        }
        UIComponent viewRoot = null;
        TreeStructure structRoot = null;
        ResponseStateManager rsm = RenderKitUtils.getResponseStateManager(context, renderKitId);
        if (this.hasDeclaredMethod(this.responseStateManagerInfo, renderKitId, rsm, "getState")) {
            Object[] stateArray = (Object[])rsm.getState(context, viewId);
            structRoot = (TreeStructure)stateArray[0];
        } else {
            structRoot = (TreeStructure)rsm.getTreeStructureToRestore(context, viewId);
        }
        if (structRoot == null) {
            return null;
        }
        viewRoot = structRoot.createComponent();
        this.restoreComponentTreeStructure(structRoot, viewRoot);
        return (UIViewRoot)viewRoot;
    }

    private String createUniqueRequestId() {
        char c = this.requestIdSerial;
        this.requestIdSerial = (char)(c + '\u0001');
        if (c == '\uffff') {
            this.requestIdSerial = '\u0000';
        }
        return "j_id" + this.requestIdSerial;
    }

    private boolean hasDeclaredMethod(Map<String, Boolean> resultMap, String key, ResponseStateManager instance, String methodName) {
        Boolean value;
        boolean result = false;
        if (resultMap == null) {
            resultMap = new HashMap<String, Boolean>();
        }
        if ((value = resultMap.get(key)) != null) {
            return value;
        }
        result = Util.hasDeclaredMethod(instance, methodName);
        resultMap.put(key, result);
        return result;
    }
}

