/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.util.Util;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.MethodNotFoundException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;

public class ActionListenerImpl
implements ActionListener {
    private static Logger logger = Util.getLogger("javax.enterprise.resource.webcontainer.jsf.application");

    public void processAction(ActionEvent event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("processAction(" + event.getComponent().getId() + ")");
        }
        UIComponent source = event.getComponent();
        ActionSource actionSource = (ActionSource)source;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        Object invokeResult = null;
        String outcome = null;
        MethodBinding binding = null;
        binding = actionSource.getAction();
        if (binding != null) {
            try {
                invokeResult = binding.invoke(context, null);
                if (null != invokeResult) {
                    outcome = invokeResult.toString();
                }
            }
            catch (MethodNotFoundException e) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
                throw new FacesException(binding.getExpressionString() + ": " + e.getMessage(), (Throwable)e);
            }
            catch (EvaluationException e) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
                throw new FacesException(binding.getExpressionString() + ": " + e.getMessage(), (Throwable)e);
            }
        }
        NavigationHandler navHandler = application.getNavigationHandler();
        navHandler.handleNavigation(context, null != binding ? binding.getExpressionString() : null, outcome);
        context.renderResponse();
    }
}

