/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el.impl;

import com.sun.faces.el.impl.Coercions;
import com.sun.faces.el.impl.Constants;
import com.sun.faces.el.impl.ElException;
import com.sun.faces.el.impl.Expression;
import com.sun.faces.el.impl.ExpressionEvaluator;
import com.sun.faces.el.impl.ExpressionInfo;
import com.sun.faces.el.impl.ExpressionString;
import com.sun.faces.el.impl.parser.ELParser;
import com.sun.faces.el.impl.parser.ElParseException;
import com.sun.faces.el.impl.parser.ParseException;
import com.sun.faces.el.impl.parser.Token;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ExpressionEvaluatorImpl
implements ExpressionEvaluator {
    private static final String DEFAULT_EL_PARSER = "com.sun.faces.el.impl.parser.ELParserImpl";
    Map cachedExpressionStrings = null;
    static Map sCachedExpectedTypes;
    boolean mBypassCache;
    private String parserImplClass = "com.sun.faces.el.impl.parser.ELParserImpl";
    private Class parserClass;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public ExpressionEvaluatorImpl(String parserClass) {
        this(parserClass, false);
    }

    public ExpressionEvaluatorImpl(String parserClass, boolean pBypassCache) {
        this.mBypassCache = pBypassCache;
        if (!this.mBypassCache) {
            this.cachedExpressionStrings = Collections.synchronizedMap(new HashMap());
            sCachedExpectedTypes = new HashMap();
        }
        this.parserImplClass = parserClass;
    }

    public void setParserImplementation(String parserImplClass) {
        this.parserImplClass = parserImplClass;
    }

    public Expression parseExpression(ExpressionInfo exprInfo) throws ElException {
        Object parsedValue = this.parseExpressionString(exprInfo.jspExpressionString.toString());
        if (parsedValue instanceof String || parsedValue instanceof ExpressionString) {
            return new ELExpression(this);
        }
        return (Expression)parsedValue;
    }

    public Object evaluate(ExpressionInfo exprInfo) throws ElException {
        Class expectedType = exprInfo.getExpectedType();
        if (0 == exprInfo.jspExpressionString.bufLen) {
            throw new ElException(Constants.NULL_EXPRESSION_STRING);
        }
        Object parsedValue = this.parseExpressionString(exprInfo.jspExpressionString.toString());
        if (parsedValue instanceof String) {
            String strValue = (String)parsedValue;
            return this.convertStaticValueToExpectedType(strValue, expectedType);
        }
        if (parsedValue instanceof Expression) {
            Object value = ((Expression)parsedValue).evaluate(exprInfo);
            return this.convertToExpectedType(value, expectedType);
        }
        if (parsedValue instanceof ExpressionString) {
            String strValue = ((ExpressionString)parsedValue).evaluate(exprInfo);
            return this.convertToExpectedType(strValue, expectedType);
        }
        return null;
    }

    public Object parseExpressionString(String pExpressionString) throws ElException {
        Object ret;
        if (pExpressionString.length() == 0) {
            return "";
        }
        Object object = ret = this.mBypassCache ? null : (Object)this.cachedExpressionStrings.get(pExpressionString);
        if (ret == null) {
            ELParser parser = this.createParser(this.parserImplClass);
            parser.initParser(new StringReader(pExpressionString));
            try {
                ret = parser.ExpressionString();
                if (!this.mBypassCache) {
                    this.cachedExpressionStrings.put(pExpressionString, ret);
                }
            }
            catch (ElParseException exc) {
                if (exc instanceof ParseException) {
                    String message = ExpressionEvaluatorImpl.formatParseException(pExpressionString, (ParseException)exc);
                    throw new ElException(message, exc);
                }
                throw new ElException(exc.getMessage(), exc);
            }
        }
        return ret;
    }

    protected Object convertToExpectedType(Object pValue, Class pExpectedType) throws ElException {
        return Coercions.coerce(pValue, pExpectedType);
    }

    protected Object convertStaticValueToExpectedType(String pValue, Class pExpectedType) throws ElException {
        if (pExpectedType == (class$java$lang$String == null ? (class$java$lang$String = ExpressionEvaluatorImpl.class$("java.lang.String")) : class$java$lang$String) || pExpectedType == (class$java$lang$Object == null ? (class$java$lang$Object = ExpressionEvaluatorImpl.class$("java.lang.Object")) : class$java$lang$Object)) {
            return pValue;
        }
        if (!this.mBypassCache) {
            Map valueByString = ExpressionEvaluatorImpl.getOrCreateExpectedTypeMap(pExpectedType);
            if (valueByString.containsKey(pValue)) {
                return valueByString.get(pValue);
            }
            Object ret = Coercions.coerce(pValue, pExpectedType);
            valueByString.put(pValue, ret);
            return ret;
        }
        return Coercions.coerce(pValue, pExpectedType);
    }

    private ELParser createParser(String parser) {
        ELParser elParser;
        try {
            if (this.parserClass == null) {
                this.parserClass = Thread.currentThread().getContextClassLoader().loadClass(parser);
            }
            elParser = (ELParser)this.parserClass.newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to create parser: " + t.toString());
        }
        return elParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map getOrCreateExpectedTypeMap(Class pExpectedType) {
        Map map = sCachedExpectedTypes;
        synchronized (map) {
            Map ret = (Map)sCachedExpectedTypes.get(pExpectedType);
            if (ret == null) {
                ret = Collections.synchronizedMap(new HashMap());
                sCachedExpectedTypes.put(pExpectedType, ret);
            }
            return ret;
        }
    }

    static String formatParseException(String pExpressionString, ParseException pExc) {
        StringBuffer expectedBuf = new StringBuffer();
        int maxSize = 0;
        boolean printedOne = false;
        if (pExc.expectedTokenSequences == null) {
            return pExc.toString();
        }
        for (int i = 0; i < pExc.expectedTokenSequences.length; ++i) {
            if (maxSize < pExc.expectedTokenSequences[i].length) {
                maxSize = pExc.expectedTokenSequences[i].length;
            }
            for (int j = 0; j < pExc.expectedTokenSequences[i].length; ++j) {
                if (printedOne) {
                    expectedBuf.append(", ");
                }
                expectedBuf.append(pExc.tokenImage[pExc.expectedTokenSequences[i][j]]);
                printedOne = true;
            }
        }
        String expected = expectedBuf.toString();
        StringBuffer encounteredBuf = new StringBuffer();
        Token tok = pExc.currentToken.next;
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                encounteredBuf.append(" ");
            }
            if (tok.kind == 0) {
                encounteredBuf.append(pExc.tokenImage[0]);
                break;
            }
            encounteredBuf.append(ExpressionEvaluatorImpl.addEscapes(tok.image));
            tok = tok.next;
        }
        String encountered = encounteredBuf.toString();
        return MessageFormat.format(Constants.PARSE_EXCEPTION, expected, encountered);
    }

    static String addEscapes(String str) {
        StringBuffer retval = new StringBuffer();
        int length = str.length();
        block8: for (int i = 0; i < length; ++i) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    continue block8;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block8;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block8;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block8;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block8;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block8;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block8;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }

    public String parseAndRender(String pExpressionString) throws ElException {
        Object val = this.parseExpressionString(pExpressionString);
        if (val instanceof String) {
            return (String)val;
        }
        if (val instanceof Expression) {
            return "${" + ((Expression)val).getExpressionString() + "}";
        }
        if (val instanceof ExpressionString) {
            return ((ExpressionString)val).getExpressionString();
        }
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ELExpression
    extends Expression {
        private ExpressionEvaluator evaluator;
        private ExpressionInfo exprInfo;

        public ELExpression(ExpressionEvaluator evaluator) {
            this.evaluator = evaluator;
        }

        public Object evaluate(ExpressionInfo exprInfo) throws ElException {
            this.exprInfo = exprInfo;
            return this.evaluator.evaluate(exprInfo);
        }

        public String getExpressionString() {
            return this.exprInfo != null ? this.exprInfo.jspExpressionString.toString() : "";
        }
    }
}

