/**
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at
 * https://javaserverfaces.dev.java.net/CDDL.html or
 * legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permission and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * [Name of File] [ver.__] [Date]
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */
package javax.faces.component.html;

import java.io.IOException;
import java.util.List;
import java.util.ArrayList;

import javax.faces.context.FacesContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;


/*
 * ******* GENERATED CODE - DO NOT EDIT *******
 */


/**
 * <p>Represents a component that looks up a localized message in a
 * resource bundle, optionally uses it as a
 * <code>MessageFormat</code> pattern string and substitutes in
 * parameter values from nested <em>UIParameter</em> components, and
 * renders the result.  If the "dir" or "lang" attributes are
 * present, render a <code>span</code> element and pass them through
 * as attributes on the span.</p>
 * <p>By default, the <code>rendererType</code> property must be set to "<code>javax.faces.Format</code>".
 * This value can be changed by calling the <code>setRendererType()</code> method.</p>
 */
public class HtmlOutputFormat extends javax.faces.component.UIOutput {



    public HtmlOutputFormat() {
        super();
        setRendererType("javax.faces.Format");
    }


    /**
     * <p>The standard component type for this component.</p>
     */
    public static final String COMPONENT_TYPE = "javax.faces.HtmlOutputFormat";


    private java.lang.String dir;

    /**
     * <p>Return the value of the <code>dir</code> property.</p>
     * <p>Contents: Direction indication for text that does not inherit directionality.
     * Valid values are "LTR" (left-to-right) and "RTL" (right-to-left).
     */
    public java.lang.String getDir() {
        if (null != this.dir) {
            return this.dir;
        }
        ValueExpression _ve = getValueExpression("dir");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>dir</code> property.</p>
     */
    public void setDir(java.lang.String dir) {
        this.dir = dir;
    }


    private boolean escape = true;
    private boolean escape_set = false;

    /**
     * <p>Return the value of the <code>escape</code> property.</p>
     * <p>Contents: Flag indicating that characters that are sensitive
     * in HTML and XML markup must be escaped.  This flag
     * is set to "true" by default.
     */
    public boolean isEscape() {
        if (this.escape_set) {
            return this.escape;
        }
        ValueExpression _ve = getValueExpression("escape");
        if (_ve != null) {
            Object _result = _ve.getValue(getFacesContext().getELContext());
            if (_result == null) {
                return false;
            } else {
                return ((java.lang.Boolean) _result).booleanValue();
            }
        } else {
            return this.escape;
        }
    }

    /**
     * <p>Set the value of the <code>escape</code> property.</p>
     */
    public void setEscape(boolean escape) {
        this.escape = escape;
        this.escape_set = true;
    }


    private java.lang.String lang;

    /**
     * <p>Return the value of the <code>lang</code> property.</p>
     * <p>Contents: Code describing the language used in the generated markup
     * for this component.
     */
    public java.lang.String getLang() {
        if (null != this.lang) {
            return this.lang;
        }
        ValueExpression _ve = getValueExpression("lang");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>lang</code> property.</p>
     */
    public void setLang(java.lang.String lang) {
        this.lang = lang;
    }


    private java.lang.String style;

    /**
     * <p>Return the value of the <code>style</code> property.</p>
     * <p>Contents: CSS style(s) to be applied when this component is rendered.
     */
    public java.lang.String getStyle() {
        if (null != this.style) {
            return this.style;
        }
        ValueExpression _ve = getValueExpression("style");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>style</code> property.</p>
     */
    public void setStyle(java.lang.String style) {
        this.style = style;
    }


    private java.lang.String styleClass;

    /**
     * <p>Return the value of the <code>styleClass</code> property.</p>
     * <p>Contents: Space-separated list of CSS style class(es) to be applied when
     * this element is rendered.  This value must be passed through
     * as the "class" attribute on generated markup.
     */
    public java.lang.String getStyleClass() {
        if (null != this.styleClass) {
            return this.styleClass;
        }
        ValueExpression _ve = getValueExpression("styleClass");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>styleClass</code> property.</p>
     */
    public void setStyleClass(java.lang.String styleClass) {
        this.styleClass = styleClass;
    }


    private java.lang.String title;

    /**
     * <p>Return the value of the <code>title</code> property.</p>
     * <p>Contents: Advisory title information about markup elements generated
     * for this component.
     */
    public java.lang.String getTitle() {
        if (null != this.title) {
            return this.title;
        }
        ValueExpression _ve = getValueExpression("title");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>title</code> property.</p>
     */
    public void setTitle(java.lang.String title) {
        this.title = title;
    }


    public Object saveState(FacesContext _context) {
        Object[] _values = new Object[8];
        _values[0] = super.saveState(_context);
        _values[1] = dir;
        _values[2] = this.escape ? Boolean.TRUE : Boolean.FALSE;
        _values[3] = this.escape_set ? Boolean.TRUE : Boolean.FALSE;
        _values[4] = lang;
        _values[5] = style;
        _values[6] = styleClass;
        _values[7] = title;
        return _values;
}


    public void restoreState(FacesContext _context, Object _state) {
        Object[] _values = (Object[]) _state;
        super.restoreState(_context, _values[0]);
        this.dir = (java.lang.String) _values[1];
        this.escape = ((java.lang.Boolean) _values[2]).booleanValue();
        this.escape_set = ((Boolean) _values[3]).booleanValue();
        this.lang = (java.lang.String) _values[4];
        this.style = (java.lang.String) _values[5];
        this.styleClass = (java.lang.String) _values[6];
        this.title = (java.lang.String) _values[7];
    }


}
