/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.webapp;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.faces.render.RenderKit;
import javax.faces.webapp.FacetTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

public abstract class UIComponentTag
implements Tag {
    private static final String COMPONENT_TAG_STACK_ATTR = "javax.faces.webapp.COMPONENT_TAG_STACK";
    private static final String JSP_CREATED_COMPONENT_IDS = "javax.faces.webapp.COMPONENT_IDS";
    private static final String JSP_CREATED_FACET_NAMES = "javax.faces.webapp.FACET_NAMES";
    private static final String GLOBAL_ID_VIEW = "javax.faces.webapp.GLOBAL_ID_VIEW";
    private static final String CURRENT_FACES_CONTEXT = "javax.faces.webapp.CURRENT_FACES_CONTEXT";
    private static final String CURRENT_VIEW_ROOT = "javax.faces.webapp.CURRENT_VIEW_ROOT";
    private UIComponent component = null;
    private FacesContext context = null;
    private boolean created = false;
    private List createdComponents = null;
    private List createdFacets = null;
    protected PageContext pageContext = null;
    private Tag parent = null;
    private boolean suppressed = false;
    private String binding = null;
    private String id = null;
    private String rendered = null;

    public void setBinding(String binding) throws JspException {
        if (!UIComponentTag.isValueReference(binding)) {
            throw new IllegalArgumentException();
        }
        this.binding = binding;
    }

    public void setId(String id) {
        if (null != id && id.startsWith("_id")) {
            throw new IllegalArgumentException();
        }
        this.id = id;
    }

    public void setRendered(String rendered) {
        this.rendered = rendered;
    }

    public abstract String getComponentType();

    public UIComponent getComponentInstance() {
        return this.component;
    }

    public boolean getCreated() {
        return this.created;
    }

    public static UIComponentTag getParentUIComponentTag(PageContext context) {
        FacesContext facesContext = (FacesContext)context.getAttribute(CURRENT_FACES_CONTEXT);
        ExternalContext extContext = facesContext.getExternalContext();
        List list = (List)extContext.getRequestMap().get(COMPONENT_TAG_STACK_ATTR);
        if (list != null) {
            return (UIComponentTag)list.get(list.size() - 1);
        }
        return null;
    }

    public abstract String getRendererType();

    public static boolean isValueReference(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return value.indexOf("#{") != -1 && value.indexOf("#{") < value.indexOf(125);
    }

    public void setPageContext(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    public Tag getParent() {
        return this.parent;
    }

    public void setParent(Tag parent) {
        this.parent = parent;
    }

    public int doStartTag() throws JspException {
        this.context = (FacesContext)this.pageContext.getAttribute(CURRENT_FACES_CONTEXT);
        if (this.context == null) {
            this.context = FacesContext.getCurrentInstance();
            if (this.context == null) {
                throw new JspException("Cannot find FacesContext");
            }
            this.pageContext.setAttribute(CURRENT_FACES_CONTEXT, (Object)this.context);
        }
        this.setupResponseWriter();
        UIComponentTag parentTag = UIComponentTag.getParentUIComponentTag(this.pageContext);
        Map requestMap = this.context.getExternalContext().getRequestMap();
        Map<String, UIComponentTag> componentIds = null;
        if (parentTag == null) {
            componentIds = new HashMap();
            requestMap.put(GLOBAL_ID_VIEW, componentIds);
        } else {
            componentIds = (Map)requestMap.get(GLOBAL_ID_VIEW);
        }
        this.component = this.findComponent(this.context);
        UIComponentTag tagInstance = null;
        String clientId = null;
        if (this.id != null) {
            clientId = this.component.getClientId(this.context);
            UIComponentTag uIComponentTag = tagInstance = componentIds.get(clientId) == this ? this : null;
        }
        if (tagInstance == null) {
            if (null != this.id && clientId != null) {
                if (componentIds.containsKey(clientId)) {
                    throw new JspException((Throwable)new IllegalStateException("Duplicate component id: '" + clientId + "', first used in tag: '" + componentIds.get(clientId).getClass().getName() + "'"));
                }
                componentIds.put(clientId, this);
            }
            if (parentTag != null) {
                if (this.getFacetName() == null) {
                    parentTag.addChild(this.component);
                } else {
                    parentTag.addFacet(this.getFacetName());
                }
            }
        }
        this.suppressed = this.shouldBeSuppressed(parentTag);
        try {
            if (!this.isSuppressed() && !this.component.getRendersChildren()) {
                this.encodeBegin();
                this.context.getResponseWriter().flush();
            }
        }
        catch (IOException e) {
            this.component = null;
            this.context = null;
            throw new JspException((Throwable)e);
        }
        this.pushUIComponentTag();
        return this.getDoStartValue();
    }

    public int doEndTag() throws JspException {
        this.popUIComponentTag();
        this.removeOldChildren();
        this.removeOldFacets();
        try {
            if (!this.isSuppressed()) {
                if (this.component.getRendersChildren()) {
                    this.encodeBegin();
                    this.encodeChildren();
                }
                this.encodeEnd();
            }
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        finally {
            this.component = null;
            this.context = null;
        }
        this.created = false;
        return this.getDoEndValue();
    }

    public void release() {
        this.parent = null;
        this.binding = null;
        this.id = null;
        this.created = false;
        this.rendered = null;
    }

    protected void encodeBegin() throws IOException {
        this.component.encodeBegin(this.context);
    }

    protected void encodeChildren() throws IOException {
        this.component.encodeChildren(this.context);
    }

    protected void encodeEnd() throws IOException {
        this.component.encodeEnd(this.context);
    }

    protected UIComponent findComponent(FacesContext context) throws JspException {
        if (this.component != null) {
            return this.component;
        }
        UIComponentTag parentTag = UIComponentTag.getParentUIComponentTag(this.pageContext);
        UIComponent parentComponent = null;
        if (parentTag == null) {
            parentComponent = context.getViewRoot();
            if (null == parentComponent.getAttributes().get(CURRENT_VIEW_ROOT)) {
                this.setProperties(parentComponent);
                if (null != this.id) {
                    parentComponent.setId(this.id);
                }
                parentComponent.getAttributes().put(CURRENT_VIEW_ROOT, CURRENT_VIEW_ROOT);
            } else if (this.binding == null) {
                this.setProperties(parentComponent);
            }
            this.component = parentComponent;
            return this.component;
        }
        parentComponent = parentTag.getComponentInstance();
        String newId = this.createId();
        String facetName = this.getFacetName();
        if (facetName != null) {
            this.component = (UIComponent)parentComponent.getFacets().get(facetName);
            if (this.component == null) {
                this.component = this.createFacet(context, parentComponent, facetName, newId);
            }
            return this.component;
        }
        this.component = this.getChild(parentComponent, newId);
        if (this.component == null) {
            this.component = this.createChild(context, parentComponent, newId);
        }
        return this.component;
    }

    protected int getDoEndValue() throws JspException {
        return 6;
    }

    protected int getDoStartValue() throws JspException {
        return 1;
    }

    protected FacesContext getFacesContext() {
        return this.context;
    }

    protected String getFacetName() {
        Tag parent = this.getParent();
        if (parent instanceof FacetTag) {
            return ((FacetTag)parent).getName();
        }
        return null;
    }

    protected String getId() {
        return this.id;
    }

    protected boolean isSuppressed() {
        return this.suppressed;
    }

    protected void setProperties(UIComponent component) {
        if (this.rendered != null) {
            if (UIComponentTag.isValueReference(this.rendered)) {
                ValueBinding vb = this.context.getApplication().createValueBinding(this.rendered);
                component.setValueBinding("rendered", vb);
            } else {
                component.setRendered(Boolean.valueOf(this.rendered));
            }
        }
        if (this.getRendererType() != null) {
            component.setRendererType(this.getRendererType());
        }
    }

    protected void setupResponseWriter() {
        ResponseWriter writer = this.context.getResponseWriter();
        if (writer == null) {
            RenderKit renderKit = this.context.getRenderKit();
            writer = renderKit.createResponseWriter(new Writer(){

                public void close() throws IOException {
                    UIComponentTag.this.pageContext.getOut().close();
                }

                public void flush() throws IOException {
                }

                public void write(char cbuf) throws IOException {
                    UIComponentTag.this.pageContext.getOut().write((int)cbuf);
                }

                public void write(char[] cbuf, int off, int len) throws IOException {
                    UIComponentTag.this.pageContext.getOut().write(cbuf, off, len);
                }

                public void write(int c) throws IOException {
                    UIComponentTag.this.pageContext.getOut().write(c);
                }

                public void write(String str) throws IOException {
                    UIComponentTag.this.pageContext.getOut().write(str);
                }

                public void write(String str, int off, int len) throws IOException {
                    UIComponentTag.this.pageContext.getOut().write(str, off, len);
                }
            }, null, this.pageContext.getRequest().getCharacterEncoding());
            this.context.setResponseWriter(writer);
        }
    }

    private void addChild(UIComponent child) {
        if (this.createdComponents == null) {
            this.createdComponents = new ArrayList();
        }
        this.createdComponents.add(child.getId());
    }

    private void addFacet(String name) {
        if (this.createdFacets == null) {
            this.createdFacets = new ArrayList();
        }
        this.createdFacets.add(name);
    }

    private UIComponent createComponent(FacesContext context, String newId) {
        UIComponent component = null;
        Application application = context.getApplication();
        if (this.binding != null) {
            ValueBinding vb = application.createValueBinding(this.binding);
            component = application.createComponent(vb, context, this.getComponentType());
            component.setValueBinding("binding", vb);
        } else {
            component = application.createComponent(this.getComponentType());
        }
        component.setId(newId);
        this.setProperties(component);
        return component;
    }

    private UIComponent createChild(FacesContext context, UIComponent parent, String componentId) {
        UIComponent component = this.createComponent(context, componentId);
        UIComponentTag parentTag = UIComponentTag.getParentUIComponentTag(this.pageContext);
        parent.getChildren().add(parentTag.getIndex(), component);
        this.created = true;
        return component;
    }

    private UIComponent createFacet(FacesContext context, UIComponent parent, String name, String newId) {
        UIComponent component = this.createComponent(context, newId);
        parent.getFacets().put(name, component);
        this.created = true;
        return component;
    }

    private String createId() {
        if (this.id == null) {
            FacesContext context = (FacesContext)this.pageContext.getAttribute(CURRENT_FACES_CONTEXT);
            return context.getViewRoot().createUniqueId();
        }
        return this.id;
    }

    private UIComponent getChild(UIComponent component, String componentId) {
        Iterator kids = component.getChildren().iterator();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!componentId.equals(kid.getId())) continue;
            return kid;
        }
        return null;
    }

    private int getIndex() {
        if (this.createdComponents != null) {
            return this.createdComponents.size();
        }
        return 0;
    }

    private void popUIComponentTag() {
        Map requestMap = this.context.getExternalContext().getRequestMap();
        List list = (List)requestMap.get(COMPONENT_TAG_STACK_ATTR);
        if (list != null) {
            list.remove(list.size() - 1);
            if (list.size() < 1) {
                requestMap.remove(COMPONENT_TAG_STACK_ATTR);
            }
        }
    }

    private void pushUIComponentTag() {
        Map requestMap = this.context.getExternalContext().getRequestMap();
        ArrayList<UIComponentTag> list = (ArrayList<UIComponentTag>)requestMap.get(COMPONENT_TAG_STACK_ATTR);
        if (list == null) {
            list = new ArrayList<UIComponentTag>();
            requestMap.put(COMPONENT_TAG_STACK_ATTR, list);
        }
        list.add(this);
    }

    private void removeOldChildren() {
        List oldList = (List)this.component.getAttributes().get(JSP_CREATED_COMPONENT_IDS);
        if (oldList != null) {
            if (this.createdComponents != null) {
                Iterator olds = oldList.iterator();
                while (olds.hasNext()) {
                    UIComponent child;
                    String old = (String)olds.next();
                    if (this.createdComponents.contains(old) || (child = this.component.findComponent(old)) == null) continue;
                    this.component.getChildren().remove(child);
                }
            } else {
                Iterator olds = oldList.iterator();
                while (olds.hasNext()) {
                    String old = (String)olds.next();
                    UIComponent child = this.component.findComponent(old);
                    this.component.getChildren().remove(child);
                }
            }
        }
        if (this.createdComponents != null) {
            this.component.getAttributes().put(JSP_CREATED_COMPONENT_IDS, this.createdComponents);
        } else {
            this.component.getAttributes().remove(JSP_CREATED_COMPONENT_IDS);
        }
        this.createdComponents = null;
    }

    private void removeOldFacets() {
        List oldList = (List)this.component.getAttributes().get(JSP_CREATED_FACET_NAMES);
        if (oldList != null) {
            if (this.createdFacets != null) {
                Iterator olds = oldList.iterator();
                while (olds.hasNext()) {
                    String old = (String)olds.next();
                    if (this.createdFacets.contains(old)) continue;
                    this.component.getFacets().remove(old);
                }
            } else {
                Iterator olds = oldList.iterator();
                while (olds.hasNext()) {
                    String old = (String)olds.next();
                    this.component.getFacets().remove(old);
                }
            }
        }
        if (this.createdFacets != null) {
            this.component.getAttributes().put(JSP_CREATED_FACET_NAMES, this.createdFacets);
        } else {
            this.component.getAttributes().remove(JSP_CREATED_FACET_NAMES);
        }
        this.createdFacets = null;
    }

    private boolean shouldBeSuppressed(UIComponentTag parentTag) {
        if (this.getFacetName() != null) {
            return true;
        }
        if (parentTag != null && parentTag.isSuppressed()) {
            return true;
        }
        if (!this.component.isRendered()) {
            return true;
        }
        UIComponent parent = this.component.getParent();
        return parent != null && parent.getRendersChildren();
    }
}

