/*
 * Decompiled with CFR 0.152.
 */
package javax.faces;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;

public final class FactoryFinder {
    public static final String APPLICATION_FACTORY = "javax.faces.application.ApplicationFactory";
    public static final String FACES_CONTEXT_FACTORY = "javax.faces.context.FacesContextFactory";
    public static final String LIFECYCLE_FACTORY = "javax.faces.lifecycle.LifecycleFactory";
    public static final String RENDER_KIT_FACTORY = "javax.faces.render.RenderKitFactory";
    private static HashMap applicationMaps = new HashMap();
    private static String[] factoryNames = new String[]{"javax.faces.application.ApplicationFactory", "javax.faces.context.FacesContextFactory", "javax.faces.lifecycle.LifecycleFactory", "javax.faces.render.RenderKitFactory"};
    private static Map factoryClasses = null;
    static /* synthetic */ Class class$javax$faces$application$ApplicationFactory;
    static /* synthetic */ Class class$javax$faces$context$FacesContextFactory;
    static /* synthetic */ Class class$javax$faces$lifecycle$LifecycleFactory;
    static /* synthetic */ Class class$javax$faces$render$RenderKitFactory;

    FactoryFinder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getFactory(String factoryName) throws FacesException {
        FactoryFinder.validateFactoryName(factoryName);
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        HashMap hashMap = applicationMaps;
        synchronized (hashMap) {
            Map appMap = FactoryFinder.getApplicationMap();
            Object factory = null;
            Object factoryOrList = appMap.get(factoryName);
            if (factoryOrList != null && !(factoryOrList instanceof List)) {
                return factoryOrList;
            }
            factory = FactoryFinder.getImplementationInstance(classLoader, factoryName, (List)factoryOrList);
            appMap.put(factoryName, factory);
            return factory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFactory(String factoryName, String implName) {
        FactoryFinder.validateFactoryName(factoryName);
        ArrayList previouslySetFactories = null;
        Map appMap = null;
        HashMap hashMap = applicationMaps;
        synchronized (hashMap) {
            appMap = FactoryFinder.getApplicationMap();
            Object v = appMap.get(factoryName);
            previouslySetFactories = (ArrayList)v;
            if (null != v) {
                if (!(previouslySetFactories instanceof List)) {
                    return;
                }
            } else {
                previouslySetFactories = new ArrayList();
                appMap.put(factoryName, previouslySetFactories);
            }
            ((List)previouslySetFactories).add(0, implName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseFactories() throws FacesException {
        ClassLoader cl = FactoryFinder.getClassLoader();
        HashMap hashMap = applicationMaps;
        synchronized (hashMap) {
            HashMap map = (HashMap)applicationMaps.get(cl);
            if (map != null) {
                map.clear();
                applicationMaps.remove(cl);
            }
        }
    }

    private static ClassLoader getClassLoader() throws FacesException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            throw new FacesException("getContextClassLoader");
        }
        return cl;
    }

    private static Object getImplementationInstance(ClassLoader classLoader, String factoryName, List implementations) throws FacesException {
        Object result = null;
        String curImplClass = null;
        int len = 0;
        boolean i = false;
        if (null != implementations && (1 < (len = implementations.size()) || 1 == len)) {
            curImplClass = (String)implementations.remove(len - 1);
            result = FactoryFinder.getImplGivenPreviousImpl(classLoader, factoryName, curImplClass, null);
        }
        if (null != (curImplClass = FactoryFinder.getImplNameFromServices(classLoader, factoryName))) {
            result = FactoryFinder.getImplGivenPreviousImpl(classLoader, factoryName, curImplClass, result);
        }
        if (null != implementations) {
            for (len = implementations.size() - 1; 0 <= len; --len) {
                curImplClass = (String)implementations.remove(len);
                result = FactoryFinder.getImplGivenPreviousImpl(classLoader, factoryName, curImplClass, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String getImplNameFromServices(ClassLoader classLoader, String factoryName) {
        String result;
        block25: {
            Throwable t2;
            InputStream stream;
            BufferedReader reader;
            block22: {
                block21: {
                    result = null;
                    reader = null;
                    String resourceName = "META-INF/services/" + factoryName;
                    Object props = null;
                    stream = null;
                    stream = classLoader.getResourceAsStream(resourceName);
                    if (stream == null) break block21;
                    try {
                        reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        reader = new BufferedReader(new InputStreamReader(stream));
                    }
                    result = reader.readLine();
                    reader.close();
                    reader = null;
                    stream = null;
                }
                Object var9_10 = null;
                if (reader == null) break block22;
                try {
                    reader.close();
                }
                catch (Throwable t2) {
                    // empty catch block
                }
                reader = null;
                stream = null;
            }
            if (stream == null) break block25;
            try {
                stream.close();
            }
            catch (Throwable t2) {
                // empty catch block
            }
            stream = null;
            {
                break block25;
                catch (IOException e) {
                    Object var9_11 = null;
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable t2) {
                            // empty catch block
                        }
                        reader = null;
                        stream = null;
                    }
                    if (stream == null) break block25;
                    try {
                        stream.close();
                    }
                    catch (Throwable t2) {
                        // empty catch block
                    }
                    stream = null;
                    break block25;
                }
                catch (SecurityException e) {
                    Object var9_12 = null;
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable t2) {
                            // empty catch block
                        }
                        reader = null;
                        stream = null;
                    }
                    if (stream == null) break block25;
                    try {
                        stream.close();
                    }
                    catch (Throwable t2) {
                        // empty catch block
                    }
                    stream = null;
                }
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable t2) {
                        // empty catch block
                    }
                    reader = null;
                    stream = null;
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable t2) {
                        // empty catch block
                    }
                    stream = null;
                }
                throw throwable;
            }
        }
        return result;
    }

    private static Object getImplGivenPreviousImpl(ClassLoader classLoader, String factoryName, String implName, Object previousImpl) {
        Class<?> clazz = null;
        Class factoryClass = null;
        Class[] getCtorArg = null;
        Object[] newInstanceArgs = new Object[1];
        Constructor<?> ctor = null;
        Object result = null;
        if (null != previousImpl && null != (factoryClass = FactoryFinder.getFactoryClass(classLoader, factoryName))) {
            try {
                clazz = classLoader.loadClass(implName);
                getCtorArg = new Class[]{factoryClass};
                ctor = clazz.getConstructor(getCtorArg);
                newInstanceArgs[0] = previousImpl;
                result = ctor.newInstance(newInstanceArgs);
            }
            catch (NoSuchMethodException nsme) {
                factoryClass = null;
            }
            catch (Exception e) {
                throw new FacesException(implName, e);
            }
        }
        if (null == previousImpl || null == factoryClass) {
            try {
                clazz = classLoader.loadClass(implName);
                result = clazz.newInstance();
            }
            catch (Exception e) {
                throw new FacesException(implName, e);
            }
        }
        return result;
    }

    private static Class getFactoryClass(ClassLoader classLoader, String factoryClassName) {
        if (null == factoryClasses) {
            factoryClasses = new HashMap(factoryNames.length);
            factoryClasses.put(APPLICATION_FACTORY, class$javax$faces$application$ApplicationFactory == null ? (class$javax$faces$application$ApplicationFactory = FactoryFinder.class$(APPLICATION_FACTORY)) : class$javax$faces$application$ApplicationFactory);
            factoryClasses.put(FACES_CONTEXT_FACTORY, class$javax$faces$context$FacesContextFactory == null ? (class$javax$faces$context$FacesContextFactory = FactoryFinder.class$(FACES_CONTEXT_FACTORY)) : class$javax$faces$context$FacesContextFactory);
            factoryClasses.put(LIFECYCLE_FACTORY, class$javax$faces$lifecycle$LifecycleFactory == null ? (class$javax$faces$lifecycle$LifecycleFactory = FactoryFinder.class$(LIFECYCLE_FACTORY)) : class$javax$faces$lifecycle$LifecycleFactory);
            factoryClasses.put(RENDER_KIT_FACTORY, class$javax$faces$render$RenderKitFactory == null ? (class$javax$faces$render$RenderKitFactory = FactoryFinder.class$(RENDER_KIT_FACTORY)) : class$javax$faces$render$RenderKitFactory);
        }
        return (Class)factoryClasses.get(factoryClassName);
    }

    private static Map getApplicationMap() {
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        HashMap result = null;
        result = (HashMap)applicationMaps.get(classLoader);
        if (result == null) {
            result = new HashMap();
            applicationMaps.put(classLoader, result);
        }
        return result;
    }

    private static void validateFactoryName(String factoryName) {
        if (factoryName == null) {
            throw new NullPointerException();
        }
        boolean found = false;
        for (int i = 0; i < factoryNames.length; ++i) {
            if (!factoryName.equals(factoryNames[i])) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException(factoryName);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

