/*
 * Decompiled with CFR 0.152.
 */
package javax.cache.expiry;

import java.io.Serializable;
import javax.cache.Cache;
import javax.cache.configuration.Factory;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;

public final class TouchedExpiryPolicy<K, V>
implements ExpiryPolicy<K, V>,
Serializable {
    public static final long serialVersionUID = 201305291023L;
    private Duration expiryDuration;

    public TouchedExpiryPolicy(Duration expiryDuration) {
        this.expiryDuration = expiryDuration;
    }

    public static <K, V> Factory<ExpiryPolicy<? super K, ? super V>> factoryOf(Duration duration) {
        return new FactoryBuilder.SingletonFactory<ExpiryPolicy<? super K, ? super V>>(new TouchedExpiryPolicy<K, V>(duration));
    }

    @Override
    public Duration getExpiryForCreatedEntry(Cache.Entry<? extends K, ? extends V> entry) {
        return this.expiryDuration;
    }

    @Override
    public Duration getExpiryForAccessedEntry(Cache.Entry<? extends K, ? extends V> entry) {
        return this.expiryDuration;
    }

    @Override
    public Duration getExpiryForModifiedEntry(Cache.Entry<? extends K, ? extends V> entry) {
        return this.expiryDuration;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expiryDuration == null ? 0 : this.expiryDuration.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TouchedExpiryPolicy)) {
            return false;
        }
        TouchedExpiryPolicy other = (TouchedExpiryPolicy)obj;
        return !(this.expiryDuration == null ? other.expiryDuration != null : !this.expiryDuration.equals(other.expiryDuration));
    }
}

