/*
 * Decompiled with CFR 0.152.
 */
package javax.cache;

import javax.cache.Factory;

public final class Factories {
    private Factories() {
    }

    public static <T> Factory<T> of(Class<T> clazz) {
        return new ClassFactory<T>(clazz);
    }

    public static <T> Factory<T> of(T instance) {
        return new SingletonFactory<T>(instance);
    }

    public static class SingletonFactory<T>
    implements Factory<T> {
        private T instance;

        public SingletonFactory(T instance) {
            this.instance = instance;
        }

        @Override
        public T create() {
            return this.instance;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            SingletonFactory that = (SingletonFactory)other;
            return this.instance.equals(that.instance);
        }

        public int hashCode() {
            return this.instance.hashCode();
        }
    }

    public static class ClassFactory<T>
    implements Factory<T> {
        private Class<T> clazz;

        public ClassFactory(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        public T create() {
            try {
                return this.clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create an instance of " + this.clazz, e);
            }
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ClassFactory that = (ClassFactory)other;
            return this.clazz.equals(that.clazz);
        }

        public int hashCode() {
            return this.clazz.hashCode();
        }
    }
}

