/*
 * Decompiled with CFR 0.152.
 */
package javax.cache;

import javax.cache.Cache;
import javax.cache.Configuration;

public interface ExpiryPolicy<K, V> {
    public Configuration.Duration getTTLForCreatedEntry(Cache.Entry<? extends K, ? extends V> var1);

    public Configuration.Duration getTTLForAccessedEntry(Cache.Entry<? extends K, ? extends V> var1, Configuration.Duration var2);

    public Configuration.Duration getTTLForModifiedEntry(Cache.Entry<? extends K, ? extends V> var1, Configuration.Duration var2);

    public static final class Default<K, V>
    implements ExpiryPolicy<K, V> {
        @Override
        public Configuration.Duration getTTLForCreatedEntry(Cache.Entry<? extends K, ? extends V> entry) {
            return Configuration.Duration.ETERNAL;
        }

        @Override
        public Configuration.Duration getTTLForAccessedEntry(Cache.Entry<? extends K, ? extends V> entry, Configuration.Duration duration) {
            return duration;
        }

        @Override
        public Configuration.Duration getTTLForModifiedEntry(Cache.Entry<? extends K, ? extends V> entry, Configuration.Duration duration) {
            return duration;
        }

        public int hashCode() {
            return Default.class.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof Default;
        }
    }

    public static final class Modified<K, V>
    implements ExpiryPolicy<K, V> {
        private Configuration.Duration expiryDuration;

        public Modified(Configuration.Duration expiryDuration) {
            this.expiryDuration = expiryDuration;
        }

        @Override
        public Configuration.Duration getTTLForCreatedEntry(Cache.Entry<? extends K, ? extends V> entry) {
            return this.expiryDuration;
        }

        @Override
        public Configuration.Duration getTTLForAccessedEntry(Cache.Entry<? extends K, ? extends V> entry, Configuration.Duration duration) {
            return duration;
        }

        @Override
        public Configuration.Duration getTTLForModifiedEntry(Cache.Entry<? extends K, ? extends V> entry, Configuration.Duration duration) {
            return this.expiryDuration;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.expiryDuration == null ? 0 : this.expiryDuration.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Modified)) {
                return false;
            }
            Modified other = (Modified)obj;
            return !(this.expiryDuration == null ? other.expiryDuration != null : !this.expiryDuration.equals(other.expiryDuration));
        }
    }

    public static final class Accessed<K, V>
    implements ExpiryPolicy<K, V> {
        private Configuration.Duration expiryDuration;

        public Accessed(Configuration.Duration expiryDuration) {
            this.expiryDuration = expiryDuration;
        }

        @Override
        public Configuration.Duration getTTLForCreatedEntry(Cache.Entry<? extends K, ? extends V> entry) {
            return this.expiryDuration;
        }

        @Override
        public Configuration.Duration getTTLForAccessedEntry(Cache.Entry<? extends K, ? extends V> entry, Configuration.Duration duration) {
            return this.expiryDuration;
        }

        @Override
        public Configuration.Duration getTTLForModifiedEntry(Cache.Entry<? extends K, ? extends V> entry, Configuration.Duration duration) {
            return duration;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.expiryDuration == null ? 0 : this.expiryDuration.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Accessed)) {
                return false;
            }
            Accessed other = (Accessed)obj;
            return !(this.expiryDuration == null ? other.expiryDuration != null : !this.expiryDuration.equals(other.expiryDuration));
        }
    }
}

