/*
 * Decompiled with CFR 0.152.
 */
package javax.cache;

import java.util.HashMap;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.cache.CacheManager;
import javax.cache.OptionalFeature;
import javax.cache.spi.CacheManagerFactoryProvider;

public enum CacheManagerFactory {
    INSTANCE;

    public static final String DEFAULT_CACHE_MANAGER_NAME = "__default__";
    private final CacheManagerFactoryProvider serviceFactory;
    private final HashMap<String, CacheManager> cacheManagers = new HashMap();

    private CacheManagerFactory() {
        this.serviceFactory = this.getServiceFactory();
    }

    private CacheManagerFactoryProvider getServiceFactory() {
        ServiceLoader<CacheManagerFactoryProvider> serviceLoader = ServiceLoader.load(CacheManagerFactoryProvider.class);
        Iterator<CacheManagerFactoryProvider> it = serviceLoader.iterator();
        return it.hasNext() ? it.next() : null;
    }

    public CacheManager getCacheManager() {
        return this.getCacheManager(DEFAULT_CACHE_MANAGER_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheManager getCacheManager(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (this.serviceFactory == null) {
            throw new IllegalStateException("No CacheManagerFactoryProvider found in classpath.");
        }
        HashMap<String, CacheManager> hashMap = this.cacheManagers;
        synchronized (hashMap) {
            CacheManager cacheManager = this.cacheManagers.get(name);
            if (cacheManager == null) {
                cacheManager = this.serviceFactory.createCacheManager(name);
                this.cacheManagers.put(name, cacheManager);
            }
            return cacheManager;
        }
    }

    public boolean isSupported(OptionalFeature optionalFeature) {
        if (this.serviceFactory == null) {
            throw new IllegalStateException("CacheManagerFactoryProvider");
        }
        return this.serviceFactory.isSupported(optionalFeature);
    }
}

