/*
 * Decompiled with CFR 0.152.
 */
package javax.batch.operations;

import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.batch.operations.exception.JobExecutionAlreadyCompleteException;
import javax.batch.operations.exception.JobExecutionIsRunningException;
import javax.batch.operations.exception.JobExecutionNotMostRecentException;
import javax.batch.operations.exception.JobExecutionNotRunningException;
import javax.batch.operations.exception.JobRestartException;
import javax.batch.operations.exception.JobStartException;
import javax.batch.operations.exception.NoSuchJobException;
import javax.batch.operations.exception.NoSuchJobExecutionException;
import javax.batch.operations.exception.NoSuchJobInstanceException;
import javax.batch.operations.exception.SecurityException;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.StepExecution;

public interface JobOperator {
    public Set<String> getJobNames();

    public int getJobInstanceCount(String var1) throws NoSuchJobException, SecurityException;

    public List<JobInstance> getJobInstances(String var1, int var2, int var3) throws NoSuchJobException, SecurityException;

    public List<JobExecution> getRunningExecutions(String var1) throws NoSuchJobException;

    public List<JobExecution> getExecutions(JobInstance var1) throws NoSuchJobInstanceException, SecurityException;

    public Properties getParameters(JobInstance var1) throws NoSuchJobInstanceException, SecurityException;

    public long start(String var1, Properties var2) throws JobStartException;

    public long restart(long var1) throws JobExecutionAlreadyCompleteException, NoSuchJobExecutionException, JobExecutionNotMostRecentException, JobRestartException, SecurityException;

    public long restart(long var1, Properties var3) throws JobExecutionAlreadyCompleteException, NoSuchJobExecutionException, JobExecutionNotMostRecentException, JobRestartException, SecurityException;

    public void stop(long var1) throws NoSuchJobExecutionException, JobExecutionNotRunningException, SecurityException;

    public void abandon(JobExecution var1) throws NoSuchJobInstanceException, JobExecutionIsRunningException, SecurityException;

    public JobInstance getJobInstance(long var1) throws NoSuchJobExecutionException, SecurityException;

    public List<JobExecution> getJobExecutions(JobInstance var1) throws NoSuchJobInstanceException, SecurityException;

    public JobExecution getJobExecution(long var1) throws NoSuchJobExecutionException, SecurityException;

    public List<StepExecution> getStepExecutions(long var1) throws NoSuchJobExecutionException, SecurityException;

    public void purge(String var1);

    public static enum BatchStatus {
        STARTING,
        STARTED,
        STOPPING,
        STOPPED,
        FAILED,
        COMPLETED,
        ABANDONED;

    }
}

