/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.page;

import jakarta.data.Sort;
import jakarta.data.page.PageRequest;
import jakarta.data.page.PageRequestCursor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

record Pagination<T>(long page, int size, List<Sort<? super T>> sorts, PageRequest.Mode mode, PageRequest.Cursor type, boolean requestTotal) implements PageRequest<T>
{
    Pagination {
        if (page < 1L) {
            throw new IllegalArgumentException("pageNumber: " + page);
        }
        if (size < 1) {
            throw new IllegalArgumentException("maxPageSize: " + size);
        }
        if (mode != PageRequest.Mode.OFFSET && (type == null || type.size() == 0)) {
            throw new IllegalArgumentException("No key values were provided.");
        }
    }

    @Override
    public PageRequest<T> withoutTotal() {
        return new Pagination<T>(this.page, this.size, this.sorts, this.mode, this.type, false);
    }

    @Override
    public PageRequest<T> withTotal() {
        return new Pagination<T>(this.page, this.size, this.sorts, this.mode, this.type, true);
    }

    @Override
    public PageRequest<T> afterKey(Object ... key) {
        return new Pagination<T>(this.page, this.size, this.sorts, PageRequest.Mode.CURSOR_NEXT, new PageRequestCursor(key), this.requestTotal);
    }

    @Override
    public PageRequest<T> beforeKey(Object ... key) {
        return new Pagination<T>(this.page, this.size, this.sorts, PageRequest.Mode.CURSOR_PREVIOUS, new PageRequestCursor(key), this.requestTotal);
    }

    @Override
    public PageRequest<T> afterCursor(PageRequest.Cursor cursor) {
        return new Pagination<T>(this.page, this.size, this.sorts, PageRequest.Mode.CURSOR_NEXT, cursor, this.requestTotal);
    }

    @Override
    public PageRequest<T> beforeCursor(PageRequest.Cursor cursor) {
        return new Pagination<T>(this.page, this.size, this.sorts, PageRequest.Mode.CURSOR_PREVIOUS, cursor, this.requestTotal);
    }

    @Override
    public PageRequest<T> asc(String property) {
        return new Pagination<T>(this.page, this.size, Pagination.combine(this.sorts, Sort.asc(property)), this.mode, this.type, this.requestTotal);
    }

    @Override
    public PageRequest<T> ascIgnoreCase(String property) {
        return new Pagination<T>(this.page, this.size, Pagination.combine(this.sorts, Sort.ascIgnoreCase(property)), this.mode, this.type, this.requestTotal);
    }

    private static <E> List<E> combine(List<E> list, E element) {
        int size = list.size();
        if (size == 0) {
            return List.of(element);
        }
        Object[] array = list.toArray(new Object[size + 1]);
        array[size] = element;
        List<Object> newList = Collections.unmodifiableList(Arrays.asList(array));
        return newList;
    }

    @Override
    public Optional<PageRequest.Cursor> cursor() {
        return Optional.ofNullable(this.type);
    }

    @Override
    public PageRequest<T> desc(String property) {
        return new Pagination<T>(this.page, this.size, Pagination.combine(this.sorts, Sort.desc(property)), this.mode, this.type, this.requestTotal);
    }

    @Override
    public PageRequest<T> descIgnoreCase(String property) {
        return new Pagination<T>(this.page, this.size, Pagination.combine(this.sorts, Sort.descIgnoreCase(property)), this.mode, this.type, this.requestTotal);
    }

    @Override
    public PageRequest<T> next() {
        if (this.mode == PageRequest.Mode.OFFSET) {
            return new Pagination<T>(this.page + 1L, this.size, this.sorts, PageRequest.Mode.OFFSET, null, this.requestTotal);
        }
        throw new UnsupportedOperationException("Not supported for cursor-based pagination. Instead use afterKey or afterCursor to provide a cursor or obtain the nextPageRequest from a CursoredPage.");
    }

    @Override
    public PageRequest<T> previous() {
        if (this.mode == PageRequest.Mode.OFFSET) {
            return this.page() <= 1L ? null : new Pagination<T>(this.page - 1L, this.size, this.sorts, PageRequest.Mode.OFFSET, null, this.requestTotal);
        }
        throw new UnsupportedOperationException("Not supported for cursor-based pagination. Instead use beforeKey or beforeCursor to provide a cursor or obtain the previousPageRequest from a CursoredPage.");
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder(this.mode == PageRequest.Mode.OFFSET ? 100 : 150).append("PageRequest{page=").append(this.page).append(", size=").append(this.size);
        if (this.type != null) {
            s.append(", mode=").append((Object)this.mode).append(", ").append(this.type.size()).append(" keys");
        }
        for (Sort<T> sort : this.sorts) {
            s.append(", ").append(sort.property());
            if (sort.ignoreCase()) {
                s.append(" IGNORE CASE");
            }
            s.append(sort.isAscending() ? " ASC" : " DESC");
        }
        return s.append("}").toString();
    }

    @Override
    public PageRequest<T> page(long pageNumber) {
        return new Pagination<T>(pageNumber, this.size, this.sorts, this.mode, this.type, this.requestTotal);
    }

    @Override
    public PageRequest<T> size(int maxPageSize) {
        return new Pagination<T>(this.page, maxPageSize, this.sorts, this.mode, this.type, this.requestTotal);
    }

    @Override
    public PageRequest<T> sortBy(Iterable<Sort<? super T>> sorts) {
        List<Sort<? super T>> sortList = sorts instanceof List ? List.copyOf((List)sorts) : (sorts == null ? Collections.emptyList() : StreamSupport.stream(sorts.spliterator(), false).collect(Collectors.toUnmodifiableList()));
        return new Pagination<T>(this.page, this.size, sortList, this.mode, this.type, this.requestTotal);
    }

    @Override
    public PageRequest<T> sortBy(Sort<? super T> sort) {
        return new Pagination<T>(this.page, this.size, List.of(sort), this.mode, this.type, this.requestTotal);
    }

    @Override
    public PageRequest<T> sortBy(Sort<? super T> sort1, Sort<? super T> sort2) {
        return new Pagination<T>(this.page, this.size, List.of(sort1, sort2), this.mode, this.type, this.requestTotal);
    }

    @Override
    public PageRequest<T> sortBy(Sort<? super T> sort1, Sort<? super T> sort2, Sort<? super T> sort3) {
        return new Pagination<T>(this.page, this.size, List.of(sort1, sort2, sort3), this.mode, this.type, this.requestTotal);
    }

    @Override
    public PageRequest<T> sortBy(Sort<? super T> sort1, Sort<? super T> sort2, Sort<? super T> sort3, Sort<? super T> sort4) {
        return new Pagination<T>(this.page, this.size, List.of(sort1, sort2, sort3, sort4), this.mode, this.type, this.requestTotal);
    }

    @Override
    public PageRequest<T> sortBy(Sort<? super T> sort1, Sort<? super T> sort2, Sort<? super T> sort3, Sort<? super T> sort4, Sort<? super T> sort5) {
        return new Pagination<T>(this.page, this.size, List.of(sort1, sort2, sort3, sort4, sort5), this.mode, this.type, this.requestTotal);
    }
}

