/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data;

import jakarta.data.Sort;
import jakarta.data.page.PageRequest;
import java.util.Iterator;
import java.util.List;

public class Order<T>
implements Iterable<Sort<? super T>> {
    private final List<Sort<? super T>> sorts;

    private Order(List<Sort<? super T>> sorts) {
        this.sorts = sorts;
    }

    @SafeVarargs
    public static <T> Order<T> by(Sort<? super T> ... sorts) {
        return new Order<T>(List.of(sorts));
    }

    public List<Sort<? super T>> sorts() {
        return this.sorts;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof Order)) return false;
        Order s = (Order)other;
        if (!this.sorts.equals(s.sorts)) return false;
        return true;
    }

    public int hashCode() {
        return this.sorts.hashCode();
    }

    @Override
    public Iterator<Sort<? super T>> iterator() {
        return this.sorts.iterator();
    }

    public PageRequest<T> page(long pageNumber) {
        return PageRequest.ofPage(pageNumber).sortBy(this.sorts);
    }

    public PageRequest<T> pageSize(int size) {
        return PageRequest.ofSize(size).sortBy(this.sorts);
    }

    public String toString() {
        return this.sorts.toString();
    }
}

