/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.util;

import com.google.common.base.Charsets;
import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.IntSizeStringParser;
import it.unimi.dsi.big.util.FrontCodedStringBigList;
import it.unimi.dsi.fastutil.bytes.ByteBigList;
import it.unimi.dsi.fastutil.bytes.ByteMappedBigList;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongMappedBigList;
import it.unimi.dsi.fastutil.objects.AbstractObjectBigList;
import it.unimi.dsi.io.FileLinesByteArrayIterable;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.util.Properties;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.util.Iterator;
import java.util.RandomAccess;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappedFrontCodedStringBigList
extends AbstractObjectBigList<MutableString>
implements RandomAccess,
Closeable {
    public static final long serialVersionUID = 1L;
    public static final String PROPERTIES_EXTENSION = ".properties";
    public static final String BYTE_ARRAY_EXTENSION = ".bytearray";
    public static final String POINTERS_EXTENSION = ".pointers";
    protected final long n;
    protected final int ratio;
    protected ByteBigList byteList;
    protected LongBigList pointers;
    private final FileChannel fileChannel;

    protected MappedFrontCodedStringBigList(long n, int ratio, String byteBigList, String pointers) throws IOException {
        this.n = n;
        this.ratio = ratio;
        this.pointers = LongMappedBigList.map((FileChannel)FileChannel.open(new File(pointers).toPath(), new OpenOption[0]));
        this.fileChannel = FileChannel.open(new File(byteBigList).toPath(), new OpenOption[0]);
        this.byteList = ByteMappedBigList.map((FileChannel)this.fileChannel);
    }

    static int writeInt(FastBufferedOutputStream bytes, int length) throws IOException {
        int count;
        int i = count = MappedFrontCodedStringBigList.count(length);
        while (i-- != 1) {
            bytes.write(-(length >>> i * 7 & 0x7F) - 1);
        }
        bytes.write(length & 0x7F);
        return count;
    }

    public static void build(String basename, int ratio, Iterator<byte[]> arrays) throws IOException, ConfigurationException {
        if (ratio < 1) {
            throw new IllegalArgumentException("Illegal ratio (" + ratio + ")");
        }
        DataOutputStream pointers = new DataOutputStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(basename + POINTERS_EXTENSION)));
        FastBufferedOutputStream bytes = new FastBufferedOutputStream((OutputStream)new FileOutputStream(basename + BYTE_ARRAY_EXTENSION));
        long curSize = 0L;
        long n = 0L;
        int b = 0;
        byte[][] array = new byte[2][];
        while (arrays.hasNext()) {
            array[b] = arrays.next();
            int len = array[b].length;
            if (n % (long)ratio == 0L) {
                pointers.writeLong(curSize);
                curSize += (long)MappedFrontCodedStringBigList.writeInt(bytes, len);
                bytes.write(array[b], 0, len);
                curSize += (long)len;
            } else {
                int common;
                int minLength = Math.min(len, array[1 - b].length);
                for (common = 0; common < minLength && array[0][common] == array[1][common]; ++common) {
                }
                curSize += (long)MappedFrontCodedStringBigList.writeInt(bytes, len -= common);
                curSize += (long)MappedFrontCodedStringBigList.writeInt(bytes, common);
                bytes.write(array[b], common, len);
                curSize += (long)len;
            }
            b = 1 - b;
            ++n;
        }
        bytes.close();
        pointers.close();
        Properties properties = new Properties();
        properties.setProperty((Enum<?>)PropertyKeys.N, n);
        properties.setProperty((Enum<?>)PropertyKeys.RATIO, ratio);
        properties.save(basename + PROPERTIES_EXTENSION);
    }

    public static MappedFrontCodedStringBigList load(String basename) throws ConfigurationException, IOException {
        Properties properties = new Properties(basename + PROPERTIES_EXTENSION);
        return new MappedFrontCodedStringBigList(properties.getLong(PropertyKeys.N), properties.getInt(PropertyKeys.RATIO), basename + BYTE_ARRAY_EXTENSION, basename + POINTERS_EXTENSION);
    }

    public MutableString get(long index) {
        return MutableString.wrap(this.byte2Char(this.getArray(index), null));
    }

    public void get(long index, MutableString s) {
        byte[] a = this.getArray(index);
        s.length(MappedFrontCodedStringBigList.countUTF8Chars(a));
        this.byte2Char(a, s.array());
    }

    public String getString(long index) {
        return new String(this.getArray(index), StandardCharsets.UTF_8);
    }

    public byte[] getArray(long index) {
        this.ensureRestrictedIndex(index);
        int length = this.length(index);
        byte[] a = new byte[length];
        this.extract(index, a, 0, length);
        return a;
    }

    static int count(int length) {
        if (length < 128) {
            return 1;
        }
        if (length < 16384) {
            return 2;
        }
        if (length < 0x200000) {
            return 3;
        }
        if (length < 0x10000000) {
            return 4;
        }
        return 5;
    }

    static int readInt(ByteBigList a, long pos) {
        byte b0 = a.getByte(pos);
        if (b0 >= 0) {
            return b0;
        }
        byte b1 = a.getByte(pos + 1L);
        if (b1 >= 0) {
            return -b0 - 1 << 7 | b1;
        }
        byte b2 = a.getByte(pos + 2L);
        if (b2 >= 0) {
            return -b0 - 1 << 14 | -b1 - 1 << 7 | b2;
        }
        byte b3 = a.getByte(pos + 3L);
        if (b3 >= 0) {
            return -b0 - 1 << 21 | -b1 - 1 << 14 | -b2 - 1 << 7 | b3;
        }
        return -b0 - 1 << 28 | -b1 - 1 << 21 | -b2 - 1 << 14 | -b3 - 1 << 7 | a.getByte(pos + 4L);
    }

    private int length(long index) {
        ByteBigList array = this.byteList;
        int delta = (int)(index % (long)this.ratio);
        long pos = this.pointers.getLong(index / (long)this.ratio);
        int length = MappedFrontCodedStringBigList.readInt(array, pos);
        if (delta == 0) {
            return length;
        }
        pos += (long)(MappedFrontCodedStringBigList.count(length) + length);
        length = MappedFrontCodedStringBigList.readInt(array, pos);
        int common = MappedFrontCodedStringBigList.readInt(array, pos + (long)MappedFrontCodedStringBigList.count(length));
        for (int i = 0; i < delta - 1; ++i) {
            length = MappedFrontCodedStringBigList.readInt(array, pos += (long)(MappedFrontCodedStringBigList.count(length) + MappedFrontCodedStringBigList.count(common) + length));
            common = MappedFrontCodedStringBigList.readInt(array, pos + (long)MappedFrontCodedStringBigList.count(length));
        }
        return length + common;
    }

    private int extract(long index, byte[] a, int offset, int length) {
        long startPos;
        ByteBigList array = this.byteList;
        int delta = (int)(index % (long)this.ratio);
        long pos = startPos = this.pointers.getLong(index / (long)this.ratio);
        int arrayLength = MappedFrontCodedStringBigList.readInt(array, pos);
        int currLen = 0;
        if (delta == 0) {
            long pos1 = pos = this.pointers.getLong(index / (long)this.ratio) + (long)MappedFrontCodedStringBigList.count(arrayLength);
            array.getElements(pos1, a, offset, Math.min(length, arrayLength));
            return arrayLength;
        }
        int common = 0;
        for (int i = 0; i < delta; ++i) {
            long prevArrayPos = pos + (long)MappedFrontCodedStringBigList.count(arrayLength) + (long)(i != 0 ? MappedFrontCodedStringBigList.count(common) : 0);
            common = MappedFrontCodedStringBigList.readInt(array, (pos = prevArrayPos + (long)arrayLength) + (long)MappedFrontCodedStringBigList.count(arrayLength = MappedFrontCodedStringBigList.readInt(array, pos)));
            int actualCommon = Math.min(common, length);
            if (actualCommon <= currLen) {
                currLen = actualCommon;
                continue;
            }
            long pos1 = prevArrayPos;
            array.getElements(pos1, a, currLen + offset, actualCommon - currLen);
            currLen = actualCommon;
        }
        if (currLen < length) {
            array.getElements(pos + (long)MappedFrontCodedStringBigList.count(arrayLength) + (long)MappedFrontCodedStringBigList.count(common), a, currLen + offset, Math.min(arrayLength, length - currLen));
        }
        return arrayLength + common;
    }

    protected static int countUTF8Chars(byte[] a) {
        int length = a.length;
        int result = 0;
        for (int i = 0; i < length; ++i) {
            int b = (a[i] & 0xFF) >> 4;
            if (b < 8) {
                ++result;
                continue;
            }
            if (b < 14) {
                ++result;
                ++i;
                continue;
            }
            if (b < 15) {
                ++result;
                i += 2;
                continue;
            }
            result += 2;
            i += 4;
        }
        return result;
    }

    char[] byte2Char(byte[] a, char[] s) {
        int length = a.length;
        if (s == null) {
            s = new char[MappedFrontCodedStringBigList.countUTF8Chars(a)];
        }
        int j = 0;
        for (int i = 0; i < length; ++i) {
            int c;
            int b = a[i] & 0xFF;
            int t = b >> 4;
            if (t < 8) {
                s[j++] = (char)b;
                continue;
            }
            if (t < 14) {
                if (((c = a[++i] & 0xFF) & 0xC0) != 128) {
                    throw new IllegalStateException("Malformed internal UTF-8 encoding");
                }
                s[j++] = (char)((b & 0x1F) << 6 | c & 0x3F);
                continue;
            }
            if (t < 15) {
                c = a[++i] & 0xFF;
                byte d = a[++i];
                if ((c & 0xC0) != 128 || (d & 0xC0) != 128) {
                    throw new IllegalStateException("Malformed internal UTF-8 encoding");
                }
                s[j++] = (char)((b & 0xF) << 12 | (c & 0x3F) << 6 | (d & 0x3F) << 0);
                continue;
            }
            String surrogatePair = new String(a, i, 4, Charsets.UTF_8);
            s[j++] = surrogatePair.charAt(0);
            s[j++] = surrogatePair.charAt(1);
            i += 3;
        }
        return s;
    }

    public long size64() {
        return this.n;
    }

    @Override
    public void close() throws IOException {
        this.fileChannel.close();
    }

    public static void main(String[] arg) throws IOException, JSAPException, ConfigurationException, ClassNotFoundException, IllegalArgumentException, SecurityException {
        SimpleJSAP jsap = new SimpleJSAP(MappedFrontCodedStringBigList.class.getName(), "Dumps the files of a memory-mapped front-coded string big list reading from standard input a newline-separated list of UTF-8-encoded strings or a serialized FrontCodedStringBigList.", new Parameter[]{new Switch("object", 'o', "object", "Read a serialized FrontCodedStringBigList from standard input instead of a list of strings."), new FlaggedOption("ratio", (StringParser)IntSizeStringParser.getParser(), "4", false, 'r', "ratio", "The compression ratio."), new FlaggedOption("decompressor", (StringParser)JSAP.CLASS_PARSER, JSAP.NO_DEFAULT, false, 'd', "decompressor", "Use this extension of InputStream to decompress the strings (e.g., java.util.zip.GZIPInputStream)."), new UnflaggedOption("basename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the files associated with the memory-mapped front-coded string list.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String basename = jsapResult.getString("basename");
        Logger logger = LoggerFactory.getLogger(FrontCodedStringBigList.class);
        if (jsapResult.userSpecified("object")) {
            logger.info("Reading front-coded string big list...");
            FrontCodedStringBigList frontCodedStringBigList = (FrontCodedStringBigList)BinIO.loadObject((InputStream)System.in);
            logger.info("Dumping files...");
            frontCodedStringBigList.dump(basename);
        } else {
            int ratio = jsapResult.getInt("ratio");
            Class decompressor = jsapResult.getClass("decompressor");
            logger.info("Reading strings...");
            MappedFrontCodedStringBigList.build(basename, ratio, FileLinesByteArrayIterable.iterator(System.in, decompressor));
        }
        logger.info("Completed.");
    }

    public static enum PropertyKeys {
        N,
        RATIO;

    }
}

