/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.util;

import it.unimi.dsi.Util;
import java.io.Serializable;
import org.apache.commons.math3.random.AbstractRandomGenerator;

public class XorGensRandomGenerator
extends AbstractRandomGenerator
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final int WLEN = 64;
    private static final int R = 64;
    private static final int S = 53;
    private static final int A = 33;
    private static final int B = 26;
    private static final int C = 27;
    private static final int D = 29;
    private static final long WEYL = 7046029254386353131L;
    private long[] x = new long[64];
    private long weyl;
    private int i;

    public XorGensRandomGenerator() {
        this(Util.randomSeed());
    }

    public XorGensRandomGenerator(long seed) {
        this.setSeed(seed);
    }

    public void setSeed(long seed) {
        int k;
        long v = seed == 0L ? -1L : seed;
        for (k = 64; k > 0; --k) {
            v ^= v << 10;
            v ^= v >>> 15;
            v ^= v << 4;
            v ^= v >>> 13;
        }
        for (k = 0; k < 64; ++k) {
            v ^= v << 10;
            v ^= v >>> 15;
            v ^= v << 4;
            v ^= v >>> 13;
            this.x[k] = v;
        }
        this.i = 63;
        for (int k2 = 256; k2 > 0; --k2) {
            this.i = this.i + 1 & 0x3F;
            long t = this.x[this.i];
            t ^= t << 33;
            t ^= t >>> 26;
            v = this.x[this.i + 11 & 0x3F];
            v ^= v << 27;
            v ^= v >>> 29;
            this.x[this.i] = t ^ v;
        }
    }

    public long nextLong() {
        this.i = this.i + 1 & 0x3F;
        long t = this.x[this.i];
        long v = this.x[this.i + 11 & 0x3F];
        t ^= t << 33;
        v ^= v << 27;
        t ^= t >>> 26;
        v ^= v >>> 29;
        this.x[this.i] = v ^= t;
        this.weyl += 7046029254386353131L;
        return v + (this.weyl ^ this.weyl >>> 27);
    }

    public int nextInt() {
        return (int)this.nextLong();
    }

    public int nextInt(int n) {
        return (int)this.nextLong(n);
    }

    public long nextLong(long n) {
        long value;
        long bits;
        if (n <= 0L) {
            throw new IllegalArgumentException();
        }
        while ((bits = this.nextLong() >>> 1) - (value = bits % n) + (n - 1L) < 0L) {
        }
        return value;
    }

    public double nextDouble() {
        return (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
    }

    public float nextFloat() {
        return (float)(this.nextLong() >>> 40) * 5.9604645E-8f;
    }

    public boolean nextBoolean() {
        return this.nextLong() < 0L;
    }

    public void nextBytes(byte[] bytes) {
        int i = bytes.length;
        while (i != 0) {
            long bits = this.nextLong();
            long n = Math.min(i, 8);
            while (n-- != 0L) {
                bytes[--i] = (byte)bits;
                bits >>= 8;
            }
        }
    }
}

