/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.util;

import it.unimi.dsi.Util;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.util.SplitMix64RandomGenerator;
import java.io.Serializable;
import org.apache.commons.math3.random.AbstractRandomGenerator;

public class XoRoShiRo128StarStarRandomGenerator
extends AbstractRandomGenerator
implements Serializable {
    private static final long serialVersionUID = 0L;
    private long s0;
    private long s1;
    private static final long[] JUMP = new long[]{-2337365368286915419L, 1659688472399708668L};
    private static final long[] LONG_JUMP = new long[]{-3266927057705177477L, -2459076376072127807L};

    protected XoRoShiRo128StarStarRandomGenerator(long s0, long s1) {
        this.s0 = s0;
        this.s1 = s1;
    }

    public XoRoShiRo128StarStarRandomGenerator() {
        this(Util.randomSeed());
    }

    public XoRoShiRo128StarStarRandomGenerator(long seed) {
        this.setSeed(seed);
    }

    public XoRoShiRo128StarStarRandomGenerator copy() {
        return new XoRoShiRo128StarStarRandomGenerator(this.s0, this.s1);
    }

    public long nextLong() {
        long s0;
        long result = s0 = this.s0;
        result = Long.rotateLeft(result + (result << 2), 7);
        result += result << 3;
        long s1 = this.s1;
        this.s0 = Long.rotateLeft(s0, 24) ^ (s1 ^= s0) ^ s1 << 16;
        this.s1 = Long.rotateLeft(s1, 37);
        return result;
    }

    public int nextInt() {
        return (int)this.nextLong();
    }

    public int nextInt(int n) {
        return (int)this.nextLong(n);
    }

    public long nextLong(long n) {
        if (n <= 0L) {
            throw new IllegalArgumentException("illegal bound " + n + " (must be positive)");
        }
        long t = this.nextLong();
        long nMinus1 = n - 1L;
        long u = t >>> 1;
        while (u + nMinus1 - (t = u % n) < 0L) {
            u = this.nextLong() >>> 1;
        }
        return t;
    }

    public double nextDouble() {
        return (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
    }

    public double nextDoubleFast() {
        return Double.longBitsToDouble(0x3FF0000000000000L | this.nextLong() >>> 12) - 1.0;
    }

    public float nextFloat() {
        return (float)(this.nextLong() >>> 40) * 5.9604645E-8f;
    }

    public boolean nextBoolean() {
        return this.nextLong() < 0L;
    }

    public void nextBytes(byte[] bytes) {
        int i = bytes.length;
        int n = 0;
        while (i != 0) {
            n = Math.min(i, 8);
            long bits = this.nextLong();
            while (n-- != 0) {
                bytes[--i] = (byte)bits;
                bits >>= 8;
            }
        }
    }

    protected XoRoShiRo128StarStarRandomGenerator jump(long[] jump) {
        long s0 = 0L;
        long s1 = 0L;
        for (long element : jump) {
            for (int b = 0; b < 64; ++b) {
                if ((element & 1L << b) != 0L) {
                    s0 ^= this.s0;
                    s1 ^= this.s1;
                }
                this.nextLong();
            }
        }
        this.s0 = s0;
        this.s1 = s1;
        return this;
    }

    public XoRoShiRo128StarStarRandomGenerator jump() {
        return this.jump(JUMP);
    }

    public XoRoShiRo128StarStarRandomGenerator longJump() {
        return this.jump(LONG_JUMP);
    }

    public XoRoShiRo128StarStarRandomGenerator split() {
        this.nextLong();
        XoRoShiRo128StarStarRandomGenerator split = this.copy();
        long h0 = this.s0;
        long h1 = this.s1;
        long h2 = this.s0 + 6171709007915041769L;
        long h3 = this.s1 + -5504830798508614797L;
        h2 = Long.rotateLeft(h2, 50);
        h0 ^= (h2 += h3);
        h3 = Long.rotateLeft(h3, 52);
        h1 ^= (h3 += h0);
        h0 = Long.rotateLeft(h0, 30);
        h2 ^= (h0 += h1);
        h1 = Long.rotateLeft(h1, 41);
        h3 ^= (h1 += h2);
        h2 = Long.rotateLeft(h2, 54);
        h0 ^= (h2 += h3);
        h3 = Long.rotateLeft(h3, 48);
        h1 ^= (h3 += h0);
        h0 = Long.rotateLeft(h0, 38);
        h2 ^= (h0 += h1);
        h1 = Long.rotateLeft(h1, 37);
        h3 ^= (h1 += h2);
        h2 = Long.rotateLeft(h2, 62);
        h0 ^= (h2 += h3);
        h3 = Long.rotateLeft(h3, 34);
        h1 ^= (h3 += h0);
        h0 = Long.rotateLeft(h0, 5);
        h2 ^= (h0 += h1);
        h1 = Long.rotateLeft(h1, 36);
        split.s0 = h0;
        split.s1 = h1 += h2;
        return split;
    }

    public void setSeed(long seed) {
        SplitMix64RandomGenerator r = new SplitMix64RandomGenerator(seed);
        this.s0 = r.nextLong();
        this.s1 = r.nextLong();
    }

    public void setState(long[] state) {
        if (state.length != 2) {
            throw new IllegalArgumentException("The argument array contains " + state.length + " longs instead of " + 2);
        }
        this.s0 = state[0];
        this.s1 = state[1];
    }

    public static void main(String[] arg) {
        long n = Long.parseLong(arg[0]);
        long x = 0L;
        ProgressLogger pl = new ProgressLogger();
        XoRoShiRo128StarStarRandomGenerator r = new XoRoShiRo128StarStarRandomGenerator(0L);
        int k = 10;
        while (k-- != 0) {
            pl.start("Measuring...");
            long i = n;
            while (i-- != 0L) {
                x ^= r.nextLong();
            }
            pl.done(n);
            if (x != 0L) continue;
            System.out.println(x);
        }
    }
}

