/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.test;

import it.unimi.dsi.Util;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.util.TextPattern;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class TextPatternSpeedTest {
    private TextPatternSpeedTest() {
    }

    public static void main(String[] arg) {
        String target = null;
        MutableString ms = new MutableString();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            while ((line = br.readLine()) != null) {
                ms.append("\n").append(line);
            }
            ms.compact();
            target = ms.toString();
        }
        catch (IOException e) {
            System.out.println("Problems while reading target");
            e.printStackTrace(System.out);
            System.exit(1);
        }
        String p = arg[0];
        System.out.println("Searching for " + arg[0]);
        int k = 10;
        while (k-- != 0) {
            System.out.println();
            long start = -System.nanoTime();
            int n = 0;
            int r = 100;
            while (r-- != 0) {
                int i = -1;
                do {
                    i = target.indexOf(p, i + 1);
                    ++n;
                } while (i != -1);
            }
            System.out.println("Called indexOf() " + n + " times on a string in " + (start += System.nanoTime()) + " ns (" + Util.format((double)start / (double)n) + " ns/call)");
            TextPattern tp = new TextPattern(p);
            char[] a = ms.array();
            start = -System.nanoTime();
            n = 0;
            int r2 = 100;
            while (r2-- != 0) {
                int i = -1;
                do {
                    i = tp.search(a, i + 1);
                    ++n;
                } while (i != -1);
            }
            System.out.println("Called search() " + n + " times on a string in " + (start += System.nanoTime()) + " ns (" + Util.format((double)start / (double)n) + " ns/call)");
            MutableString pattern = new MutableString(p);
            start = -System.nanoTime();
            n = 0;
            int r3 = 100;
            while (r3-- != 0) {
                int i = -1;
                do {
                    i = ms.indexOf(pattern, i + 1);
                    ++n;
                } while (i != -1);
            }
            System.out.println("Called indexOf() " + n + " times on a mutable string in " + (start += System.nanoTime()) + " ns (" + Util.format((double)start / (double)n) + " ns/call)");
        }
    }
}

