/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.test;

import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import java.io.IOException;
import java.util.Arrays;

public final class GeneratePrecomputedOutputCodes {
    private GeneratePrecomputedOutputCodes() {
    }

    public static int writeUnary(int x, OutputBitStream obs) throws IOException {
        for (int i = 0; i < x; ++i) {
            obs.writeBit(0);
        }
        obs.writeBit(1);
        return x + 1;
    }

    public static int writeGamma(int x, OutputBitStream obs) throws IOException {
        int msb = Fast.mostSignificantBit(++x);
        int l = GeneratePrecomputedOutputCodes.writeUnary(msb, obs);
        return l + (msb != 0 ? obs.writeInt(x, msb) : 0);
    }

    public static int writeDelta(int x, OutputBitStream obs) throws IOException {
        int msb = Fast.mostSignificantBit(++x);
        int l = GeneratePrecomputedOutputCodes.writeGamma(msb, obs);
        return l + (msb != 0 ? obs.writeInt(x, msb) : 0);
    }

    public static int writeZeta(int x, int k, OutputBitStream obs) throws IOException {
        int msb = Fast.mostSignificantBit(++x);
        int h = msb / k;
        int l = GeneratePrecomputedOutputCodes.writeUnary(h, obs);
        int left = 1 << h * k;
        return l + (x - left < left ? obs.writeInt(x - left, h * k + k - 1) : obs.writeInt(x, h * k + k));
    }

    public static int writeShiftedGamma(int x, OutputBitStream obs) throws IOException {
        int msb = Fast.mostSignificantBit(x);
        int l = GeneratePrecomputedOutputCodes.writeUnary(msb + 1, obs);
        return l + (msb != -1 ? obs.writeInt(x, msb) : 0);
    }

    public static void main(String[] arg) throws IOException {
        int v;
        int l;
        int i;
        int length = Integer.parseInt(arg[0]);
        int size = 1 << length;
        byte[] a = new byte[4];
        InputBitStream inputBitStream = new InputBitStream(a);
        OutputBitStream outputBitStream = new OutputBitStream(a);
        int[] precomp = new int[size];
        for (i = 0; i < size; ++i) {
            Arrays.fill(a, (byte)0);
            outputBitStream.flush();
            outputBitStream.position(0L);
            l = GeneratePrecomputedOutputCodes.writeGamma(i, outputBitStream);
            outputBitStream.flush();
            inputBitStream.flush();
            inputBitStream.position(0L);
            v = inputBitStream.readInt(l);
            if (l > 26) {
                throw new IllegalArgumentException();
            }
            if (Fast.mostSignificantBit(l) > 5) {
                throw new IllegalArgumentException();
            }
            precomp[i] = l << 26 | v;
        }
        BinIO.storeInts((int[])precomp, (CharSequence)("gamma.out." + length));
        for (i = 0; i < size; ++i) {
            Arrays.fill(a, (byte)0);
            outputBitStream.flush();
            outputBitStream.position(0L);
            l = GeneratePrecomputedOutputCodes.writeDelta(i, outputBitStream);
            outputBitStream.flush();
            inputBitStream.flush();
            inputBitStream.position(0L);
            v = inputBitStream.readInt(l);
            if (l > 26) {
                throw new IllegalArgumentException();
            }
            if (Fast.mostSignificantBit(l) > 5) {
                throw new IllegalArgumentException();
            }
            precomp[i] = l << 26 | v;
        }
        BinIO.storeInts((int[])precomp, (CharSequence)("delta.out." + length));
        for (i = 0; i < size; ++i) {
            Arrays.fill(a, (byte)0);
            outputBitStream.flush();
            outputBitStream.position(0L);
            l = GeneratePrecomputedOutputCodes.writeZeta(i, 3, outputBitStream);
            outputBitStream.flush();
            inputBitStream.flush();
            inputBitStream.position(0L);
            v = inputBitStream.readInt(l);
            if (l > 26) {
                throw new IllegalArgumentException();
            }
            if (Fast.mostSignificantBit(l) > 5) {
                throw new IllegalArgumentException();
            }
            precomp[i] = l << 26 | v;
        }
        BinIO.storeInts((int[])precomp, (CharSequence)("zeta3.out." + length));
        for (i = 0; i < size; ++i) {
            Arrays.fill(a, (byte)0);
            outputBitStream.flush();
            outputBitStream.position(0L);
            l = GeneratePrecomputedOutputCodes.writeShiftedGamma(i, outputBitStream);
            outputBitStream.flush();
            inputBitStream.flush();
            inputBitStream.position(0L);
            v = inputBitStream.readInt(l);
            if (l > 26) {
                throw new IllegalArgumentException();
            }
            if (Fast.mostSignificantBit(l) > 5) {
                throw new IllegalArgumentException();
            }
            precomp[i] = l << 26 | v;
        }
        BinIO.storeInts((int[])precomp, (CharSequence)("shiftedgamma.out." + length));
    }
}

