/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.io;

import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.io.SafelyCloseable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import org.slf4j.LoggerFactory;

public class OfflineIterable<T, U extends T>
implements Iterable<U>,
SafelyCloseable,
Size64 {
    public static final long serialVersionUID = 1L;
    private final Serializer<? super T, U> serializer;
    private final File file;
    private final DataOutputStream dos;
    private final U store;
    private long size;
    private boolean closed;
    private FastBufferedOutputStream fbos;

    public OfflineIterable(Serializer<? super T, U> serializer, U store) throws IOException {
        this.serializer = serializer;
        this.store = store;
        this.file = File.createTempFile(OfflineIterable.class.getSimpleName(), "elmts");
        this.file.deleteOnExit();
        this.fbos = new FastBufferedOutputStream((OutputStream)new FileOutputStream(this.file));
        this.dos = new DataOutputStream((OutputStream)this.fbos);
    }

    public void add(T x) throws IOException {
        this.serializer.write(x, this.dos);
        ++this.size;
    }

    public void addAll(Iterable<T> it) throws IOException {
        for (T x : it) {
            this.add(x);
        }
    }

    public OfflineIterator<T, U> iterator() {
        try {
            this.dos.flush();
            DataInputStream dis = new DataInputStream((InputStream)new FastBufferedInputStream((InputStream)new FileInputStream(this.file)));
            return new OfflineIterator(dis, this.serializer, this.store, this.size);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void clear() throws IOException {
        if (this.closed) {
            throw new IOException("This" + this.getClass().getName() + " [" + this.toString() + "] has been closed.");
        }
        this.size = 0L;
        this.dos.flush();
        this.fbos.position(0L);
    }

    @Override
    public void close() {
        if (!this.closed) {
            try {
                this.dos.close();
                this.file.delete();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.closed = true;
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.closed) {
                LoggerFactory.getLogger(this.getClass()).warn("This " + this.getClass().getName() + " [" + this.toString() + "] should have been closed.");
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    @Deprecated
    public int size() {
        long size64 = this.size64();
        if (size64 > Integer.MAX_VALUE) {
            throw new IllegalStateException("The number of elements of this bit list (" + size64 + ") exceeds Integer.MAX_INT");
        }
        return (int)size64;
    }

    public long size64() {
        return this.size;
    }

    public static interface Serializer<A, B extends A> {
        public void write(A var1, DataOutput var2) throws IOException;

        public void read(DataInput var1, B var2) throws IOException;
    }

    public static final class OfflineIterator<A, B extends A>
    implements ObjectIterator<B>,
    SafelyCloseable {
        private final DataInputStream dis;
        private final long size;
        private final Serializer<? super A, B> serializer;
        private final B store;
        private long read;
        private boolean closed = false;

        private OfflineIterator(DataInputStream dis, Serializer<? super A, B> serializer, B store, long size) {
            this.dis = dis;
            this.serializer = serializer;
            this.store = store;
            this.size = size;
        }

        public boolean hasNext() {
            if (this.read >= this.size) {
                this.close();
            }
            return this.read < this.size;
        }

        public B next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                this.serializer.read(this.dis, this.store);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ++this.read;
            return this.store;
        }

        @Override
        public void close() {
            if (!this.closed) {
                try {
                    this.dis.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.closed = true;
            }
        }

        protected void finalize() throws Throwable {
            try {
                if (!this.closed) {
                    LoggerFactory.getLogger(this.getClass()).warn("This " + this.getClass().getName() + " [" + this.toString() + "] should have been closed.");
                    this.close();
                }
            }
            finally {
                super.finalize();
            }
        }
    }
}

