/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.bits;

import it.unimi.dsi.bits.AbstractBitVector;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.TransformationStrategy;
import java.io.Serializable;

@Deprecated
public class Utf16TransformationStrategy
implements TransformationStrategy<CharSequence>,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public long length(CharSequence s) {
        return (long)(s.length() + 1) * 16L;
    }

    @Override
    public BitVector toBitVector(CharSequence s) {
        return new Utf16CharSequenceBitVector(s);
    }

    @Override
    public long numBits() {
        return 0L;
    }

    @Override
    public TransformationStrategy<CharSequence> copy() {
        return new Utf16TransformationStrategy();
    }

    private static class Utf16CharSequenceBitVector
    extends AbstractBitVector
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient CharSequence s;
        private transient long length;
        private transient long actualEnd;

        public Utf16CharSequenceBitVector(CharSequence s) {
            this.s = s;
            this.actualEnd = (long)s.length() * 16L;
            this.length = this.actualEnd + 16L;
        }

        @Override
        public boolean getBoolean(long index) {
            if (index > this.length) {
                throw new IndexOutOfBoundsException();
            }
            if (index >= this.actualEnd) {
                return false;
            }
            int charIndex = (int)(index / 16L);
            return (this.s.charAt(charIndex) & 32768 >>> (int)(index % 16L)) != 0;
        }

        @Override
        public long getLong(long from, long to) {
            if (from % 64L == 0L && to % 16L == 0L) {
                long l;
                int pos = (int)(from / 16L);
                if (to == from + 64L) {
                    l = (to > this.actualEnd ? 0L : (long)this.s.charAt(pos + 3)) << 48 | (long)this.s.charAt(pos + 2) << 32 | (long)this.s.charAt(pos + 1) << 16 | (long)this.s.charAt(pos);
                } else {
                    l = 0L;
                    int residual = (int)(Math.min(this.actualEnd, to) - from);
                    int i = residual / 16;
                    while (i-- != 0) {
                        l |= (long)this.s.charAt(pos + i) << i * 16;
                    }
                }
                l = (l & 0x5555555555555555L) << 1 | l >>> 1 & 0x5555555555555555L;
                l = (l & 0x3333333333333333L) << 2 | l >>> 2 & 0x3333333333333333L;
                l = (l & 0xF0F0F0F0F0F0F0FL) << 4 | l >>> 4 & 0xF0F0F0F0F0F0F0FL;
                return (l & 0xFF00FF00FF00FFL) << 8 | l >>> 8 & 0xFF00FF00FF00FFL;
            }
            return super.getLong(from, to);
        }

        @Override
        public long length() {
            return this.length;
        }
    }
}

