/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.compression;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.compression.CodeWordCoder;
import it.unimi.dsi.compression.Decoder;
import it.unimi.dsi.compression.PrefixCodec;
import it.unimi.dsi.compression.PrefixCoder;
import it.unimi.dsi.compression.TreeDecoder;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import java.io.Serializable;

public class HuTuckerCodec
implements PrefixCodec,
Serializable {
    private static final boolean DEBUG = false;
    private static final long serialVersionUID = 2L;
    public final int size;
    private final TreeDecoder.Node root;
    private final CodeWordCoder coder;
    private final TreeDecoder decoder;

    private static long[] intArray2LongArray(int[] a) {
        long[] b = new long[a.length];
        int i = a.length;
        while (i-- != 0) {
            b[i] = a[i];
        }
        return b;
    }

    public HuTuckerCodec(int[] frequency) {
        this(HuTuckerCodec.intArray2LongArray(frequency));
    }

    public HuTuckerCodec(long[] frequency) {
        LevelNode n;
        int left;
        int right;
        int minRight;
        this.size = frequency.length;
        boolean[] internal = new boolean[this.size];
        boolean[] removed = new boolean[this.size];
        long[] compoundFrequency = new long[this.size];
        LevelNode[] externalNode = new LevelNode[this.size];
        LevelNode[] node = new LevelNode[this.size];
        int i = this.size;
        while (i-- != 0) {
            compoundFrequency[i] = frequency[i];
            node[i] = externalNode[i] = new LevelNode(i);
        }
        int first = 0;
        int last = this.size - 1;
        int minLeft = 0;
        int i2 = this.size;
        while (--i2 != 0) {
            minRight = -1;
            minLeft = -1;
            int currMinLeft = -1;
            long currPri = Long.MAX_VALUE;
            while (removed[first]) {
                ++first;
            }
            while (removed[last]) {
                --last;
            }
            right = first;
            assert (right < last);
            while (right < last) {
                left = currMinLeft = right;
                do {
                    if (removed[++right]) continue;
                    if (compoundFrequency[currMinLeft] + compoundFrequency[right] < currPri) {
                        currPri = compoundFrequency[currMinLeft] + compoundFrequency[right];
                        minLeft = currMinLeft;
                        minRight = right;
                    }
                    if (compoundFrequency[right] >= compoundFrequency[currMinLeft]) continue;
                    currMinLeft = right;
                } while ((removed[right] || internal[right]) && right < last);
                assert (right == last || !removed[right] && !internal[right]);
                assert (left < right);
            }
            internal[minLeft] = true;
            removed[minRight] = true;
            n = new LevelNode();
            n.left = node[minLeft];
            n.right = node[minRight];
            node[minLeft] = n;
            int n2 = minLeft;
            compoundFrequency[n2] = compoundFrequency[n2] + compoundFrequency[minRight];
        }
        this.markRec(node[minLeft], 0);
        BooleanArrays.fill((boolean[])removed, (boolean)false);
        System.arraycopy(externalNode, 0, node, 0, this.size);
        first = 0;
        minLeft = 0;
        last = this.size - 1;
        int i3 = this.size;
        while (--i3 != 0) {
            while (removed[first]) {
                ++first;
            }
            while (removed[last]) {
                --last;
            }
            left = first;
            minRight = -1;
            minLeft = -1;
            int currLevel = -1;
            while (left < last) {
                int leftLevel = node[left].level;
                assert (leftLevel > currLevel);
                for (right = left + 1; right <= last && removed[right]; ++right) {
                }
                assert (right <= last);
                assert (!removed[right]);
                if (leftLevel == node[right].level) {
                    currLevel = leftLevel;
                    minLeft = left;
                    minRight = right;
                }
                while (++left < last && (removed[left] || node[left].level <= currLevel)) {
                }
            }
            removed[minRight] = true;
            n = new LevelNode();
            n.left = node[minLeft];
            n.right = node[minRight];
            n.level = currLevel - 1;
            node[minLeft] = n;
        }
        this.root = this.rebuildTree(node[minLeft]);
        this.decoder = new TreeDecoder(this.root, this.size);
        this.coder = new CodeWordCoder(this.decoder.buildCodes());
    }

    private TreeDecoder.Node rebuildTree(LevelNode n) {
        if (n == null) {
            return null;
        }
        if (n.symbol != -1) {
            return new TreeDecoder.LeafNode(n.symbol);
        }
        TreeDecoder.Node newNode = new TreeDecoder.Node();
        newNode.left = this.rebuildTree((LevelNode)n.left);
        newNode.right = this.rebuildTree((LevelNode)n.right);
        return newNode;
    }

    private void markRec(LevelNode n, int height) {
        if (n == null) {
            return;
        }
        n.level = height;
        this.markRec((LevelNode)n.left, height + 1);
        this.markRec((LevelNode)n.right, height + 1);
    }

    @Override
    public CodeWordCoder coder() {
        return this.coder;
    }

    @Override
    public Decoder decoder() {
        return this.decoder;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public BitVector[] codeWords() {
        return this.coder.codeWords();
    }

    @Deprecated
    public PrefixCoder getCoder() {
        return this.coder();
    }

    @Deprecated
    public Decoder getDecoder() {
        return this.decoder();
    }

    private static final class LevelNode
    extends TreeDecoder.LeafNode {
        private static final long serialVersionUID = 1L;
        int level;

        private LevelNode(int symbol) {
            super(symbol);
        }

        private LevelNode() {
            super(-1);
        }
    }
}

