/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.util;

import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.longs.AbstractLongBigList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class ByteBufferLongBigList
extends AbstractLongBigList {
    private static int CHUNK_SHIFT = 27;
    public static final long CHUNK_SIZE = 1L << CHUNK_SHIFT;
    private static final long CHUNK_MASK = CHUNK_SIZE - 1L;
    private final ByteBuffer[] byteBuffer;
    private final boolean[] readyToUse;
    private final int n;
    private final long size;

    public ByteBufferLongBigList(ByteBuffer byteBuffer) {
        this(new ByteBuffer[]{byteBuffer}, byteBuffer.capacity(), new boolean[1]);
    }

    protected ByteBufferLongBigList(ByteBuffer[] byteBuffer, long size, boolean[] readyToUse) {
        this.byteBuffer = byteBuffer;
        this.n = byteBuffer.length;
        this.size = size;
        this.readyToUse = readyToUse;
        for (int i = 0; i < this.n; ++i) {
            if (i >= this.n - 1 || (long)(byteBuffer[i].capacity() / 8) == CHUNK_SIZE) continue;
            throw new IllegalArgumentException();
        }
    }

    public static ByteBufferLongBigList map(FileChannel fileChannel) throws IOException {
        return ByteBufferLongBigList.map(fileChannel, ByteOrder.BIG_ENDIAN);
    }

    public static ByteBufferLongBigList map(FileChannel fileChannel, ByteOrder byteOrder) throws IOException {
        return ByteBufferLongBigList.map(fileChannel, byteOrder, FileChannel.MapMode.READ_ONLY);
    }

    public static ByteBufferLongBigList map(FileChannel fileChannel, ByteOrder byteOrder, FileChannel.MapMode mapMode) throws IOException {
        long size = fileChannel.size() / 8L;
        int chunks = (int)((size + (CHUNK_SIZE - 1L)) / CHUNK_SIZE);
        ByteBuffer[] byteBuffer = new ByteBuffer[chunks];
        for (int i = 0; i < chunks; ++i) {
            byteBuffer[i] = fileChannel.map(mapMode, (long)i * CHUNK_SIZE * 8L, Math.min(CHUNK_SIZE, size - (long)i * CHUNK_SIZE) * 8L).order(byteOrder);
        }
        boolean[] readyToUse = new boolean[chunks];
        BooleanArrays.fill((boolean[])readyToUse, (boolean)true);
        return new ByteBufferLongBigList(byteBuffer, size, readyToUse);
    }

    private ByteBuffer byteBuffer(int n) {
        if (this.readyToUse[n]) {
            return this.byteBuffer[n];
        }
        this.readyToUse[n] = true;
        this.byteBuffer[n] = this.byteBuffer[n].duplicate().order(this.byteBuffer[n].order());
        return this.byteBuffer[n];
    }

    public ByteBufferLongBigList copy() {
        return new ByteBufferLongBigList((ByteBuffer[])this.byteBuffer.clone(), this.size, new boolean[this.n]);
    }

    public long getLong(long index) {
        return this.byteBuffer((int)(index >>> CHUNK_SHIFT)).getLong((int)(index & CHUNK_MASK) << 3);
    }

    public long size64() {
        return this.size;
    }
}

