/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.coordination.testing;

import it.unibo.coordination.testing.ActiveObject;
import it.unibo.coordination.testing.ConcurrentTestHelper;
import it.unibo.coordination.testing.IConcurrentTestHelper;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.function.Predicate;

public abstract class TestAgent
extends ActiveObject<TestAgent>
implements IConcurrentTestHelper {
    private final IConcurrentTestHelper test;

    public TestAgent(String name, ConcurrentTestHelper test) {
        super(name);
        this.test = test;
    }

    public TestAgent(ConcurrentTestHelper test) {
        this.test = test;
    }

    @Override
    protected void onEnd() {
        this.test.done();
    }

    @Override
    protected void onUncaughtException(Exception e) {
    }

    protected abstract void main() throws Exception;

    @Override
    protected void loop() throws Exception {
        this.main();
        this.stop();
    }

    @Override
    public void await() throws Exception {
        this.test.await();
    }

    @Override
    public void done() {
        this.test.done();
    }

    @Override
    public void fail(Exception t) {
        this.test.fail(t);
    }

    @Override
    public void fail(String message, Exception t) {
        this.test.fail(message, t);
    }

    @Override
    public void fail(String message) {
        this.test.fail(message);
    }

    @Override
    public void fail() {
        this.test.fail();
    }

    @Override
    public void success() {
        this.test.success();
    }

    @Override
    public void assertTrue(boolean condition) {
        this.test.assertTrue(condition);
    }

    @Override
    public void assertTrue(boolean condition, String message) {
        this.test.assertTrue(condition, message);
    }

    @Override
    public <T> void assertEquals(T actual, T expected, String message) {
        this.test.assertEquals(actual, expected, message);
    }

    @Override
    public <T> void assertEquals(T actual, T expected) {
        this.test.assertEquals(actual, expected);
    }

    @Override
    public <T> void assertEquals(Future<T> actualFuture, T expected) {
        this.test.assertEquals(actualFuture, expected);
    }

    @Override
    public <T> void assertTrue(Future<T> actualFuture, Predicate<T> p) {
        this.test.assertTrue(actualFuture, p);
    }

    @Override
    public <T> void assertEquals(Future<T> actualFuture, T expected, String message) {
        this.test.assertEquals(actualFuture, expected, message);
    }

    @Override
    public <T> void assertOneOf(Future<T> actualFuture, T expected1, T ... expected) {
        this.test.assertOneOf(actualFuture, expected1, expected);
    }

    @Override
    public <T> void assertOneOf(Future<T> actualFuture, Collection<? extends T> expected) {
        this.test.assertOneOf(actualFuture, expected);
    }

    @Override
    public <T> void assertOneOf(Future<T> actualFuture, Collection<? extends T> expected, String message) {
        this.test.assertOneOf(actualFuture, expected, message);
    }

    @Override
    public void assertBlocksIndefinitely(Future<?> future, String message) {
        this.test.assertBlocksIndefinitely(future, message);
    }

    @Override
    public void assertBlocksIndefinitely(Future<?> future) {
        this.test.assertBlocksIndefinitely(future);
    }

    @Override
    public void assertEventuallyReturns(Future<?> future, String message) {
        this.test.assertEventuallyReturns(future, message);
    }

    @Override
    public void assertEventuallyReturns(Future<?> future) {
        this.test.assertEventuallyReturns(future);
    }
}

