/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.coordination.testing;

import it.unibo.coordination.testing.IConcurrentTestHelper;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;

public class ConcurrentTestHelper
implements IConcurrentTestHelper {
    private static final Duration BLOCKING_THRESHOLD = Duration.ofSeconds(3L);
    private static final Duration GET_THRESHOLD = Duration.ofSeconds(2L);
    private final List<IConcurrentTestHelper.ThrowableRunnable> toDoList = Collections.synchronizedList(new ArrayList());
    private CountDownLatch latch;

    public void setThreadCount(int n) {
        this.latch = new CountDownLatch(n);
    }

    @Override
    public void await() throws Exception {
        this.latch.await(BLOCKING_THRESHOLD.toMillis(), TimeUnit.MILLISECONDS);
        for (IConcurrentTestHelper.ThrowableRunnable throwableRunnable : this.toDoList) {
            throwableRunnable.run();
        }
    }

    @Override
    public void done() {
        this.latch.countDown();
    }

    @Override
    public void fail(Exception t) {
        this.propagateExceptions(() -> {
            throw new AssertionError((Object)t);
        });
    }

    @Override
    public void fail(String message, Exception t) {
        this.propagateExceptions(() -> {
            throw new AssertionError(message, t);
        });
    }

    @Override
    public void fail(String message) {
        this.propagateExceptions(() -> Assert.fail((String)message));
    }

    @Override
    public void fail() {
        this.propagateExceptions(() -> Assert.fail());
    }

    @Override
    public void success() {
        this.propagateExceptions(() -> Assert.assertTrue((boolean)true));
    }

    @Override
    public void assertTrue(boolean condition) {
        this.propagateExceptions(() -> Assert.assertTrue((boolean)condition));
    }

    @Override
    public void assertTrue(boolean condition, String message) {
        this.propagateExceptions(() -> Assert.assertTrue((String)message, (boolean)condition));
    }

    private void propagateExceptions(IConcurrentTestHelper.ThrowableRunnable action) {
        try {
            action.run();
        }
        catch (Throwable e) {
            this.toDoList.add(() -> {
                throw e;
            });
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> void assertEquals(T actual, T expected, String message) {
        this.assertTrue(expected.equals(actual), message);
    }

    @Override
    public <T> void assertEquals(T actual, T expected) {
        this.assertTrue(expected.equals(actual), String.format("Failed assertion: %s must be equals to %s", actual, expected));
    }

    @Override
    public <T> void assertEquals(Future<T> actualFuture, T expected) {
        try {
            T actual = actualFuture.get(GET_THRESHOLD.toMillis(), TimeUnit.MILLISECONDS);
            this.assertEquals(actual, expected, String.format("Expected %s, found %s", expected, actual));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.fail(e);
        }
    }

    @Override
    public <T> void assertTrue(Future<T> actualFuture, Predicate<T> p) {
        try {
            T actual = actualFuture.get(GET_THRESHOLD.toMillis(), TimeUnit.MILLISECONDS);
            this.assertTrue(p.test(actual), "Expected true, got false instead");
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.fail(e);
        }
    }

    @Override
    public <T> void assertEquals(Future<T> actualFuture, T expected, String message) {
        try {
            T actual = actualFuture.get(GET_THRESHOLD.toMillis(), TimeUnit.MILLISECONDS);
            this.assertEquals(actual, expected, message);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.fail(message, e);
        }
    }

    @Override
    public <T> void assertOneOf(Future<T> actualFuture, T expected1, T ... expected) {
        this.assertOneOf(actualFuture, Stream.concat(Stream.of(expected1), Stream.of(expected)).collect(Collectors.toSet()));
    }

    @Override
    public <T> void assertOneOf(Future<T> actualFuture, Collection<? extends T> expected) {
        this.assertOneOf(actualFuture, expected, null);
    }

    @Override
    public <T> void assertOneOf(Future<T> actualFuture, Collection<? extends T> expected, String message) {
        try {
            T actual = actualFuture.get(GET_THRESHOLD.toMillis(), TimeUnit.MILLISECONDS);
            if (message == null) {
                this.assertTrue(expected.contains(actual), String.format("Expecting %s is one of %s, but it is not", actual, expected));
            } else {
                this.assertTrue(expected.contains(actual), message);
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.fail(e);
        }
    }

    @Override
    public void assertBlocksIndefinitely(Future<?> future, String message) {
        try {
            future.get(BLOCKING_THRESHOLD.toMillis(), TimeUnit.MILLISECONDS);
            this.fail(message == null ? "Async. operation terminated while it was expected to block indefinitely" : message);
        }
        catch (InterruptedException | ExecutionException e) {
            this.fail(e);
        }
        catch (TimeoutException e) {
            this.success();
        }
    }

    @Override
    public void assertBlocksIndefinitely(Future<?> future) {
        this.assertBlocksIndefinitely(future, null);
    }

    @Override
    public void assertEventuallyReturns(Future<?> future, String message) {
        try {
            future.get(BLOCKING_THRESHOLD.toMillis(), TimeUnit.MILLISECONDS);
            this.success();
        }
        catch (InterruptedException | ExecutionException e) {
            this.fail(e);
        }
        catch (TimeoutException e) {
            this.fail(message == null ? "Async. operation should have returned a value in time, but it did not" : message);
        }
    }

    @Override
    public void assertEventuallyReturns(Future<?> future) {
        this.assertEventuallyReturns(future, null);
    }
}

