/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.coordination.testing;

import java.time.Duration;

public abstract class ActiveObject<A extends ActiveObject<A>> {
    private final String name;
    private final Thread thread;
    private volatile boolean running = true;

    public ActiveObject(String name) {
        this.name = name + "#" + System.identityHashCode(this);
        this.thread = new Thread(this::run, this.name + "-Thread");
    }

    public ActiveObject() {
        this(ActiveObject.class.getSimpleName());
    }

    private void run() {
        try {
            this.onBegin();
            while (this.running) {
                this.loop();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            this.onUncaughtException(e);
        }
        finally {
            this.onEnd();
        }
    }

    protected abstract void loop() throws Exception;

    protected void onBegin() throws Exception {
    }

    protected void onEnd() {
    }

    protected void onUncaughtException(Exception e) {
        e.printStackTrace();
    }

    public A start() {
        this.thread.start();
        return (A)this;
    }

    public A stop() {
        this.running = false;
        this.thread.interrupt();
        return (A)this;
    }

    public A awaitTermination() {
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return (A)this;
    }

    protected void log(String format, Object ... args) {
        System.out.printf("[" + this.getName() + "] " + format + "\n", args);
    }

    protected void sleepFor(Duration time) throws InterruptedException {
        Thread.sleep(time.toMillis());
    }

    public String getName() {
        return this.name;
    }
}

