/*
 * Decompiled with CFR 0.152.
 */
package it.smartdust.entitydtomapper;

import it.smartdust.entitydtomapper.ApplicationContextProvider;
import it.smartdust.entitydtomapper.EntityDtoMapper;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.modelmapper.ModelMapper;
import org.modelmapper.convention.MatchingStrategies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.repository.JpaRepository;

public class EntityDtoMapperImpl<T, S>
implements EntityDtoMapper<T, S> {
    private static final Logger log = LoggerFactory.getLogger(EntityDtoMapperImpl.class);
    private final ModelMapper mapper = new ModelMapper();

    public EntityDtoMapperImpl() {
        this.mapper.getConfiguration().setCollectionsMergeEnabled(false);
        this.mapper.getConfiguration().setMatchingStrategy(MatchingStrategies.STRICT);
    }

    @Override
    public T toEntity(S sourceDto, Class<T> targetEntityClass) {
        Object entity = null;
        try {
            Method method = sourceDto.getClass().getMethod("getId", new Class[0]);
            Long dtoId = (Long)method.invoke(sourceDto, new Object[0]);
            StringBuilder sb = new StringBuilder();
            if (dtoId != null) {
                Object mainEntityRepositoryName = targetEntityClass.getSimpleName();
                mainEntityRepositoryName = ((String)mainEntityRepositoryName).substring(0, 1).toLowerCase() + ((String)mainEntityRepositoryName).substring(1);
                mainEntityRepositoryName = sb.append((String)mainEntityRepositoryName).append("Repository").toString();
                JpaRepository mainEntityRepo = (JpaRepository)ApplicationContextProvider.getApplicationContext().getBean((String)mainEntityRepositoryName);
                entity = mainEntityRepo.findById((Object)dtoId).orElseThrow(() -> new EntityNotFoundException("Ue not found with id: " + dtoId));
            } else {
                entity = targetEntityClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            this.mapper.map(sourceDto, entity);
            List<Method> persistentAggregateSetters = this.findPersistentAggregateProperties(targetEntityClass, false);
            for (Method curMethod : persistentAggregateSetters) {
                sb.setLength(0);
                String dtoAccessorName = sb.append(curMethod.getName().replaceFirst("^set", "get")).append("Id").toString();
                try {
                    Method dtoMethodGetter = sourceDto.getClass().getMethod(dtoAccessorName, new Class[0]);
                    Object aggregateId = dtoMethodGetter.invoke(sourceDto, new Object[0]);
                    if (aggregateId != null) {
                        Method entityMethodGetter = entity.getClass().getMethod(curMethod.getName().replaceFirst("^set", "get"), new Class[0]);
                        Object entityAggregateValue = entityMethodGetter.invoke(entity, new Object[0]);
                        Object entityAggregateId = null;
                        if (entityAggregateValue != null) {
                            Method entityAggregateIdGetter = entityAggregateValue.getClass().getMethod("getId", new Class[0]);
                            entityAggregateId = entityAggregateIdGetter.invoke(entityAggregateValue, new Object[0]);
                        }
                        if (aggregateId.equals(entityAggregateId)) continue;
                        sb.setLength(0);
                        Object aggregateClassSimpleName = curMethod.getParameterTypes()[0].getSimpleName();
                        aggregateClassSimpleName = ((String)aggregateClassSimpleName).substring(0, 1).toLowerCase() + ((String)aggregateClassSimpleName).substring(1);
                        String aggregateEntityRepositoryName = sb.append((String)aggregateClassSimpleName).append("Repository").toString();
                        JpaRepository aggregateEntityRepo = (JpaRepository)ApplicationContextProvider.getApplicationContext().getBean(aggregateEntityRepositoryName);
                        Object aggregateEntity = aggregateEntityRepo.findById(aggregateId).orElseThrow(() -> new EntityNotFoundException(curMethod.getParameterTypes()[0] + " not found with id: " + dtoId));
                        curMethod.invoke(entity, aggregateEntity);
                        continue;
                    }
                    curMethod.invoke(entity, new Object[]{null});
                }
                catch (NoSuchMethodException ex) {
                    log.debug("No {} method found in Dto, skipping mapping of {}", (Object)dtoAccessorName, (Object)curMethod.getName());
                }
            }
            return (T)entity;
        }
        catch (Throwable e) {
            log.error("Unable to map dto to entity - Dto: {}", sourceDto, (Object)e);
            throw new IllegalArgumentException("Unable to map dto to entity", e);
        }
    }

    @Override
    public S toDto(T sourceEntity, S targetDto) {
        try {
            this.mapper.map(sourceEntity, targetDto);
            List<Method> persistentAggregateGetters = this.findPersistentAggregateProperties(sourceEntity.getClass(), true);
            persistentAggregateGetters.forEach(el -> log.debug(el.getName()));
            StringBuilder sb = new StringBuilder();
            for (Method curMethod : persistentAggregateGetters) {
                Object aggregateObject = curMethod.invoke(sourceEntity, new Object[0]);
                String objectAccessorName = curMethod.getName().replaceFirst("^get", "");
                sb.setLength(0);
                String aggregatSetterMethodName = sb.append("set").append(objectAccessorName).append("Id").toString();
                try {
                    Method dtoMethodSetter = targetDto.getClass().getMethod(aggregatSetterMethodName, Long.class);
                    if (aggregateObject != null) {
                        Method method = aggregateObject.getClass().getMethod("getId", new Class[0]);
                        Object aggregateId = method.invoke(aggregateObject, new Object[0]);
                        if (aggregateId != null && aggregateId instanceof Long) {
                            dtoMethodSetter.invoke(targetDto, aggregateId);
                            continue;
                        }
                        log.error("Unable to extract id from entity aggregate - Entity: {} - Aggregate: {}", sourceEntity, aggregateObject);
                        throw new IllegalArgumentException("Unable to map entity to dto");
                    }
                    dtoMethodSetter.invoke(targetDto, new Object[]{null});
                }
                catch (NoSuchMethodException ex) {
                    log.debug("No {} method found in Dto, skipping mapping of {}", (Object)aggregatSetterMethodName, (Object)objectAccessorName);
                }
            }
            return targetDto;
        }
        catch (Exception e) {
            log.error("Unable to map entity to dto - Entity: {}", sourceEntity, (Object)e);
            throw new IllegalArgumentException("Unable to map entity to dto", e);
        }
    }

    @Override
    public S toDto(T sourceEntity, Class<S> targetDtoClass) {
        try {
            S dto = targetDtoClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return this.toDto(sourceEntity, dto);
        }
        catch (Exception e) {
            log.error("Unable to map entity to dto - Entity: {}", sourceEntity, (Object)e);
            throw new IllegalArgumentException("Unable to map entity to dto", e);
        }
    }

    private List<Method> findPersistentAggregateProperties(Class<? extends Object> class1, boolean readMethod) {
        ArrayList<Method> result = new ArrayList<Method>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = Introspector.getBeanInfo(class1).getPropertyDescriptors()) {
                String propertyName = propertyDescriptor.getName();
                log.debug("Processing property: {}", (Object)propertyName);
                if ("class".equals(propertyName)) continue;
                try {
                    Annotation[] annotations;
                    Field field = class1.getDeclaredField(propertyName);
                    if (field == null) continue;
                    for (Annotation annotation : annotations = field.getDeclaredAnnotations()) {
                        if (!(annotation instanceof ManyToOne) && !(annotation instanceof OneToOne)) continue;
                        log.debug("Found manyToOne or oneToOne field: {}", (Object)field.getName());
                        result.add(readMethod ? propertyDescriptor.getReadMethod() : propertyDescriptor.getWriteMethod());
                    }
                }
                catch (NoSuchFieldException ex) {
                    log.debug("Field not found for property: {} - Skipping", (Object)propertyName);
                }
            }
            return result;
        }
        catch (IntrospectionException | SecurityException e) {
            log.error("Error:", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

