package it.smartdust.entitydtomapper;

import org.springframework.beans.factory.FactoryBean;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class MapperFactoryBean<T, S> implements FactoryBean<EntityDtoMapper<T, S>> {

	public MapperFactoryBean() {
	}

	@Override
	public EntityDtoMapper<T, S> getObject() throws Exception {
		return new EntityDtoMapperImpl<T, S>();
	}

	@Override
	public Class<?> getObjectType() {
		return EntityDtoMapper.class;
	}

	@Override
	public boolean isSingleton() {
		return false; // or false, depending on the implementation
	}
}