/*
 * Decompiled with CFR 0.152.
 */
package it.micegroup.voila2runtime.mail.senders;

import it.micegroup.voila2runtime.mail.entity.MailConfig;
import it.micegroup.voila2runtime.mail.entity.MailTemplate;
import it.micegroup.voila2runtime.mail.utils.MailUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.app.VelocityEngine;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public class MimeMailSenderImpl
extends JavaMailSenderImpl {
    private static Log logger = LogFactory.getLog(MimeMailSenderImpl.class);
    private MailConfig mailConfig;
    private VelocityEngine velocityEngine;
    private boolean testMode = false;
    private boolean useSPA = false;

    public MailConfig getMailConfig() {
        return this.mailConfig;
    }

    public void setMailConfig(MailConfig mailConfig) {
        this.mailConfig = mailConfig;
    }

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public void setVelocityEngine(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    public boolean isUseSPA() {
        return this.useSPA;
    }

    public void setUseSPA(boolean useSPA) {
        this.useSPA = useSPA;
    }

    public void sendEmails(MailTemplate template, Map objectMap, Map allegati) {
        block7: {
            if (!this.getMailConfig().isEnabled()) {
                logger.warn((Object)"Sistema di mailing disabilitato. Prego configurare la sezione Configurazione->Posta elettronica->Mail Config");
                return;
            }
            MimeMessageHelper messageHelper = MailUtils.createNewMimeMessageHelper(template, this, objectMap, allegati);
            try {
                if (this.testMode) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    messageHelper.getMimeMessage().writeTo((OutputStream)baos);
                    logger.info((Object)("Test mail message:\n " + baos.toString()));
                    break block7;
                }
                if (messageHelper.getMimeMessage().getAllRecipients() != null && messageHelper.getMimeMessage().getAllRecipients().length > 0) {
                    this.send(messageHelper.getMimeMessage());
                    break block7;
                }
                throw new RuntimeException("Nessun destinatario specificato per l'invio della mail. Invio non effettuato.");
            }
            catch (Exception e) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    messageHelper.getMimeMessage().writeTo((OutputStream)baos);
                    logger.warn((Object)("Unable to send email, reason: " + e.getMessage()));
                    logger.warn((Object)"Mail RFC output:");
                    logger.warn((Object)baos.toString());
                }
                catch (Exception e1) {
                    throw new RuntimeException(e);
                }
                throw new RuntimeException(e);
            }
        }
    }
}

