/*
 * Decompiled with CFR 0.152.
 */
package it.micegroup.voila2runtime.mail.utils;

import it.micegroup.voila2runtime.mail.entity.MailSelector;
import it.micegroup.voila2runtime.mail.entity.MailTemplate;
import it.micegroup.voila2runtime.mail.manager.MailManagerImpl;
import it.micegroup.voila2runtime.mail.senders.MimeMailSenderImpl;
import it.micegroup.voila2runtime.utils.VelocityContextUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.mail.internet.MimeMessage;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class MailUtils {
    private static Log logger = LogFactory.getLog(MailUtils.class);
    private static String EMAIL_ADDRESS_SEPARATOR = ",";
    public static final Map<String, Object> EMPTY_MAP = new HashMap<String, Object>();

    public static Object getStaticMethodValue(String fqName, String methodName) {
        try {
            Class<?> utils = Class.forName(fqName);
            Method getMethod = utils.getMethod(methodName, new Class[0]);
            Object output = getMethod.invoke(null, new Object[0]);
            return output;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getCurrentUserDetail() {
        return new UserDetails(){

            public boolean isEnabled() {
                return false;
            }

            public boolean isCredentialsNonExpired() {
                return false;
            }

            public boolean isAccountNonLocked() {
                return false;
            }

            public boolean isAccountNonExpired() {
                return false;
            }

            public String getUsername() {
                return "";
            }

            public String getPassword() {
                return "";
            }

            public Collection<? extends GrantedAuthority> getAuthorities() {
                return null;
            }
        };
    }

    public static MimeMessageHelper createNewMimeMessageHelper(MailTemplate mailTemplate, MimeMailSenderImpl mailSender, Map objectMap, Map allegati) {
        MimeMessage mimeMessage = mailSender.createMimeMessage();
        MimeMessageHelper messageHelper = null;
        try {
            String[] bcc;
            String[] cc;
            messageHelper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
            if (!StringUtils.isBlank((String)mailTemplate.getMailFrom())) {
                messageHelper.setFrom(MailUtils.convertTemplate(mailTemplate.getMailFrom(), objectMap, mailSender.getVelocityEngine()));
            } else {
                messageHelper.setFrom(mailSender.getMailConfig().getMailFromAddress());
            }
            String[] to = MailUtils.extractEmails(mailTemplate.getMailTo(), mailTemplate.getMailToSelectors(), objectMap, mailSender.getVelocityEngine());
            if (to.length > 0) {
                messageHelper.setTo(to);
            }
            if ((cc = MailUtils.extractEmails(mailTemplate.getMailCc(), mailTemplate.getMailCcSelectors(), objectMap, mailSender.getVelocityEngine())).length > 0) {
                messageHelper.setCc(cc);
            }
            if ((bcc = MailUtils.extractEmails(mailTemplate.getMailBcc(), mailTemplate.getMailBccSelectors(), objectMap, mailSender.getVelocityEngine())).length > 0) {
                messageHelper.setBcc(bcc);
            }
            if (!StringUtils.isBlank((String)mailTemplate.getMailReplyTo())) {
                messageHelper.setReplyTo(MailUtils.convertTemplate(mailTemplate.getMailReplyTo(), objectMap, mailSender.getVelocityEngine()));
            }
            String subject = "";
            if (mailTemplate.getMailSubject() != null) {
                subject = MailUtils.convertTemplate(mailTemplate.getMailSubject(), objectMap, mailSender.getVelocityEngine());
            }
            messageHelper.setSubject(subject);
            objectMap.put("mailSubject", subject);
            objectMap.put("skipTitle", mailTemplate.isSkipTitle());
            String htmlText = null;
            String plainText = null;
            if (!StringUtils.isBlank((String)mailTemplate.getMailBodyHtml())) {
                StringBuffer html = new StringBuffer();
                if (mailTemplate.getTheMailStyle() != null) {
                    html.append(mailTemplate.getTheMailStyle().getMailStyleHeader()).append(mailTemplate.getMailBodyHtml()).append(mailTemplate.getTheMailStyle().getMailStyleFooter());
                } else {
                    html.append(mailTemplate.getMailBodyHtml());
                }
                htmlText = MailUtils.convertTemplate(html.toString(), objectMap, mailSender.getVelocityEngine());
            }
            if (!StringUtils.isBlank((String)mailTemplate.getMailBodyText())) {
                plainText = MailUtils.convertTemplate(mailTemplate.getMailBodyText(), objectMap, mailSender.getVelocityEngine());
            }
            if (htmlText != null && plainText != null) {
                messageHelper.setText(plainText, htmlText);
            }
            if (htmlText != null && plainText == null) {
                messageHelper.setText(htmlText, true);
            }
            if (htmlText == null && plainText != null) {
                messageHelper.setText(plainText, false);
            }
            HashMap attachments = new HashMap();
            if (allegati != null) {
                attachments.putAll(allegati);
            }
            MailUtils.resolveTemplateAttachments(mailTemplate, objectMap, attachments);
            if (attachments != null) {
                for (String filename : attachments.keySet()) {
                    if (attachments.get(filename) instanceof ByteArrayOutputStream) {
                        ByteArrayOutputStream baos = (ByteArrayOutputStream)attachments.get(filename);
                        messageHelper.addAttachment(filename, (InputStreamSource)new ByteArrayResource(baos.toByteArray()));
                        continue;
                    }
                    if (attachments.get(filename) instanceof InputStream) {
                        InputStream is = (InputStream)attachments.get(filename);
                        messageHelper.addAttachment(filename, (InputStreamSource)new ByteArrayResource(IOUtils.toByteArray((InputStream)is)));
                        continue;
                    }
                    throw new RuntimeException("At the moment only ByteArrayOutputStream or any InputStream are allowed as attachments");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return messageHelper;
    }

    public static String[] extractEmails(String mail, Collection<MailSelector> userSelector, Object dataObject, VelocityEngine velocityEngine) {
        HashSet<String> emails = new HashSet<String>();
        if (!StringUtils.isBlank((String)mail)) {
            String mailConverted = MailUtils.convertTemplate(mail, dataObject, velocityEngine);
            for (String singleEmail : mailConverted.split(EMAIL_ADDRESS_SEPARATOR)) {
                if (singleEmail == null || StringUtils.isEmpty((String)singleEmail.trim())) continue;
                emails.add(singleEmail);
            }
        }
        if (dataObject != null && velocityEngine != null) {
            for (MailSelector mailSelector : userSelector) {
                Set mails = mailSelector.getSelectedEmails(dataObject, velocityEngine);
                emails.addAll(mails);
            }
        }
        String[] emailsArray = emails.toArray(new String[emails.size()]);
        return emailsArray;
    }

    public static String convertTemplate(String input, Object dataObject, VelocityEngine velocityEngine) {
        if (dataObject == null || velocityEngine == null) {
            return input;
        }
        String messageText = null;
        try {
            String logString;
            StringWriter sw;
            Reader messageReader = null;
            if (input != null) {
                messageText = StringUtils.replace((String)input, (String)"@{", (String)"${");
                messageText = StringUtils.replace((String)messageText, (String)"@!{", (String)"$!{");
            }
            VelocityContext context = new VelocityContext(VelocityContextUtils.getVelocityContextToolsMap());
            try {
                context.put("currentUser", MailUtils.getCurrentUserDetail());
            }
            catch (Exception exception) {
                // empty catch block
            }
            context.put("dataObject", dataObject);
            MailUtils.prepareBaseUrl(context);
            if (dataObject instanceof Map) {
                for (Map.Entry entry : ((Map)dataObject).entrySet()) {
                    context.put((String)entry.getKey(), entry.getValue());
                }
            }
            if (MailUtils.parseVelocityTemplate((Context)context, sw = new StringWriter(), logString = "", messageText, messageReader, velocityEngine)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Template text:\n" + messageText + "\nWas converted to:" + sw.toString()));
                }
                return sw.toString();
            }
            String errMsg = "Failed to parse Velocity content for mail template text:" + input + ". Check content into applicationContext-Mail.xml file..Error description:" + logString;
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Failed to process mail template. Error template dump is:\n" + messageText + "\n"));
            }
            throw new RuntimeException(errMsg);
        }
        catch (Exception e) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Failed to process mail template. Error template dump is:\n" + messageText + "\n"));
            }
            throw new RuntimeException(e);
        }
    }

    private static void resolveTemplateAttachments(MailTemplate template, Map objectMap, Map attachments) {
        if (StringUtils.isBlank((String)template.getAttachments())) {
            return;
        }
        attachments.putAll(MailUtils.resolvePropertyScript(template.getAttachments(), objectMap));
    }

    public static Map resolvePropertyScript(String script, Map objectMap) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!StringUtils.isBlank((String)script)) {
            String[] lines = script.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                String[] lineParts = lines[i].split("=");
                String fileName = lineParts[0].trim();
                String propName = lineParts[1].trim();
                try {
                    Object allegato = PropertyUtils.getNestedProperty((Object)objectMap, (String)propName);
                    result.put(fileName, allegato);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return result;
    }

    public static MimeMailSenderImpl fetchMailSender(MailManagerImpl mailSenderManager, String mailConfigId) {
        MimeMailSenderImpl mailSender = null;
        if (mailConfigId != null) {
            mailSender = mailSenderManager.getMailServers().get(mailConfigId);
        }
        if (mailSender == null) {
            mailSender = mailSenderManager.getMailServers().values().iterator().next();
        }
        if (mailSender == null) {
            throw new IllegalArgumentException("At least one mailConfig must be provided in order to use mail server.");
        }
        return mailSender;
    }

    private static void prepareBaseUrl(VelocityContext context) {
        String baseUrl = MailUtils.getBaseUrl();
        if (baseUrl != null) {
            context.put("baseUrl", (Object)baseUrl);
        }
    }

    protected static String getBaseUrl() {
        String baseUrl = null;
        try {
            Class<?> utils = Class.forName("it.micegroup.voila.runtime.springmvc.util.SpringMvcUtil");
            Method getBaseUrlMethod = utils.getMethod("getBaseUrl", new Class[0]);
            baseUrl = (String)getBaseUrlMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            baseUrl = System.getProperty("base.url");
        }
        return baseUrl;
    }

    private static boolean parseVelocityTemplate(Context context, Writer out, String logTag, String stringTemplate, Reader streamTemplate, VelocityEngine velocityEngine) throws ParseErrorException, MethodInvocationException, ResourceNotFoundException, IOException {
        if (stringTemplate != null) {
            return velocityEngine.evaluate(context, out, logTag, stringTemplate);
        }
        return velocityEngine.evaluate(context, out, logTag, streamTemplate);
    }
}

