/*
 * Decompiled with CFR 0.152.
 */
package it.micegroup.voila2runtime.mail.manager;

import it.micegroup.voila2runtime.mail.entity.MailConfig;
import it.micegroup.voila2runtime.mail.entity.MailEvent;
import it.micegroup.voila2runtime.mail.entity.MailTemplate;
import it.micegroup.voila2runtime.mail.manager.MailManager;
import it.micegroup.voila2runtime.mail.senders.MailAuthenticator;
import it.micegroup.voila2runtime.mail.senders.MimeMailSenderImpl;
import it.micegroup.voila2runtime.mail.utils.MailUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.app.VelocityEngine;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.mail.javamail.JavaMailSenderImpl;

public abstract class MailManagerImpl
extends JavaMailSenderImpl
implements MailManager {
    private static Log logger = LogFactory.getLog(MailManagerImpl.class);
    private Map<String, MailConfig> mailConfigs = new HashMap<String, MailConfig>();
    private Map<String, MailTemplate> mailTemplates = new HashMap<String, MailTemplate>();
    private Map<String, MailEvent> mailEvents = new HashMap<String, MailEvent>();
    private Map<String, MimeMailSenderImpl> mailServers = new HashMap<String, MimeMailSenderImpl>();
    private VelocityEngine velocityEngine;
    private boolean testMode = false;
    private String baseUrl = null;
    private ApplicationContext applicationContext;

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public void setVelocityEngine(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Map<String, MimeMailSenderImpl> getMailServers() {
        return this.mailServers;
    }

    public void setMailServers(Map<String, MimeMailSenderImpl> mailServers) {
        this.mailServers = mailServers;
    }

    public Map<String, MailConfig> getMailConfigs() {
        return this.mailConfigs;
    }

    public void setMailConfigs(Map<String, MailConfig> mailConfigs) {
        this.mailConfigs = mailConfigs;
    }

    public Map<String, MailTemplate> getMailTemplates() {
        return this.mailTemplates;
    }

    public void setMailTemplates(Map<String, MailTemplate> mailTemplates) {
        this.mailTemplates = mailTemplates;
    }

    public Map<String, MailEvent> getMailEvents() {
        return this.mailEvents;
    }

    public void setMailEvents(Map<String, MailEvent> mailEvents) {
        this.mailEvents = mailEvents;
    }

    public void sendEmailByTemplate(String templateId) {
        this.sendEmailByTemplate(templateId, MailUtils.EMPTY_MAP, null);
    }

    public void sendEmailByTemplate(String templateId, Map objectMap) {
        this.sendEmailByTemplate(templateId, objectMap, null);
    }

    public void sendEmailByTemplate(String templateId, Map objectMap, Map allegati) {
        MailTemplate mailTemplate = this.getMailTemplates().get(templateId);
        if (mailTemplate == null) {
            throw new IllegalArgumentException("Template " + templateId + " does not exist in the mail configuration.");
        }
        this.sendEmailByTemplate(mailTemplate, objectMap, allegati);
    }

    public void sendEmailByTemplate(MailTemplate template, Map objectMap, Map allegati) {
        objectMap.put("baseUrl", this.getBaseUrl());
        if (template.isEnabled()) {
            this.mailServers.get(template.getTheMailConfig().getMailConfigId()).sendEmails(template, objectMap, allegati);
        } else {
            logger.warn((Object)("Mail template " + template.getMailTemplateId() + " is not enabled. No mail will be sent!"));
        }
    }

    public void sendEmailByEvent(String eventId) {
        this.sendEmailByEvent(eventId, MailUtils.EMPTY_MAP, null);
    }

    public void sendEmailByEvent(String eventId, Map objectMap) {
        this.sendEmailByEvent(eventId, objectMap, null);
    }

    public void sendEmailByEvent(String eventId, Map objectMap, Map allegati) {
        MailEvent mailEvent = this.getMailEvents().get(eventId);
        this.sendEmailByEvent(mailEvent, objectMap, allegati);
    }

    public void sendEmailByEvent(MailEvent event, Map objectMap, Map allegati) {
        if (event.isEnabled()) {
            HashMap copyMap = new HashMap();
            copyMap.putAll(objectMap);
            copyMap.putAll(MailUtils.resolvePropertyScript(event.getScript(), copyMap));
            for (MailTemplate template : event.getTheMailTemplate()) {
                this.sendEmailByTemplate(template, copyMap, allegati);
            }
        } else {
            logger.warn((Object)("Mail event " + event.getMailEventId() + " is not enabled. No mail will be sent!"));
        }
    }

    public void afterPropertiesSet() throws Exception {
        logger.info((Object)"Start loading mail configuration...");
        this.initMailVelocityEngine();
        this.initMailStyle();
        this.initMailConfigs();
        this.initMailTemplates();
        this.initMailEvents();
        this.configMailServers();
        logger.info((Object)"Mail configuration success!");
    }

    private void configMailServers() {
        Iterator<MailConfig> mailConfigs = this.getMailConfigs().values().iterator();
        HashMap<String, MimeMailSenderImpl> mailServersTmp = new HashMap<String, MimeMailSenderImpl>();
        while (mailConfigs.hasNext()) {
            MailConfig mailConfig = mailConfigs.next();
            MimeMailSenderImpl sender = new MimeMailSenderImpl();
            sender.setDefaultEncoding(this.getDefaultEncoding());
            sender.setDefaultFileTypeMap(this.getDefaultFileTypeMap());
            sender.setJavaMailProperties((Properties)this.getJavaMailProperties().clone());
            sender.setTestMode(this.isTestMode());
            sender.setVelocityEngine(this.getVelocityEngine());
            sender.setProtocol(this.getProtocol());
            sender.setHost(this.getHost());
            sender.setPassword(this.getPassword());
            sender.setPort(this.getPort());
            sender.setUsername(this.getUsername());
            sender.setMailConfig(mailConfig);
            if (mailConfig.getMailNomeHost() != null) {
                sender.setHost(mailConfig.getMailNomeHost());
                if (mailConfig.getMailPort() != null) {
                    sender.setPort(mailConfig.getMailPort());
                } else {
                    sender.setPort(25);
                }
            }
            if (mailConfig.getMailUsername() != null && mailConfig.getMailPassword() != null) {
                sender.getJavaMailProperties().put("mail.smtp.auth", "true");
                sender.getJavaMailProperties().put("mail.smtps.auth", "true");
            } else {
                sender.getJavaMailProperties().put("mail.smtp.auth", "false");
                sender.getJavaMailProperties().put("mail.smtps.auth", "false");
            }
            if ("SSL".equals(mailConfig.getMailCrypto())) {
                sender.setProtocol("smtps");
                sender.getJavaMailProperties().put("mail.smtp.starttls.enable", "false");
            } else if ("TLS".equals(mailConfig.getMailCrypto())) {
                sender.setProtocol("smtp");
                sender.getJavaMailProperties().put("mail.smtp.starttls.enable", "true");
            } else if ("TLS/SSL".equals(mailConfig.getMailCrypto())) {
                sender.setProtocol("smtps");
                sender.getJavaMailProperties().put("mail.smtp.starttls.enable", "true");
                sender.getJavaMailProperties().put("mail." + sender.getProtocol() + ".socketFactory.port", (Object)sender.getPort());
                sender.getJavaMailProperties().put("mail." + sender.getProtocol() + ".socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            } else {
                sender.setProtocol("smtp");
                sender.getJavaMailProperties().put("mail.smtp.starttls.enable", "false");
            }
            sender.getJavaMailProperties().put("mail.smtp.connectiontimeout", (Object)20000);
            sender.getJavaMailProperties().put("mail.smtp.timeout", (Object)20000);
            sender.getJavaMailProperties().put("mail.smtps.connectiontimeout", (Object)20000);
            sender.getJavaMailProperties().put("mail.smtps.timeout", (Object)20000);
            if (mailConfig.getMailUsername() != null) {
                sender.setUsername(mailConfig.getMailUsername());
            }
            if (mailConfig.getMailPassword() != null) {
                sender.setPassword(mailConfig.getMailPassword());
            }
            if ("S".equals(mailConfig.getMailSPA())) {
                sender.setUseSPA(true);
                Session session = Session.getInstance((Properties)sender.getJavaMailProperties(), (Authenticator)new MailAuthenticator(sender.getUsername(), sender.getPassword()));
                sender.setSession(session);
            } else {
                sender.setSession(Session.getInstance((Properties)sender.getJavaMailProperties()));
            }
            mailServersTmp.put(mailConfig.getMailConfigId(), sender);
        }
        this.mailServers = mailServersTmp;
    }

    protected abstract void initMailConfigs();

    protected abstract void initMailTemplates();

    protected abstract void initMailEvents();

    protected abstract void initMailVelocityEngine();

    protected abstract void initMailStyle();
}

