/*
 * Decompiled with CFR 0.152.
 */
package it.micegroup.voila2runtime.specification;

import it.micegroup.voila2runtime.specification.SpecificationGetterService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class SpecificationGetterServiceImpl<ENTITY>
implements SpecificationGetterService<ENTITY> {
    public <T> Specification<ENTITY> equivalent(SingularAttribute<? super ENTITY, T> field, T value) {
        return (Specification & Serializable)(root, query, cBuilder) -> cBuilder.equal((Expression)root.get(field), value);
    }

    public <OTHER, T, X> Specification<ENTITY> equivalent(SingularAttribute<? super ENTITY, ? extends OTHER> reference, SingularAttribute<OTHER, T> idField, X value) {
        return (Specification & Serializable)(root, query, cBuilder) -> cBuilder.equal((Expression)root.get(reference).get(idField), value);
    }

    public <OTHER, T> Specification<ENTITY> equivalent(CollectionAttribute<? super ENTITY, OTHER> reference, SingularAttribute<OTHER, T> idField, T value) {
        return (Specification & Serializable)(root, query, cBuilder) -> cBuilder.equal((Expression)root.join(reference).get(idField), value);
    }

    public <OTHER, T, Y> Specification<ENTITY> equivalent(CollectionAttribute<? super ENTITY, OTHER> reference, SingularAttribute<Y, T> idField, SingularAttribute<OTHER, Y> referencedField, T value) {
        return (Specification & Serializable)(root, query, cBuilder) -> cBuilder.equal((Expression)root.join(reference).join(referencedField).get(idField), value);
    }

    public <T> Specification<ENTITY> valueIn(SingularAttribute<? super ENTITY, T> field, Collection<T> values) {
        return (Specification & Serializable)(root, query, cBuilder) -> {
            CriteriaBuilder.In in = cBuilder.in((Expression)root.get(field));
            for (Object value : values) {
                in = in.value(value);
            }
            return in;
        };
    }

    public <OTHER, T> Specification<ENTITY> valueIn(SingularAttribute<? super ENTITY, ? extends OTHER> reference, SingularAttribute<OTHER, T> valueField, Collection<T> values) {
        return (Specification & Serializable)(root, query, builder) -> {
            CriteriaBuilder.In in = builder.in((Expression)root.get(reference).get(valueField));
            for (Object value : values) {
                in = in.value(value);
            }
            return in;
        };
    }

    public <T extends Comparable<? super T>> Specification<ENTITY> greaterThan(SingularAttribute<? super ENTITY, T> field, T value) {
        return (Specification & Serializable)(root, query, cBuilder) -> cBuilder.greaterThan((Expression)root.get(field), value);
    }

    public <T extends Comparable<? super T>> Specification<ENTITY> greaterThanOrEqualTo(SingularAttribute<? super ENTITY, T> field, T value) {
        return (Specification & Serializable)(root, query, cBuilder) -> cBuilder.greaterThanOrEqualTo((Expression)root.get(field), value);
    }

    public <T extends Comparable<? super T>> Specification<ENTITY> lessThan(SingularAttribute<? super ENTITY, T> field, T value) {
        return (Specification & Serializable)(root, query, cBuilder) -> cBuilder.lessThan((Expression)root.get(field), value);
    }

    public <T extends Comparable<? super T>> Specification<ENTITY> lessThanOrEqualTo(SingularAttribute<? super ENTITY, T> field, T value) {
        return (Specification & Serializable)(root, query, cBuilder) -> cBuilder.lessThanOrEqualTo((Expression)root.get(field), value);
    }

    public Specification<ENTITY> likeUpperSpecification(SingularAttribute<? super ENTITY, String> field, String value) {
        return (Specification & Serializable)(root, query, cBuilder) -> cBuilder.like(cBuilder.upper((Expression)root.get(field)), this.wrapLikeQuery(value));
    }

    public <X> Specification<ENTITY> byFieldSpecified(SingularAttribute<? super ENTITY, X> field, boolean specified) {
        return specified ? (Specification & Serializable)(root, query, cBuilder) -> cBuilder.isTrue(root.get(field).as(Boolean.class)) : (Specification & Serializable)(root, query, cBuilder) -> cBuilder.or((Expression)cBuilder.isFalse(root.get(field).as(Boolean.class)), (Expression)cBuilder.isNull((Expression)root.get(field)));
    }

    public <X> Specification<ENTITY> byFieldSpecified(CollectionAttribute<ENTITY, X> field, boolean specified) {
        return specified ? (Specification & Serializable)(root, query, cBuilder) -> cBuilder.isNotEmpty(root.get((PluralAttribute)field)) : (Specification & Serializable)(root, query, cBuilder) -> cBuilder.isEmpty(root.get((PluralAttribute)field));
    }

    public <OTHER, X> Specification<ENTITY> equalsSetSpecification(CollectionAttribute<? super ENTITY, OTHER> reference, SingularAttribute<OTHER, X> idField, X value) {
        return (Specification & Serializable)(root, query, cBuilder) -> cBuilder.equal((Expression)root.join(reference).get(idField), value);
    }

    public <OTHER, T extends Comparable<? super T>> Specification<ENTITY> greaterThan(SingularAttribute<? super ENTITY, ? extends OTHER> reference, SingularAttribute<OTHER, T> field, T value) {
        return (Specification & Serializable)(root, query, cBuilder) -> cBuilder.greaterThan((Expression)root.get(reference).get(field), value);
    }

    public <OTHER, T extends Comparable<? super T>> Specification<ENTITY> greaterOrEqualThan(SingularAttribute<? super ENTITY, ? extends OTHER> reference, SingularAttribute<OTHER, T> field, T value) {
        return (Specification & Serializable)(root, query, cBuilder) -> cBuilder.greaterThanOrEqualTo((Expression)root.get(reference).get(field), value);
    }

    public <OTHER, T extends Comparable<? super T>> Specification<ENTITY> lessThan(SingularAttribute<? super ENTITY, ? extends OTHER> reference, SingularAttribute<OTHER, T> field, T value) {
        return (Specification & Serializable)(root, query, cBuilder) -> cBuilder.lessThan((Expression)root.get(reference).get(field), value);
    }

    public <OTHER, T extends Comparable<? super T>> Specification<ENTITY> lessOrEqualThan(SingularAttribute<? super ENTITY, ? extends OTHER> reference, SingularAttribute<OTHER, T> field, T value) {
        return (Specification & Serializable)(root, query, cBuilder) -> cBuilder.lessThanOrEqualTo((Expression)root.get(reference).get(field), value);
    }

    public <OTHER> Specification<ENTITY> likeUpperSpecification(SingularAttribute<? super ENTITY, ? extends OTHER> reference, SingularAttribute<OTHER, String> field, String value) {
        return (Specification & Serializable)(root, query, cBuilder) -> cBuilder.like(cBuilder.upper((Expression)root.get(reference).get(field)), this.wrapLikeQuery(value));
    }

    private String wrapLikeQuery(String txt) {
        return "%" + txt.toUpperCase() + '%';
    }

    public <T extends Comparable<? super T>> Specification<ENTITY> equivalent(T value, Function<Root<ENTITY>, Path<? extends T>> pathFunction) {
        return (Specification & Serializable)(root, query, cBuilder) -> cBuilder.equal((Expression)pathFunction.apply(root), (Object)value);
    }

    public <T extends Comparable<? super T>> Specification<ENTITY> lessOrEqualThan(T value, Function<Root<ENTITY>, Path<? extends T>> pathFunction) {
        return (Specification & Serializable)(root, query, cBuilder) -> cBuilder.lessThanOrEqualTo((Expression)pathFunction.apply(root), value);
    }

    public <T extends Comparable<? super T>> Specification<ENTITY> greaterOrEqualThan(T value, Function<Root<ENTITY>, Path<? extends T>> pathFunction) {
        return (Specification & Serializable)(root, query, cBuilder) -> cBuilder.greaterThanOrEqualTo((Expression)pathFunction.apply(root), value);
    }

    public <T extends Comparable<? super T>> Specification<ENTITY> lessThan(T value, Function<Root<ENTITY>, Path<? extends T>> pathFunction) {
        return (Specification & Serializable)(root, query, cBuilder) -> cBuilder.lessThan((Expression)pathFunction.apply(root), value);
    }

    public <T extends Comparable<? super T>> Specification<ENTITY> greaterThan(T value, Function<Root<ENTITY>, Path<? extends T>> pathFunction) {
        return (Specification & Serializable)(root, query, cBuilder) -> cBuilder.greaterThan((Expression)pathFunction.apply(root), value);
    }

    public Specification<ENTITY> equivalent(String equals, Function<Root<ENTITY>, Path<?>> pathFunction) {
        return (Specification & Serializable)(root, query, cBuilder) -> cBuilder.equal((Expression)pathFunction.apply(root), (Object)equals);
    }

    public Specification<ENTITY> stringEquivalent(String equals, Function<Root<ENTITY>, Path<String>> pathFunction) {
        return (Specification & Serializable)(root, query, cBuilder) -> cBuilder.equal((Expression)pathFunction.apply(root), (Object)equals);
    }

    public <T> Specification<ENTITY> valueIn(List<T> values, Function<Root<ENTITY>, Path<? extends T>> pathFunction) {
        return (Specification & Serializable)(root, query, cBuilder) -> {
            CriteriaBuilder.In in = cBuilder.in((Expression)pathFunction.apply(root));
            for (Object value : values) {
                in = in.value(value);
            }
            return in;
        };
    }

    public Specification<ENTITY> stringIn(List<String> values, Function<Root<ENTITY>, Path<String>> pathFunction) {
        return (Specification & Serializable)(root, query, cBuilder) -> {
            CriteriaBuilder.In in = cBuilder.in((Expression)pathFunction.apply(root));
            for (String value : values) {
                in = in.value((Object)value);
            }
            return in;
        };
    }

    public Specification<ENTITY> likeUpperSpecification(String contains, Function<Root<ENTITY>, Path<String>> pathFunction) {
        return (Specification & Serializable)(root, query, cBuilder) -> cBuilder.like(cBuilder.upper((Expression)pathFunction.apply(root)), this.wrapLikeQuery(contains));
    }

    public Specification<ENTITY> byFieldSpecified(Boolean specified, Function<Root<ENTITY>, Path<String>> pathFunction) {
        return specified != false ? (Specification & Serializable)(root, query, cBuilder) -> cBuilder.isTrue(((Path)pathFunction.apply(root)).as(Boolean.class)) : (Specification & Serializable)(root, query, cBuilder) -> cBuilder.or((Expression)cBuilder.isFalse(((Path)pathFunction.apply(root)).as(Boolean.class)), (Expression)cBuilder.isNull((Expression)pathFunction.apply(root)));
    }
}

