/*
 * Decompiled with CFR 0.152.
 */
package it.micegroup.voila2runtime.specification;

import it.micegroup.voila2runtime.filter.Filter;
import it.micegroup.voila2runtime.filter.RangeFilter;
import it.micegroup.voila2runtime.filter.StringFilter;
import it.micegroup.voila2runtime.specification.FilterService;
import it.micegroup.voila2runtime.specification.SpecificationGetterService;
import java.io.Serializable;
import java.util.Collection;
import java.util.function.Function;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class FilterServiceImpl<ENTITY>
implements FilterService<ENTITY> {
    @Autowired
    SpecificationGetterService<ENTITY> specGetter;

    public <T extends Serializable> Specification<ENTITY> generateSpecification(Filter<T> filter, SingularAttribute<? super ENTITY, T> field) {
        if (filter.getEquals() != null) {
            return this.specGetter.equivalent(field, (Object)((Serializable)filter.getEquals()));
        }
        if (filter.getIn() != null) {
            return this.specGetter.valueIn(field, (Collection)filter.getIn());
        }
        if (filter.getSpecified() != null) {
            return this.specGetter.byFieldSpecified(field, filter.getSpecified().booleanValue());
        }
        return null;
    }

    public Specification<ENTITY> generateStringSpecification(StringFilter filter, SingularAttribute<? super ENTITY, String> field) {
        if (filter.getEquals() != null) {
            return this.specGetter.equivalent(field, (Object)((String)filter.getEquals()));
        }
        if (filter.getIn() != null) {
            return this.specGetter.valueIn(field, (Collection)filter.getIn());
        }
        if (filter.getContains() != null) {
            return this.specGetter.likeUpperSpecification(field, filter.getContains());
        }
        if (filter.getSpecified() != null) {
            return this.specGetter.byFieldSpecified(field, filter.getSpecified().booleanValue());
        }
        return null;
    }

    public <T extends Serializable & Comparable<? super T>> Specification<ENTITY> generateRangeSpecification(RangeFilter<T> filter, SingularAttribute<? super ENTITY, T> field) {
        if (filter.getEquals() != null) {
            return this.specGetter.equivalent(field, (Object)((Serializable)filter.getEquals()));
        }
        if (filter.getIn() != null) {
            return this.specGetter.valueIn(field, (Collection)filter.getIn());
        }
        Specification result = Specification.where(null);
        if (filter.getSpecified() != null) {
            result = result.and(this.specGetter.byFieldSpecified(field, filter.getSpecified().booleanValue()));
        }
        if (filter.getGreaterThan() != null) {
            result = result.and(this.specGetter.greaterThan(field, (Comparable)((Object)((Serializable)((Object)filter.getGreaterThan())))));
        }
        if (filter.getGreaterOrEqualThan() != null) {
            result = result.and(this.specGetter.greaterThanOrEqualTo(field, (Comparable)((Object)((Serializable)((Object)filter.getGreaterOrEqualThan())))));
        }
        if (filter.getLessThan() != null) {
            result = result.and(this.specGetter.lessThan(field, (Comparable)((Object)((Serializable)((Object)filter.getLessThan())))));
        }
        if (filter.getLessOrEqualThan() != null) {
            result = result.and(this.specGetter.lessThanOrEqualTo(field, (Comparable)((Object)((Serializable)((Object)filter.getLessOrEqualThan())))));
        }
        return result;
    }

    public <OTHER, T extends Serializable & Comparable<? super T>> Specification<ENTITY> generateReferringEntityRangeSpecification(RangeFilter<T> filter, SingularAttribute<? super ENTITY, ? extends OTHER> reference, SingularAttribute<OTHER, T> valueField) {
        if (filter.getEquals() != null) {
            return this.specGetter.equivalent(reference, valueField, (Object)((Serializable)filter.getEquals()));
        }
        if (filter.getGreaterThan() != null) {
            return this.specGetter.greaterThan(reference, valueField, (Comparable)((Object)((Serializable)((Object)filter.getGreaterThan()))));
        }
        if (filter.getGreaterOrEqualThan() != null) {
            return this.specGetter.greaterOrEqualThan(reference, valueField, (Comparable)((Object)((Serializable)((Object)filter.getGreaterOrEqualThan()))));
        }
        if (filter.getLessThan() != null) {
            return this.specGetter.lessThan(reference, valueField, (Comparable)((Object)((Serializable)((Object)filter.getLessThan()))));
        }
        if (filter.getLessOrEqualThan() != null) {
            return this.specGetter.lessOrEqualThan(reference, valueField, (Comparable)((Object)((Serializable)((Object)filter.getLessOrEqualThan()))));
        }
        return null;
    }

    public <OTHER, T extends Serializable & Comparable<? super T>> Specification<ENTITY> generateReferringEntitySpecification(Filter<T> filter, SingularAttribute<? super ENTITY, ? extends OTHER> reference, SingularAttribute<OTHER, T> valueField) {
        if (filter.getEquals() != null) {
            return this.specGetter.equivalent(reference, valueField, (Object)((Serializable)filter.getEquals()));
        }
        if (filter.getIn() != null) {
            return this.specGetter.valueIn(reference, valueField, (Collection)filter.getIn());
        }
        if (filter.getSpecified() != null) {
            return this.specGetter.byFieldSpecified(reference, filter.getSpecified().booleanValue());
        }
        return null;
    }

    public <OTHER> Specification<ENTITY> generateReferringEntityStringSpecification(StringFilter filter, SingularAttribute<? super ENTITY, ? extends OTHER> reference, SingularAttribute<OTHER, String> valueField) {
        if (filter.getEquals() != null) {
            return this.specGetter.equivalent(reference, valueField, (Object)((String)filter.getEquals()));
        }
        if (filter.getContains() != null) {
            return this.specGetter.likeUpperSpecification(reference, valueField, filter.getContains());
        }
        if (filter.getSpecified() != null) {
            return this.specGetter.byFieldSpecified(reference, filter.getSpecified().booleanValue());
        }
        return null;
    }

    public <OTHER, T extends Serializable> Specification<ENTITY> buildReferringEntitySpecification(Filter<T> filter, CollectionAttribute<ENTITY, OTHER> reference, SingularAttribute<OTHER, T> valueField) {
        if (filter.getEquals() != null) {
            return this.specGetter.equivalent(reference, valueField, (Object)((Serializable)filter.getEquals()));
        }
        if (filter.getSpecified() != null) {
            return this.specGetter.byFieldSpecified(reference, filter.getSpecified().booleanValue());
        }
        return null;
    }

    public <OTHER, X extends Serializable, Y> Specification<ENTITY> buildReReferringEntitySpecification(Filter<X> filter, CollectionAttribute<ENTITY, OTHER> reference, SingularAttribute<OTHER, Y> referencedField, SingularAttribute<Y, X> valueField) {
        if (filter.getEquals() != null) {
            return this.specGetter.equivalent(reference, valueField, referencedField, (Object)((Serializable)filter.getEquals()));
        }
        if (filter.getSpecified() != null) {
            return this.specGetter.byFieldSpecified(reference, filter.getSpecified().booleanValue());
        }
        return null;
    }

    public <OTHER, T extends Serializable & Comparable<? super T>> Specification<ENTITY> generateRangeSpecification(RangeFilter<T> filter, Function<Root<ENTITY>, Path<? extends T>> pathFunction) {
        if (filter.getEquals() != null) {
            return this.specGetter.equivalent((Comparable)((Object)((Serializable)filter.getEquals())), pathFunction);
        }
        if (filter.getGreaterThan() != null) {
            return this.specGetter.greaterThan((Comparable)((Object)((Serializable)((Object)filter.getGreaterThan()))), pathFunction);
        }
        if (filter.getGreaterOrEqualThan() != null) {
            return this.specGetter.greaterOrEqualThan((Comparable)((Object)((Serializable)((Object)filter.getGreaterOrEqualThan()))), pathFunction);
        }
        if (filter.getLessThan() != null) {
            return this.specGetter.lessThan((Comparable)((Object)((Serializable)((Object)filter.getLessThan()))), pathFunction);
        }
        if (filter.getLessOrEqualThan() != null) {
            return this.specGetter.lessOrEqualThan((Comparable)((Object)((Serializable)((Object)filter.getLessOrEqualThan()))), pathFunction);
        }
        return null;
    }

    public Specification<ENTITY> generateStringSpecification(StringFilter filter, Function<Root<ENTITY>, Path<String>> pathFunction) {
        if (filter.getEquals() != null) {
            return this.specGetter.stringEquivalent((String)filter.getEquals(), pathFunction);
        }
        if (filter.getIn() != null) {
            return this.specGetter.stringIn(filter.getIn(), pathFunction);
        }
        if (filter.getContains() != null) {
            return this.specGetter.likeUpperSpecification(filter.getContains(), pathFunction);
        }
        if (filter.getSpecified() != null) {
            return this.specGetter.byFieldSpecified(filter.getSpecified(), pathFunction);
        }
        return null;
    }

    public <OTHER, T extends Serializable & Comparable<? super T>> Specification<ENTITY> generateEqualsSpecification(T filter, Function<Root<ENTITY>, Path<? extends T>> pathFunction) {
        if (filter != null) {
            return this.specGetter.equivalent(filter, pathFunction);
        }
        return null;
    }
}

